/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.tool.About;
import org.tizen.emulator.manager.ui.resources.FontKind;
import org.tizen.emulator.manager.ui.resources.Fonts;

public class FXMLAboutViewController
implements Initializable {
    @FXML
    private Label labTitle1;
    @FXML
    private Label labTitle2;
    @FXML
    private Pane titlePane;
    @FXML
    private Label labVersion;
    @FXML
    private Label labBuild;
    @FXML
    private Label linkWorkspace;
    @FXML
    private Hyperlink linkTizenSite;
    private static String DEV_SITE = "https://developer.tizen.org";

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.labTitle1.setFont(Fonts.get(FontKind.FONT_16));
        this.labTitle2.setFont(Fonts.get(FontKind.FONT_32_BOLD));
        String image = this.getClass().getResource("/view/about_bg.png").toExternalForm();
        this.titlePane.setStyle("-fx-background-image: url('" + image + "');-fx-background-position: right;-fx-background-repeat: no-repeat;-fx-background-color: #009ee6;");
        About about = About.getInstance();
        this.labVersion.setText(about.getPackageVersion());
        this.labBuild.setText(about.getBuildTime());
        this.linkWorkspace.setText(about.getWorkspacePath());
        this.linkWorkspace.setTooltip(new Tooltip(about.getWorkspacePath()));
        this.linkTizenSite.setText(DEV_SITE);
    }

    @FXML
    public void clickWorkspace(ActionEvent e) {
    }

    @FXML
    public void clickTizenSite(ActionEvent e) {
        SimpleExecutor.asynExecute(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Desktop.getDesktop().browse(new URI(DEV_SITE));
                }
                catch (IOException | URISyntaxException e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
                return null;
            }
        });
    }
}

