/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.util.HashMap;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tizen.emulator.manager.ui.controller.create.FilterChangeEvent;
import org.tizen.emulator.manager.ui.controller.vms.filter.FilterButton;
import org.tizen.emulator.manager.ui.controller.vms.filter.FilterPopup;

public class FilterController {
    private Labeled owner;
    private final FilterPopup popup;
    private final FilterButton filterButton;
    public Map<String, Boolean> filterValue = new HashMap<String, Boolean>();

    public void setFilterValue(Map<String, Boolean> values) {
        this.filterValue = values;
    }

    public void triggerPopup() {
        this.triggerPopupInternal();
    }

    public FilterController(Labeled node) {
        this.owner = node;
        this.filterButton = new FilterButton();
        this.popup = new FilterPopup();
        this.popup.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                FilterController.this.filterButton.setSelected(false);
            }
        });
        this.filterButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                FilterController.this.triggerPopupInternal();
                arg0.consume();
            }
        });
        this.owner.setGraphic((Node)this.filterButton.getPane());
        this.popup.setSaveEvent(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                FilterController.this.sendEvent();
            }
        });
    }

    private void sendEvent() {
        FilterChangeEvent e = new FilterChangeEvent((Control)this.owner, this.popup.getFilterList(), this.filterButton);
        Event.fireEvent((EventTarget)this.owner, e);
        this.popup.hide();
    }

    public void clearFilters() {
        this.popup.toggleAll(false);
        this.sendEvent();
    }

    private void triggerPopupInternal() {
        if (this.popup.isShowing()) {
            this.popup.hide();
        } else {
            this.popup.createMenuItem(this.filterValue);
            Label c = this.filterButton.getIconLabel();
            Bounds b = c.localToScene(c.getLayoutBounds());
            FilterPopup menu = this.popup;
            Scene scene = c.getScene();
            Window window = scene.getWindow();
            if (b != null) {
                menu.show((Node)c, window.getX() + scene.getX() + b.getMinX(), window.getY() + scene.getY() + b.getMaxY());
            } else {
                menu.show((Node)c, window.getX() + scene.getX(), window.getY() + scene.getY());
            }
        }
    }
}

