/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.control.SimpleEvent;
import org.tizen.emulator.manager.ui.controller.create.PlatformTreeData;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.resources.Images;

public class PlatformTreeCell
extends TreeCell<PlatformTreeData> {
    static final int CELL_HEIGHT = 30;
    static final Color TEXT_FILL_SELECT = Color.web((String)"#008aee");
    static final Color TEXT_FILL_NORMAL = Color.web((String)"#585858");
    HBox disclosureBox;
    Label iconLabel;
    Label nameLabel;
    PlatformTreeData treeData;
    private SimpleObjectProperty<ROW_STATE> state;
    private HBox hBox;
    private final ChangeListener<ROW_STATE> rowStateListener = new ChangeListener<ROW_STATE>(){

        public void changed(ObservableValue<? extends ROW_STATE> arg, ROW_STATE oldValue, ROW_STATE newValue) {
            if (PlatformTreeCell.this.treeData.isRoot()) {
                PlatformTreeCell.this.drawBox(newValue);
            } else {
                PlatformTreeCell.this.setTextColor(newValue);
            }
        }
    };
    private final EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent arg0) {
            if (arg0.getEventType() == MouseEvent.MOUSE_ENTERED) {
                if (PlatformTreeCell.this.state.get() == ROW_STATE.SELECTED) {
                    return;
                }
                PlatformTreeCell.this.state.set((Object)ROW_STATE.OVER);
            } else if (arg0.getEventType() == MouseEvent.MOUSE_EXITED) {
                if (PlatformTreeCell.this.state.get() == ROW_STATE.SELECTED) {
                    return;
                }
                PlatformTreeCell.this.state.set((Object)ROW_STATE.NORMAL);
            } else if (arg0.getEventType() == MouseEvent.MOUSE_CLICKED && arg0.getButton().equals((Object)MouseButton.PRIMARY) && arg0.getClickCount() == 2) {
                Event.fireEvent((EventTarget)PlatformTreeCell.this.getTreeView(), (Event)new SimpleEvent());
            }
        }
    };

    protected void updateItem(PlatformTreeData data, boolean isblank) {
        super.updateItem((Object)data, isblank);
        this.setGraphic(null);
        if (this.state != null) {
            this.state.removeListener(this.rowStateListener);
            this.state = null;
        }
        if (this.hBox != null) {
            this.hBox.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
            this.hBox.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
            if (!this.treeData.isRoot()) {
                this.hBox.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseHandler);
            }
            this.hBox = null;
        }
        if (isblank || data == null) {
            return;
        }
        this.treeData = data;
        this.hBox = new HBox();
        this.iconLabel = new Label();
        this.nameLabel = new Label();
        this.hBox.setAlignment(Pos.CENTER_LEFT);
        this.hBox.setPrefHeight(30.0);
        if (this.treeData.isRoot()) {
            this.hBox.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
            this.hBox.setSpacing(5.0);
            this.disclosureBox = new HBox();
            this.disclosureBox.setPrefHeight(30.0);
            this.disclosureBox.setAlignment(Pos.CENTER);
            this.disclosureBox.setPadding(new Insets(0.0, 0.0, 0.0, 15.0));
            this.disclosureBox.getChildren().add((Object)(this.treeData.expandedProperty().get() ? new ImageView(Images.get(ImageKind.LIST_ARROW_BOTTOM)) : new ImageView(Images.get(ImageKind.LIST_ARROW_RIGHT))));
            this.setDisclosureNode((Node)this.disclosureBox);
            this.nameLabel.setText(this.treeData.getProfile());
            this.nameLabel.getStyleClass().add((Object)"profile-name-label");
        } else {
            this.hBox.addEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseHandler);
            if (this.treeData.isCustom()) {
                this.nameLabel.setText(this.treeData.getName() + " (Custom)");
            } else {
                this.nameLabel.setText(this.treeData.getName() + " (basic)");
            }
        }
        this.hBox.getChildren().addAll((Object[])new Node[]{this.iconLabel, this.nameLabel});
        this.setGraphic((Node)this.hBox);
        this.state = this.treeData.getState();
        if (this.treeData.isRoot()) {
            this.drawBox((ROW_STATE)((Object)this.state.get()));
        } else {
            this.setTextColor((ROW_STATE)((Object)this.state.get()));
        }
        this.state.removeListener(this.rowStateListener);
        this.state.addListener(this.rowStateListener);
        this.hBox.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
        this.hBox.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
    }

    private void drawBox(ROW_STATE state) {
        switch (state) {
            case NORMAL: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.treeData.getIcon())));
                break;
            }
            case OVER: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.treeData.getOverIcon())));
                break;
            }
            case SELECTED: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.treeData.getSelectedIcon())));
                break;
            }
        }
        this.setTextColor(state);
    }

    private void setTextColor(ROW_STATE state) {
        if (this.treeData.isRoot() && state == ROW_STATE.SELECTED) {
            this.nameLabel.setTextFill((Paint)TEXT_FILL_SELECT);
        } else {
            this.nameLabel.setTextFill((Paint)TEXT_FILL_NORMAL);
        }
    }

    static Callback<TreeView<PlatformTreeData>, TreeCell<PlatformTreeData>> extractor() {
        return new Callback<TreeView<PlatformTreeData>, TreeCell<PlatformTreeData>>(){

            public TreeCell<PlatformTreeData> call(TreeView<PlatformTreeData> arg0) {
                return new PlatformTreeCell();
            }
        };
    }
}

