/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import org.tizen.emulator.manager.logging.EMLogger;

public class MacUtil {
    public static void setDockIcon(InputStream is) throws Exception {
        BufferedImage img = ImageIO.read(is);
        String versionStr = System.getProperty("java.version");
        if (versionStr.startsWith("1.")) {
            EMLogger.getLogger().info("JDK 8 and below, set icon using 'com.apple.eawt.Application'");
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Method getAppMethod = appClass.getMethod("getApplication", new Class[0]);
            Object appInstance = getAppMethod.invoke(null, new Object[0]);
            Method setIconMethod = appInstance.getClass().getMethod("setDockIconImage", Image.class);
            setIconMethod.invoke(appInstance, img);
        } else {
            EMLogger.getLogger().info("JDK 9 and above, set icon using 'java.awt.Taskbar'");
            Class<?> taskbarClass = Class.forName("java.awt.Taskbar");
            Method getTaskbarMethod = taskbarClass.getMethod("getTaskbar", new Class[0]);
            Object instance = getTaskbarMethod.invoke(null, new Object[0]);
            Method setIconMethod = instance.getClass().getMethod("setIconImage", Image.class);
            setIconMethod.invoke(instance, img);
        }
    }
}

