/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.network;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.network.WindowsBridge;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessOutputReader;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class WindowsTap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static List<String> getTapListForWin() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList cmd = new ArrayList();
        ProcessBuilder pb = new ProcessBuilder("openvpn", "--show-adapters");
        int exitValue = 0;
        Process process = null;
        try {
            process = pb.start();
            List<String> stdOut = ProcessOutputReader.readStdOut(process, ((Object)cmd).toString());
            exitValue = process.waitFor();
            if (exitValue != 0) {
                EMLogger.getLogger().warning("Get tap list fail. Command returns fail:cmd : " + ((Object)cmd).toString() + ", return : " + exitValue);
            } else {
                for (String line : stdOut) {
                    String[] arr;
                    if (!line.contains("'") || (arr = line.split("'")).length < 2) continue;
                    result.add(arr[1].trim());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.getLogger().warning("Get tap list fail. " + e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
            EMLogger.getLogger().warning("Get tap list fail. " + e.getMessage());
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<String> getTapListForWin2() {
        ArrayList<String> tapNameList = new ArrayList<String>();
        ArrayList<String> tapIdList = NetworkUtil.getTapIdList();
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String key = "Connection";
        String value = "Name";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                for (String tapId : tapIdList) {
                    String[] subKeys2;
                    if (!subKey.equals(tapId)) continue;
                    for (String subKey2 : subKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)(topKey + "\\" + subKey))) {
                        String tapName;
                        if (!subKey2.equals(key) || (tapName = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value)) == null) continue;
                        EMLogger.getLogger().info("tapname added: " + tapName);
                        tapNameList.add(tapName);
                    }
                }
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return tapNameList;
    }

    public static void createNewTap(String tapName) throws VMWorkerException {
        EMLogger.getLogger().info("Get tap list before create new tap.");
        ArrayList<String> before = NetworkUtil.getTapList();
        EMLogger.getLogger().info("Create a new tap.");
        List<String> cmd = Arrays.asList(FilePathResources.getDevconPath(), "install", FilePathResources.getToolEmulatorBinPath() + File.separator + "OemWin2k.inf", "Tap0901");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMWorkerException(res.getResultMessage());
        }
        EMLogger.getLogger().info("Get tap list and find new one.");
        ArrayList<String> after = NetworkUtil.getTapList();
        String newOne = null;
        for (String str : after) {
            if (before.contains(str)) continue;
            newOne = str;
            break;
        }
        if (newOne == null) {
            throw new VMWorkerException("Tap create fail. Cannot find new tap device.");
        }
        EMLogger.getLogger().info("Rename new tap to tapX.");
        cmd = Arrays.asList("netsh", "interface", "set", "interface", "name=" + newOne, "newname=" + tapName);
        res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMWorkerException(res.getResultMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTapBound(String tapName) {
        String foundTapId = null;
        boolean result = false;
        ArrayList<String> tapIdList = NetworkUtil.getTapIdList();
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String key = "Connection";
        String value = "Name";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] valueArr;
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                for (String tapId : tapIdList) {
                    String[] subKeys2;
                    if (!subKey.equals(tapId)) continue;
                    for (String subKey2 : subKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)(topKey + "\\" + subKey))) {
                        String name;
                        if (!subKey2.equals(key) || (name = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value)) == null || !name.equals(tapName)) continue;
                        foundTapId = tapId;
                    }
                }
            }
            EMLogger.getLogger().warning("found tapid: " + foundTapId);
            topKey = OSUtil.isWin8AndAbove() ? "SYSTEM\\CurrentControlSet\\services\\NdisImPlatform\\Linkage" : "SYSTEM\\CurrentControlSet\\services\\Bridge\\Linkage";
            value = "Route";
            for (String str : valueArr = NetworkUtil.registryGetStringArray(root, topKey, value)) {
                if (!str.replace("\"", "").equals(foundTapId)) continue;
                result = true;
                break;
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().warning("Failed to check if tap exists in bridge or not" + e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getHostDefaultGateway() {
        String[] data;
        String gateway = "";
        WinReg.HKEY key = WindowsBridge.getTcpipKey();
        if (key != null) {
            try {
                data = NetworkUtil.registryGetStringArray(key, "DefaultGateway");
                if (data.length > 0) {
                    gateway = data[0];
                }
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)key);
            }
        }
        if (gateway.isEmpty() && (key = NetworkUtil.getInterfaceTcpipKey(WindowsBridge.getClassId())) != null) {
            try {
                data = NetworkUtil.registryGetStringArray(key, "DefaultGateway");
                if (data.length > 0) {
                    gateway = data[0];
                }
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)key);
            }
        }
        return gateway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDns(String tapName) {
        String dns = "";
        WinReg.HKEY key = NetworkUtil.getInterfaceTcpipKey(WindowsBridge.getClassId());
        if (key != null) {
            try {
                String val = Advapi32Util.registryGetStringValue((WinReg.HKEY)key, (String)"NameServer");
                String[] arr = val.split(",");
                if (arr.length > 0) {
                    dns = arr[0];
                }
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)key);
            }
        }
        return dns;
    }
}

