/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.util.SortedSet;
import java.util.TreeSet;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Profile;

public class ProfileList {
    private static final String MOBILE = "mobile";
    private static SortedSet<Profile> profileList = new TreeSet<Profile>();

    public static Profile get(String name) {
        if (name == null || name.isEmpty()) {
            EMLogger.getLogger().warning("profile name is null or empty");
            return null;
        }
        for (Profile profile : profileList) {
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        EMLogger.getLogger().warning("cannot find profile");
        return null;
    }

    public static SortedSet<Profile> getList() {
        return profileList;
    }

    public static boolean isExist(String name) {
        for (Profile profile : profileList) {
            if (!profile.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Profile getDefault() {
        if (profileList.size() == 0) {
            return Profile.createNew(MOBILE);
        }
        return profileList.first();
    }
}

