/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;

public class About {
    private static About about = null;
    private String version = "";
    private String about_version = "";
    private String time = "";
    private String gitVersion = "";
    private String packageVersion = "";
    private String workspace = FilePathResources.getTizenSDKDataVmsPath();
    private String contents = "";

    public static About getInstance() {
        if (about == null) {
            about = new About();
        }
        return about;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private About() {
        Throwable throwable;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("about.properties");
        Properties properties = new Properties();
        String ver = null;
        if (in != null) {
            try {
                properties.load(in);
                this.time = properties.getProperty("build_time");
                this.gitVersion = properties.getProperty("build_git_commit");
                this.packageVersion = properties.getProperty("package_version");
            }
            catch (IOException e1) {
                EMLogger.getLogger().log(Level.SEVERE, e1.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
                }
            }
        }
        try {
            throwable = null;
            try (FileInputStream fis = new FileInputStream(FilePathResources.getTizenSDKPath() + File.separator + "sdk.version");){
                Properties props = new Properties();
                props.load(fis);
                ver = props.getProperty("TIZEN_SDK_VERSION");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
        }
        catch (Exception e) {
            EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
        }
        if (ver == null) {
            try {
                throwable = null;
                try (BufferedReader about = new BufferedReader(new FileReader(new File(FilePathResources.getToolEmulatorEtcPath() + File.separator + "version")));){
                    if (about != null) {
                        ver = about.readLine();
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (FileNotFoundException e) {
                EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
            }
            catch (IOException e) {
                EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        if (ver == null) {
            this.about_version = "undefined";
            this.version = "undefined";
        } else if (ver.indexOf(40) == -1) {
            this.about_version = this.version = ver;
        } else {
            int start = ver.indexOf(40);
            int end = ver.indexOf(41);
            this.version = ver.substring(0, start);
            this.about_version = ver.substring(start + 1, end);
        }
        if (this.time.isEmpty() || this.time.contains("build_time")) {
            this.time = "undefined";
        }
        if (this.gitVersion.isEmpty() || this.gitVersion.contains("build_git_commit")) {
            this.gitVersion = "undefined";
        }
        if (this.workspace.isEmpty()) {
            this.workspace = "undefined";
        }
        if (this.packageVersion == null || this.packageVersion.isEmpty()) {
            this.packageVersion = "undefined";
        }
        this.contents = "Version: " + this.about_version + StringResources.NEW_LINE + "Build time: " + this.time + " (GMT)" + StringResources.NEW_LINE + "Workspace path: " + this.workspace + StringResources.NEW_LINE + "Package version: " + this.packageVersion;
    }

    public void printSystemInformation() {
        String systemInfo = "";
        systemInfo = systemInfo + "JAVA HOME: " + System.getProperty("java.home") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "JAVA VENDOR: " + System.getProperty("java.vendor") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "JAVA VERSION: " + System.getProperty("java.version") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "OS ARCH: " + System.getProperty("os.arch") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "OS NAME: " + System.getProperty("os.name") + StringResources.NEW_LINE;
        systemInfo = systemInfo + "OS VERSION: " + System.getProperty("os.version") + StringResources.NEW_LINE;
        EMLogger.getLogger().info("System Information" + StringResources.NEW_LINE + systemInfo);
        EMLogger.getLogger().info("EmulatorManager Information" + StringResources.NEW_LINE + this.contents);
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildTime() {
        return this.time;
    }

    @Deprecated
    public String getGitVersion() {
        return this.gitVersion;
    }

    public String getWorkspacePath() {
        return this.workspace;
    }

    public String getAboutVersion() {
        return this.about_version;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }
}

