/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.io.IOException;
import java.util.ArrayList;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.type.OCI;

public class OCIList {
    private ArrayList<OCI> OCIDeviceList = new ArrayList();
    private ArrayList<OCI> OCISelectDeviceList = new ArrayList();
    private static OCIList instance = null;

    public static OCIList getInstance() {
        return instance;
    }

    private OCIList() {
    }

    public void clearOCIList() {
        this.OCIDeviceList.clear();
        this.OCISelectDeviceList.clear();
    }

    public void makeOCIList(String deviceName, int addr, int bus) {
        int i = 0;
        OCI s = null;
        try {
            s = new OCI(i, deviceName, addr, bus);
        }
        catch (IOException e) {
            EMLogger.getLogger().warning("Failed adding OCI Device.." + StringResources.NEW_LINE + "Error: " + e.getMessage());
        }
        this.OCIDeviceList.add(s);
    }

    public ArrayList<OCI> getOCISelectList() {
        return this.OCISelectDeviceList;
    }

    public ArrayList<OCI> getOCIList() {
        return this.OCIDeviceList;
    }

    public OCI findOCIDeviceName(String name) {
        if (this.OCIDeviceList != null) {
            for (OCI OCI2 : this.OCIDeviceList) {
                if (!OCI2.getName().equals(name)) continue;
                return OCI2;
            }
        }
        return null;
    }

    public boolean findOCISelectDiviceName(String name) {
        if (this.OCISelectDeviceList != null) {
            for (OCI OCI2 : this.OCISelectDeviceList) {
                if (!OCI2.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public int getOCICount() {
        int i = 0;
        if (this.OCIDeviceList != null) {
            i = this.OCIDeviceList.size();
        }
        return i;
    }

    public int getSelectedOCICount() {
        int i = 0;
        if (this.OCISelectDeviceList != null) {
            i = this.OCISelectDeviceList.size();
        }
        return i;
    }

    public void selectOCI(OCI oci) {
        this.OCISelectDeviceList.clear();
        this.OCISelectDeviceList.add(oci);
    }

    static {
        instance = new OCIList();
    }
}

