/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import org.tizen.emulator.manager.vms.DiskImageFormat;
import org.tizen.emulator.manager.vms.DiskImageType;
import org.tizen.emulator.manager.vms.VMOption;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.type.CPU;
import org.tizen.emulator.manager.vms.xml.DeviceTemplateType;
import org.tizen.emulator.manager.vms.xml.DiskImageFileType;
import org.tizen.emulator.manager.vms.xml.EmulatorConfiguration;
import org.tizen.emulator.manager.vms.xml.ObjectFactory;
import org.tizen.emulator.manager.vms.xml.OptionType;
import org.tizen.emulator.manager.vms.xml.SubOptionType;

public class VMConfigurationCreator {
    private static final ObjectFactory factory = new ObjectFactory();

    public static EmulatorConfiguration create(VMPropertyValue value) {
        EmulatorConfiguration configuration = factory.createEmulatorConfiguration();
        configuration.setBaseInformation(factory.createBaseInformationType());
        configuration.setUsability(factory.createUsabilityType());
        configuration.setDevice(factory.createDeviceType());
        configuration.getBaseInformation().setName(value.vmName);
        configuration.getBaseInformation().setArchitecture(value.getImageArch().toString());
        configuration.getBaseInformation().setPlatform(value.getPlatform().toString());
        if (value.deviceName != null && !value.deviceName.isEmpty()) {
            DeviceTemplateType device = new DeviceTemplateType();
            device.setName(value.deviceName);
            device.setVersion(value.deivceVersion);
            device.setPath(value.devicePath);
            configuration.getBaseInformation().setDeviceTemplate(device);
        }
        configuration.getBaseInformation().setDiskImage(factory.createBaseInformationTypeDiskImage());
        if (value.isStandardImage()) {
            configuration.getBaseInformation().getDiskImage().setType("standard");
        } else {
            configuration.getBaseInformation().getDiskImage().setType("custom");
        }
        if (value.getImageVersion() != null) {
            configuration.getBaseInformation().getDiskImage().setVersion(value.getImageVersion());
        } else {
            configuration.getBaseInformation().getDiskImage().setVersion("Standard");
        }
        configuration.getBaseInformation().getDiskImage().setProfile(value.getProfile());
        DiskImageFileType diskImageFileType = factory.createDiskImageFileType();
        if (value.useQCOW2()) {
            diskImageFileType = factory.createDiskImageFileType();
            diskImageFileType.setFormat(DiskImageFormat.QCOW2.getName());
            diskImageFileType.setType(DiskImageType.CHILD.getName());
            diskImageFileType.setValue(value.childImagePath);
            configuration.getBaseInformation().getDiskImage().getDiskImageFile().add(diskImageFileType);
        }
        DiskImageFormat format = value.getImageFormat();
        for (String imagePath : value.getImagePathList()) {
            diskImageFileType = factory.createDiskImageFileType();
            diskImageFileType.setFormat(format.getName());
            diskImageFileType.setValue(imagePath);
            if (value.useQCOW2()) {
                diskImageFileType.setType(DiskImageType.BASE.getName());
            }
            if (!value.getImageBinaryVersion().isEmpty()) {
                diskImageFileType.setVersion(value.getImageBinaryVersion());
            }
            configuration.getBaseInformation().getDiskImage().getDiskImageFile().add(diskImageFileType);
        }
        if (value.swapImagePath != null) {
            diskImageFileType = factory.createDiskImageFileType();
            diskImageFileType.setFormat(DiskImageFormat.QCOW2.getName());
            diskImageFileType.setType(DiskImageType.SWAP.getName());
            diskImageFileType.setValue(value.swapImagePath);
            configuration.getBaseInformation().getDiskImage().getDiskImageFile().add(diskImageFileType);
        }
        configuration.getUsability().setLogging(factory.createUsabilityTypeLogging());
        configuration.getUsability().getLogging().setLevel("NONE");
        configuration.getUsability().setHwVirtualization(value.isHWVirtualization);
        configuration.getUsability().setHwGLAcceleration(value.isGLAcceleration);
        configuration.getUsability().setSupportSuspend(value.isSupportSuspend);
        configuration.getUsability().setFileSharing(factory.createUsabilityTypeFileSharing());
        if (!value.fileSharePath.isEmpty()) {
            configuration.getUsability().getFileSharing().setPath(value.fileSharePath);
        }
        configuration.getDevice().setDisplay(factory.createDisplayType());
        configuration.getDevice().getDisplay().setResolution(factory.createDisplayTypeResolution());
        configuration.getDevice().getDisplay().getResolution().setWidth(value.resolution.getWidth());
        configuration.getDevice().getDisplay().getResolution().setHeight(value.resolution.getHeight());
        configuration.getDevice().getDisplay().setDensity(factory.createDisplayTypeDensity());
        configuration.getDevice().getDisplay().getDensity().setUnit("dpi");
        configuration.getDevice().getDisplay().getDensity().setValue(value.dpi);
        if (value.screenSize > 0.0) {
            configuration.getDevice().getDisplay().setScreenSize(factory.createDisplayTypeScreenSize());
            configuration.getDevice().getDisplay().getScreenSize().setUnit("inch");
            configuration.getDevice().getDisplay().getScreenSize().setValue(value.screenSize);
        }
        configuration.getDevice().getDisplay().setSkinPath(factory.createDisplayTypeSkinPath());
        if (value.skin != null) {
            configuration.getDevice().getDisplay().getSkinPath().setPath(value.skin.getPath());
        } else if (value.skinPath != null) {
            configuration.getDevice().getDisplay().getSkinPath().setPath(value.skinPath);
        }
        configuration.getDevice().setCPU(factory.createCpuType());
        configuration.getDevice().getCPU().setValue(factory.createCpuTypeValue());
        configuration.getDevice().getCPU().getValue().setUnit("cpu");
        if (value.cpu == 0) {
            int max = CPU.getMaxCpuNum();
            value.cpu = max > 4 ? 4 : max;
        }
        configuration.getDevice().getCPU().getValue().setValue(value.cpu);
        configuration.getDevice().setRAM(factory.createRamType());
        configuration.getDevice().getRAM().setSize(factory.createRamTypeSize());
        configuration.getDevice().getRAM().getSize().setUnit("MiB");
        configuration.getDevice().getRAM().getSize().setValue(value.ramSize);
        if (value.maxTouchCount >= 0) {
            configuration.getDevice().setTouch(factory.createTouchType());
            configuration.getDevice().getTouch().setMaxTouchPoint(value.maxTouchCount);
        }
        if (value.ociOptions != null) {
            configuration.setOci(factory.createOciType());
            configuration.getOci().setOciOptions(value.ociOptions);
        }
        if (value.advancedVMOptionList.size() > 0) {
            if (configuration.getAdvancedOption() == null) {
                configuration.setAdvancedOption(factory.createAdvancedOptionType());
            } else {
                configuration.getAdvancedOption().getOption().clear();
            }
            for (VMOption option : value.advancedVMOptionList) {
                OptionType type = new OptionType();
                type.setName(option.getName());
                type.setValue(option.getValue());
                for (VMOption subOption : option.getSubOptionList()) {
                    SubOptionType subType = new SubOptionType();
                    subType.setName(subOption.getName());
                    subType.setValue(subOption.getValue());
                    type.getSubOption().add(subType);
                }
                configuration.getAdvancedOption().getOption().add(type);
            }
        }
        return configuration;
    }
}

