/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.io.File;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class DisplayOption
extends Option {
    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) {
        String skinPath = property.getPropertyValue().skinPath;
        if (skinPath != null && skinPath.isEmpty()) {
            skinPath = null;
        }
        int width = property.getPropertyValue().resolution.getWidth();
        int height = property.getPropertyValue().resolution.getHeight();
        int dpi = property.getPropertyValue().dpi;
        if (skinPath != null) {
            config.addVariableWithSpace(OPTION_KEY.VAR_SKIN_PATH, skinPath);
        }
        OPTION_KEY opt_resolution = OPTION_KEY.VAR_RESOLUTION;
        String dpiValue = String.valueOf(dpi * 10);
        String version = property.getPropertyValue().getImageVersion();
        if (DisplayOption.isGreaterThanOrEqualTo(version, "2.3.2")) {
            opt_resolution = OPTION_KEY.VAR_DISPLAY_RESOLUTION;
            config.addVariable(OPTION_KEY.VAR_DISPLAY_PIXEL_DENSITY, String.valueOf(dpi));
            dpiValue = DisplayOption.varForm(OPTION_KEY.VAR_DISPLAY_PIXEL_DENSITY);
        }
        config.addVariable(opt_resolution, width + "x" + height);
        if (DisplayOption.isLesserThan(version, "2.3.2")) {
            config.addSkinOption("resolution", DisplayOption.varForm(opt_resolution));
            config.addSkinOption("skin.path", DisplayOption.varForm(OPTION_KEY.VAR_SKIN_PATH));
            config.addSkinOption("vm.path", DisplayOption.varForm(OPTION_KEY.VAR_VMS_PATH) + File.separator + DisplayOption.varForm(OPTION_KEY.VAR_VM_NAME));
        }
        config.addKernelOption("video", "LVDS-1:" + DisplayOption.varForm(opt_resolution) + "-32@60");
        config.addKernelOption("dpi", dpiValue);
        config.addKernelOption("clocksource", "hpet");
        config.addKernelOption("consoleblank", "0");
    }
}

