/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.type;

public enum Architecture {
    x86("x86", 32),
    i386("i386", 32),
    x86_64("x86_64", 64);

    private String name;
    private int bit;

    private Architecture(String arch, int bit) {
        this.name = arch;
        this.bit = bit;
    }

    public String toString() {
        return this.name;
    }

    public int getBit() {
        return this.bit;
    }

    public int compare(Architecture obj) {
        if (this == obj) {
            return 0;
        }
        if ((this == x86 || this == i386) && obj == x86_64) {
            return 1;
        }
        return -1;
    }

    public static Architecture getDisplayType(String arch) {
        if (arch.equals(Architecture.x86.name) || arch.equals(Architecture.i386.name)) {
            return x86;
        }
        for (Architecture type : Architecture.values()) {
            if (!arch.equals(type.name)) continue;
            return type;
        }
        return x86;
    }

    public static Architecture getType(String arch) {
        for (Architecture type : Architecture.values()) {
            if (!arch.equals(type.name)) continue;
            return type;
        }
        return x86;
    }
}

