#!/bin/sh

## User Define for desktop menu
desktoppath=~/.local/share/applications

## Do not modify the followings (Make desktop menu)
TIZEN_SDK_INSTALL_PATH=${INSTALLED_PATH}
if [ -z "$TIZEN_SDK_INSTALL_PATH" ]
then
   exit 2;
fi

## em shortcut
em_desktopfile=${desktoppath}/tizen-studio-em.desktop
em_iconfile=em.ico
em_iconpath=${TIZEN_SDK_INSTALL_PATH}/tools/emulator/icons
em_exefile=tools/emulator/bin/emulator-manager
em_exepath=${TIZEN_SDK_INSTALL_PATH}/$em_exefile
em_comment="Emulator manager of Tizen Studio is a tool which controls Virtual Machines."
em_name="Emulator Manager"

if [ -e "${MAKESHORTCUT_PATH}" ]
then
	"${MAKESHORTCUT_PATH}" \
		-f "${em_desktopfile}" \
		-e "${em_exepath}" \
		-i "${em_iconpath}/$em_iconfile" \
		-n "${em_name}" \
		-c "${em_comment}"
else
	echo ${MAKESHORTCUT_PATH} does not exist
fi

## make $USERNAME.lock file
echo ${SDK_DATA_PATH} > "${TIZEN_SDK_INSTALL_PATH}/tools/emulator/bin/.$USER.lock"
exit 0
