/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform.custom;

import java.io.File;
import java.util.ArrayList;
import org.tizen.emulator.manager.baseimage.xml.BaseImageConfiguration;
import org.tizen.emulator.manager.baseimage.xml.BaseImageType;
import org.tizen.emulator.manager.baseimage.xml.ObjectFactory;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.custom.CustomPlatform;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageValue;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.JAXBHelper;
import org.tizen.emulator.manager.vms.DiskImageFormat;

public class CustomPlatformImageLoader {
    public static boolean initialized = false;
    private static File baseImageConfFile;
    private static BaseImageConfiguration conf;
    private static String lastDirectory;

    public static void initialize() {
        if (initialized) {
            return;
        }
        CustomPlatformImageLoader.loadConfiguration();
        initialized = true;
    }

    public static String getLastDirectroy() {
        if (lastDirectory == null || lastDirectory.isEmpty()) {
            lastDirectory = FilePathResources.getTizenSDKDataEmulatorPath();
        }
        return lastDirectory;
    }

    public static void setLastDirectory(String path) {
        if (path == null || path.isEmpty()) {
            return;
        }
        File dir = new File(path);
        if (!dir.isDirectory() || !dir.exists()) {
            return;
        }
        lastDirectory = path;
    }

    public static boolean saveBaseImageConfiguration() {
        File parentFile;
        ObjectFactory factory = new ObjectFactory();
        conf = factory.createBaseImageConfiguration();
        ArrayList list = (ArrayList)conf.getCustomBaseImage();
        for (Platform platform : PlatformList.getList()) {
            if (!(platform instanceof CustomPlatform)) continue;
            BaseImageType type = factory.createBaseImageType();
            CustomPlatformImageLoader.settingConfiguration((CustomPlatform)platform, type);
            list.add(type);
        }
        conf.setLastDirectory(CustomPlatformImageLoader.getLastDirectroy());
        if (!baseImageConfFile.exists() && baseImageConfFile.getParentFile() != null && !(parentFile = baseImageConfFile.getParentFile()).mkdirs()) {
            EMLogger.getLogger().warning("Failed to create directory " + parentFile.getAbsolutePath());
        }
        if (!JAXBHelper.storeXML(baseImageConfFile.toPath(), conf)) {
            EMLogger.getLogger().warning("Failed to save custom base image configuration");
            return false;
        }
        return true;
    }

    private static void settingConfiguration(CustomPlatform platform, BaseImageType type) {
        type.setName(platform.getName());
        type.setProfile(platform.getProfile().getName());
        type.setPlatform(platform.getBasePlatform().getName());
        type.setImageFormat(platform.getImageFormat().getName());
        for (String path : platform.getImagePathList()) {
            type.getPath().add(path);
        }
        type.setDescription(platform.getImageDescription());
    }

    private static synchronized void loadConfiguration() {
        if (baseImageConfFile == null || !baseImageConfFile.exists()) {
            return;
        }
        conf = JAXBHelper.parseXML(baseImageConfFile.toPath(), BaseImageConfiguration.class);
        if (conf == null) {
            EMLogger.getLogger().warning("Failed to load custom base image configuration file - " + baseImageConfFile.getName());
            return;
        }
        for (BaseImageType image : conf.getCustomBaseImage()) {
            CustomPlatformImageValue value = new CustomPlatformImageValue();
            value.setID(image.getId());
            value.setName(image.getName());
            value.setProfile(image.getProfile());
            value.setPlatformName(image.getPlatform());
            String format = image.getImageFormat();
            if (format == null) {
                format = "";
            }
            value.setImageFormat(DiskImageFormat.find(format));
            for (String path : image.getPath()) {
                value.getPathList().add(path);
            }
            value.setDescription(image.getDescription() == null ? "" : image.getDescription());
            Platform basePlatform = PlatformList.get(value.getPlatformName());
            value.setPlatform(basePlatform);
            Platform platform = Platform.createCustomInstance(value);
            if (platform == null) continue;
        }
    }

    static {
        conf = null;
        baseImageConfFile = new File(FilePathResources.getTizenSDKDataEmulatorPath() + File.separator + "custom-base-images.xml");
    }
}

