/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.concurrent.TaskCompletionListener;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.controller.create.FilterChangeEvent;
import org.tizen.emulator.manager.ui.controller.create.FilterController;
import org.tizen.emulator.manager.ui.controller.create.PlatformCheckBoxCell;
import org.tizen.emulator.manager.ui.controller.create.PlatformItem;
import org.tizen.emulator.manager.ui.controller.create.PlatformTableSelectionListener;
import org.tizen.emulator.manager.ui.controller.vms.CheckBoxTableColumn;
import org.tizen.emulator.manager.ui.controller.vms.VMCheckSelectEvent;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.dialog.PlatformInstallDialog;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessOutputReader;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class PlatformInstallationDialogController
implements Initializable {
    @FXML
    private AnchorPane rootPane;
    @FXML
    private VBox rootBox;
    @FXML
    private HBox noticeBox;
    @FXML
    private VBox tableHeaderBox;
    @FXML
    private HBox tableBox;
    @FXML
    private Button profileBtn;
    @FXML
    private Button versionBtn;
    @FXML
    private Button refreshBtn;
    @FXML
    private AnchorPane tableAnchor;
    @FXML
    private AnchorPane progressPane;
    @FXML
    private TableView<PlatformItem> platformTable;
    @FXML
    private CheckBoxTableColumn<PlatformItem, Boolean> checkBox;
    @FXML
    private TableColumn<PlatformItem, String> profileColumn;
    @FXML
    private TableColumn<PlatformItem, String> versionColumn;
    @FXML
    private final ObservableList<PlatformItem> tableData = FXCollections.observableArrayList();
    private ObservableList<String> profileFilters = FXCollections.observableArrayList();
    private ObservableList<String> versionFilters = FXCollections.observableArrayList();
    private final ObservableSet<String> profileSet = FXCollections.observableSet((Object[])new String[0]);
    private final ObservableSet<String> versionSet = FXCollections.observableSet((Object[])new String[0]);
    private FilterController profileFilterController;
    private FilterController versionFilterController;
    Process sdkUtilProcess = null;
    private Label placeHolderLabel;
    private StringProperty placeHolderText;
    PlatformTableSelectionListener selectionListener;
    private ProgressIndicator progress;
    private Label progressText;
    private static Double PROGRESS_SIZE = 70.0;
    private TaskCompletionListener<List<String>> platformListCompletionListener = new TaskCompletionListener<List<String>>(){

        @Override
        public void completed(final List<String> platformList) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (PlatformInstallDialog.dialogClosed) {
                        EMLogger.getLogger().info("Inquiring platforms finished. But dialog already closed.");
                        return;
                    }
                    PlatformInstallationDialogController.this.progressPane.setVisible(false);
                    PlatformInstallationDialogController.this.refreshBtn.setDisable(false);
                    if (platformList == null || platformList.isEmpty()) {
                        PlatformInstallationDialogController.this.placeHolderText.set((Object)("No installable platforms found!." + StringResources.NEW_LINE + StringResources.NEW_LINE + "All platforms may be already installed." + StringResources.NEW_LINE + "If not, you can refresh the list."));
                        return;
                    }
                    PlatformInstallationDialogController.this.checkBox.checkCountProperty().set(0);
                    PlatformInstallationDialogController.this.tableData.clear();
                    for (String platform : platformList) {
                        PlatformItem item = new PlatformItem(platform, PlatformInstallationDialogController.this.checkBox.checkCountProperty());
                        PlatformInstallationDialogController.this.tableData.add((Object)item);
                        PlatformInstallationDialogController.this.profileSet.add((Object)item.getProfile());
                        PlatformInstallationDialogController.this.versionSet.add((Object)item.getVersion());
                    }
                    PlatformInstallationDialogController.this.profileFilters.addAll((Collection)PlatformInstallationDialogController.this.profileSet);
                    PlatformInstallationDialogController.this.versionFilters.addAll((Collection)PlatformInstallationDialogController.this.versionSet);
                    PlatformInstallationDialogController.this.setProfileFilterPopupValue();
                    PlatformInstallationDialogController.this.setVersionFilterPopupValue();
                    final FilteredList filteredData = new FilteredList(PlatformInstallationDialogController.this.tableData, p -> true);
                    PlatformInstallationDialogController.this.profileFilters.addListener((ListChangeListener)new ListChangeListener<String>(){

                        public void onChanged(ListChangeListener.Change<? extends String> c) {
                            PlatformInstallationDialogController.this.platformTable.getSelectionModel().clearSelection();
                            filteredData.setPredicate(platformItem -> PlatformInstallationDialogController.this.checkFilter(platformItem));
                        }
                    });
                    PlatformInstallationDialogController.this.versionFilters.addListener((ListChangeListener)new ListChangeListener<String>(){

                        public void onChanged(ListChangeListener.Change<? extends String> c) {
                            PlatformInstallationDialogController.this.platformTable.getSelectionModel().clearSelection();
                            filteredData.setPredicate(platformItem -> PlatformInstallationDialogController.this.checkFilter(platformItem));
                        }
                    });
                    SortedList sortedData = new SortedList((ObservableList)filteredData);
                    sortedData.setComparator((Comparator)new Comparator<PlatformItem>(){

                        @Override
                        public int compare(PlatformItem item1, PlatformItem item2) {
                            int compare;
                            Version version1 = item1.getPlatformVersion();
                            Version version2 = item2.getPlatformVersion();
                            if (version1 != null && version2 != null && (compare = version2.compareTo(version1)) != 0) {
                                return compare;
                            }
                            compare = item1.getProfile().compareTo(item2.getProfile());
                            return compare;
                        }
                    });
                    PlatformInstallationDialogController.this.platformTable.setItems((ObservableList)sortedData);
                    if (sortedData.size() > 0) {
                        PlatformInstallationDialogController.this.platformTable.getSelectionModel().select(0);
                    }
                    PlatformInstallationDialogController.this.platformTable.getItems().addListener((ListChangeListener)new ListChangeListener<PlatformItem>(){

                        public void onChanged(ListChangeListener.Change<? extends PlatformItem> c) {
                            if (c.getList().size() != 0) {
                                PlatformInstallationDialogController.this.platformTable.getSelectionModel().select(0);
                            }
                        }
                    });
                }
            });
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        GridPane noticeGrid = new GridPane();
        this.noticeBox.getChildren().add((Object)noticeGrid);
        Label noticeLabel1 = new Label("Note : ");
        noticeLabel1.setStyle("-fx-font-weight: bold;");
        Label noticeLabel2 = new Label("The Package Manager launches to install the selected platforms.");
        Label noticeLabel3 = new Label("When installation is complete, the Emulator Manager relaunches automatically.");
        noticeGrid.add((Node)noticeLabel1, 0, 0);
        noticeGrid.add((Node)noticeLabel2, 1, 0);
        noticeGrid.add((Node)noticeLabel3, 1, 1);
        this.refreshBtn.setTooltip(new Tooltip("Request platform list from repository server." + StringResources.NEW_LINE + "This may take a little seconds."));
        this.intializeTable();
    }

    @FXML
    void onProfileBtnClicked(ActionEvent event) {
        this.profileFilterController.triggerPopup();
    }

    @FXML
    void onVersionBtnClicked(ActionEvent event) {
        this.versionFilterController.triggerPopup();
    }

    @FXML
    void onRefreshBtnClicked(ActionEvent event) {
        this.tryGettingPlatformList(true);
    }

    public void setOKButton(final Button okButton) {
        if (this.selectionListener != null) {
            okButton.disableProperty().bind((ObservableValue)this.selectionListener.getOkButtonDisable());
        }
        okButton.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                okButton.requestFocus();
            }
        });
    }

    public void tryGettingPlatformList(boolean useCache) {
        this.clearFilters();
        this.tableData.clear();
        this.refreshBtn.setDisable(true);
        this.placeHolderText.set((Object)"");
        this.progressPane.setVisible(true);
        this.getPlatformListFromRemote(useCache);
    }

    private void updateProgressPosition(double tableWidth, double tableHeight) {
        if (this.progress == null || this.progressText == null) {
            return;
        }
        if (tableWidth != 0.0) {
            AnchorPane.setLeftAnchor((Node)this.progress, (Double)(tableWidth / 2.0 - PROGRESS_SIZE / 2.0));
            AnchorPane.setLeftAnchor((Node)this.progressText, (Double)(tableWidth / 2.0 - this.progressText.getPrefWidth() / 2.0));
        }
        if (tableHeight != 0.0) {
            AnchorPane.setTopAnchor((Node)this.progress, (Double)(tableHeight / 2.0 - PROGRESS_SIZE / 2.0));
            AnchorPane.setTopAnchor((Node)this.progressText, (Double)(tableHeight / 2.0 - this.progressText.getPrefHeight() / 2.0));
        }
    }

    private void intializeTable() {
        this.selectionListener = new PlatformTableSelectionListener(this.platformTable);
        this.platformTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.platformTable.getSelectionModel().getSelectedIndices().addListener((ListChangeListener)this.selectionListener);
        this.placeHolderLabel = new Label();
        this.placeHolderText = new SimpleStringProperty();
        this.placeHolderLabel.textProperty().bind((ObservableValue)this.placeHolderText);
        this.platformTable.setPlaceholder((Node)this.placeHolderLabel);
        this.checkBox.setCellValueFactory((Callback)new PropertyValueFactory("checked"));
        this.checkBox.setCellFactory(PlatformCheckBoxCell.extractor());
        this.profileColumn.setCellValueFactory((Callback)new PropertyValueFactory("profile"));
        this.versionColumn.setCellValueFactory((Callback)new PropertyValueFactory("version"));
        this.progressPane.setVisible(false);
        this.progress = new ProgressIndicator();
        this.progress.setOpacity(0.5);
        this.progress.setPrefSize(PROGRESS_SIZE.doubleValue(), PROGRESS_SIZE.doubleValue());
        this.progressPane.getChildren().add((Object)this.progress);
        this.tableAnchor.layout();
        this.progressText = new Label("Getting list from repository server ...");
        this.progressText.setPrefSize(this.tableAnchor.getPrefWidth() - 10.0, 20.0);
        this.progressText.setAlignment(Pos.CENTER);
        this.progressText.setStyle("-fx-text-fill:#888888");
        this.progressPane.getChildren().add((Object)this.progressText);
        this.platformTable.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> source, Number oldWidth, Number newWidth) {
                PlatformInstallationDialogController.this.updateProgressPosition(0.0, PlatformInstallationDialogController.this.platformTable.getHeight());
            }
        });
        this.platformTable.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> source, Number oldWidth, Number newWidth) {
                PlatformInstallationDialogController.this.updateProgressPosition(PlatformInstallationDialogController.this.platformTable.getWidth(), 0.0);
            }
        });
        this.platformTable.getColumns().addListener(new ListChangeListener<TableColumn<PlatformItem, ?>>(){

            public void onChanged(ListChangeListener.Change<? extends TableColumn<PlatformItem, ?>> change) {
                change.next();
                if (change.wasReplaced()) {
                    PlatformInstallationDialogController.this.platformTable.getColumns().clear();
                    PlatformInstallationDialogController.this.platformTable.getColumns().addAll((Object[])new TableColumn[]{PlatformInstallationDialogController.this.checkBox, PlatformInstallationDialogController.this.profileColumn, PlatformInstallationDialogController.this.versionColumn});
                }
            }
        });
        this.updateProgressPosition(this.tableAnchor.getPrefWidth(), this.tableAnchor.getPrefHeight());
        this.platformTable.addEventHandler(VMCheckSelectEvent.VM_CHECK_SELECTED, (EventHandler)new EventHandler<VMCheckSelectEvent>(){

            public void handle(VMCheckSelectEvent arg0) {
                if (PlatformInstallationDialogController.this.platformTable.getItems().size() < 1) {
                    return;
                }
                if (arg0.isChecked()) {
                    PlatformInstallationDialogController.this.platformTable.getSelectionModel().selectAll();
                } else {
                    PlatformInstallationDialogController.this.platformTable.getSelectionModel().clearSelection();
                }
            }
        });
        this.profileFilterController = new FilterController((Labeled)this.profileBtn);
        this.versionFilterController = new FilterController((Labeled)this.versionBtn);
        this.profileBtn.addEventHandler(FilterChangeEvent.FILTER_CHANGED_EVENT, new EventHandler<FilterChangeEvent<?>>(){

            public void handle(FilterChangeEvent<?> e) {
                PlatformInstallationDialogController.this.profileFilters.clear();
                PlatformInstallationDialogController.this.profileFilters.addAll(e.getFilters());
                PlatformInstallationDialogController.this.setProfileFilterPopupValue();
                boolean isFilterWorking = false;
                for (String version : PlatformInstallationDialogController.this.profileSet) {
                    if (PlatformInstallationDialogController.this.profileFilters.contains((Object)version)) continue;
                    isFilterWorking = true;
                    break;
                }
                e.getFilterButton().changeIcon(isFilterWorking);
            }
        });
        this.versionBtn.addEventHandler(FilterChangeEvent.FILTER_CHANGED_EVENT, new EventHandler<FilterChangeEvent<?>>(){

            public void handle(FilterChangeEvent<?> e) {
                PlatformInstallationDialogController.this.versionFilters.clear();
                PlatformInstallationDialogController.this.versionFilters.addAll(e.getFilters());
                PlatformInstallationDialogController.this.setVersionFilterPopupValue();
                boolean isFilterWorking = false;
                for (String version : PlatformInstallationDialogController.this.versionSet) {
                    if (PlatformInstallationDialogController.this.versionFilters.contains((Object)version)) continue;
                    isFilterWorking = true;
                    break;
                }
                e.getFilterButton().changeIcon(isFilterWorking);
            }
        });
        this.profileBtn.setDisable(true);
        this.versionBtn.setDisable(true);
        this.profileSet.addListener((SetChangeListener)new SetChangeListener<String>(){

            public void onChanged(SetChangeListener.Change<? extends String> change) {
                PlatformInstallationDialogController.this.profileBtn.setDisable(PlatformInstallationDialogController.this.profileSet.size() == 0);
            }
        });
        this.versionSet.addListener((SetChangeListener)new SetChangeListener<String>(){

            public void onChanged(SetChangeListener.Change<? extends String> change) {
                PlatformInstallationDialogController.this.versionBtn.setDisable(PlatformInstallationDialogController.this.versionSet.size() == 0);
            }
        });
    }

    private void setProfileFilterPopupValue() {
        HashMap<String, Boolean> filterValue = new HashMap<String, Boolean>();
        for (String p : this.profileSet) {
            filterValue.put(p, this.profileFilters.contains((Object)p));
        }
        this.profileFilterController.setFilterValue(filterValue);
    }

    private void setVersionFilterPopupValue() {
        TreeMap<String, Boolean> filterValue = new TreeMap<String, Boolean>(Collections.reverseOrder());
        for (String p : this.versionSet) {
            filterValue.put(p, this.versionFilters.contains((Object)p));
        }
        this.versionFilterController.setFilterValue(filterValue);
    }

    private void getPlatformListFromRemote(final boolean useCache) {
        SimpleExecutor.asynExecute(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ProcessResult result;
                String sdkUtil = OSUtil.isWin() ? "sdk-utils.bat" : "sdk-utils.sh";
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(FilePathResources.getTizenSDKUtilPath() + File.separator + sdkUtil);
                cmd.add("show-packages");
                cmd.add("--pkg-type");
                cmd.add("meta-pkg");
                if (useCache) {
                    cmd.add("--cache");
                }
                if (!(result = HelperClass.runProcess(cmd, false)).isStartedSuccessfully()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.error("Failed to launch sdk-utils.\n" + result.getResultMessage());
                        }
                    });
                    EMLogger.getLogger().warning("Failed to launch sdk-utils.");
                    EMLogger.getLogger().warning(result.getResultMessage());
                    return null;
                }
                PlatformInstallationDialogController.this.sdkUtilProcess = result.getProcess();
                if (PlatformInstallationDialogController.this.sdkUtilProcess == null) {
                    return null;
                }
                List<String> stdOut = ProcessOutputReader.readStdOut(PlatformInstallationDialogController.this.sdkUtilProcess, ((Object)cmd).toString());
                final List<String> stdErr = ProcessOutputReader.readStdErr(PlatformInstallationDialogController.this.sdkUtilProcess, ((Object)cmd).toString());
                int exitValue = PlatformInstallationDialogController.this.sdkUtilProcess.waitFor();
                PlatformInstallationDialogController.this.sdkUtilProcess = null;
                if (exitValue != 0 && !PlatformInstallDialog.dialogClosed) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.error("A sdk-utils has been terminated with error.\n" + stdErr);
                        }
                    });
                    EMLogger.getLogger().warning("A sdk-utils has been terminated with error.");
                    EMLogger.getLogger().warning(stdErr.toString());
                    return null;
                }
                ArrayList<String> platformList = new ArrayList<String>();
                for (String str : stdOut) {
                    String[] arr = str.split("\\s+");
                    if (arr.length != 4 || !arr[0].equals("NI") || !arr[3].equals("Emulator")) continue;
                    platformList.add(arr[1]);
                }
                return platformList;
            }
        }, this.platformListCompletionListener);
    }

    private boolean checkFilter(PlatformItem platformItem) {
        boolean profileInclude = false;
        if (!this.profileFilters.isEmpty()) {
            for (String profile : this.profileFilters) {
                if (!platformItem.getProfile().toLowerCase().equals(profile.toLowerCase())) continue;
                profileInclude = true;
                break;
            }
        }
        boolean versionInclude = false;
        if (!this.versionFilters.isEmpty()) {
            for (String version : this.versionFilters) {
                if (!platformItem.getVersion().equals(version)) continue;
                versionInclude = true;
                break;
            }
        }
        return profileInclude && versionInclude;
    }

    private void clearFilters() {
        this.profileSet.clear();
        this.versionSet.clear();
        this.setProfileFilterPopupValue();
        this.setVersionFilterPopupValue();
        this.profileFilterController.clearFilters();
        this.versionFilterController.clearFilters();
    }

    public void destroySdkUtilProcess() {
        if (this.sdkUtilProcess != null) {
            this.sdkUtilProcess.destroyForcibly();
        }
    }

    public List<String> getSelectedPackages() {
        ArrayList<String> result = new ArrayList<String>();
        for (PlatformItem item : this.platformTable.getSelectionModel().getSelectedItems()) {
            result.add(item.getPackageName());
        }
        return result;
    }
}

