/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.item.PlatformDisplayData;
import org.tizen.emulator.manager.ui.item.TableCheckBoxItem;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;

public class VMItem
extends TableCheckBoxItem {
    private final SimpleStringProperty type = new SimpleStringProperty("");
    private final SimpleStringProperty name = new SimpleStringProperty("");
    private final SimpleStringProperty platform = new SimpleStringProperty("");
    private final SimpleStringProperty resolution = new SimpleStringProperty("");
    private final SimpleIntegerProperty RAMSize = new SimpleIntegerProperty(512);
    private final SimpleIntegerProperty processors = new SimpleIntegerProperty(4);
    private final SimpleStringProperty status = new SimpleStringProperty("");
    private VMProperty property = null;

    public boolean equals(Object obj) {
        if (!(obj instanceof VMItem)) {
            return false;
        }
        VMItem item = (VMItem)obj;
        return this.name.get().equals(item.getName());
    }

    public int hashCode() {
        return 100;
    }

    public VMItem(VMProperty property, SimpleIntegerProperty checkCount) {
        super(checkCount);
        this.setValue(property);
    }

    public void setValue(VMProperty property) {
        this.property = property;
        VMPropertyValue value = property.getPropertyValue();
        this.type.set(value.deviceName);
        this.name.set(value.vmName);
        this.platform.set(value.getPlatformName());
        this.resolution.set(value.resolution.getStrTypeValue());
        this.RAMSize.set(value.ramSize);
        this.processors.set(value.cpu);
        this.status.set(property.getState().toString());
    }

    public SimpleStringProperty typeProperty() {
        return this.type;
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public SimpleStringProperty platformProperty() {
        return this.platform;
    }

    public SimpleStringProperty resolutionProperty() {
        return this.resolution;
    }

    public SimpleIntegerProperty RAMSizeProperty() {
        return this.RAMSize;
    }

    public SimpleIntegerProperty processorsProperty() {
        return this.processors;
    }

    public SimpleStringProperty statusProperty() {
        return this.status;
    }

    public String getType() {
        return this.type.get();
    }

    public String getName() {
        return this.name.get();
    }

    public String getPlatform() {
        return this.platform.get();
    }

    public String getResolution() {
        return this.resolution.get();
    }

    public void setResolution(String re) {
        this.resolution.set(re);
    }

    public int getRAMSize() {
        return this.RAMSize.get();
    }

    public int getProcessors() {
        return this.processors.get();
    }

    public VMProperty.State getState() {
        return this.property.getState();
    }

    public VMProperty.Health getHealth() {
        return this.property.getHealth();
    }

    public String getProfile() {
        return this.property.getPropertyValue().getProfile();
    }

    public String getImageArch() {
        return this.property.getPropertyValue().getImageArch().toString();
    }

    public boolean useQCOW2Image() {
        return this.property.getPropertyValue().useQCOW2();
    }

    public String toString() {
        return this.name.get();
    }

    public FileTime getLastModifiedTime() {
        try {
            return Files.getLastModifiedTime(this.property.getPropertyFile(), new LinkOption[0]);
        }
        catch (IOException e) {
            EMLogger.getLogger().info("A property file does not exist. Maybe, a vm was removed.");
            return null;
        }
    }

    public String getDateTooltip() {
        FileTime lastModifiedTime = this.getLastModifiedTime();
        if (lastModifiedTime == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HH:mm");
        return "Last modified: " + format.format(lastModifiedTime.toMillis()) + StringResources.NEW_LINE + "Last launched: " + (this.property.getLastLaunchedTime() == 0L ? "X" : format.format(new Date(this.property.getLastLaunchedTime())));
    }

    public String getPlatformTooltip() {
        VMPropertyValue value = this.property.getPropertyValue();
        PlatformDisplayData data = PlatformDisplayData.getData(this.property.getPropertyValue().getPlatform());
        String tooltip = "Type: " + data.getType() + StringResources.NEW_LINE + "CPU: " + (Object)((Object)value.getImageArch()) + StringResources.NEW_LINE + "Binary Version: " + value.getImageBinaryVersion();
        return tooltip;
    }

    public String getResolutionTooltip() {
        VMPropertyValue value = this.property.getPropertyValue();
        String tooltip = "Display size: " + value.screenSize + " inch" + StringResources.NEW_LINE + "DPI: " + value.dpi;
        if (value.skin != null) {
            tooltip = tooltip + StringResources.NEW_LINE + StringResources.NEW_LINE + "Skin: " + value.skin.getName() + StringResources.NEW_LINE + "Skin shape: " + value.skin.getSkinShapeList().toString();
        }
        return tooltip;
    }

    public String getStatusTooltip() {
        return "";
    }

    public PlatformDisplayData getData() {
        return PlatformDisplayData.getData(this.property.getPropertyValue().getPlatform());
    }

    public VMDialogData getDialogData() {
        VMDialogData data = new VMDialogData();
        data.setPlatform(this.property.getPropertyValue().getPlatform());
        data.setDeviceTemplate(this.property.getPropertyValue().getDeviceTemplate());
        data.setVmValue(new VMPropertyValue(this.property.getPropertyValue()));
        return data;
    }

    public void launch() throws VMLauncherException, VMWorkerException {
        this.property.getWorker().launchVM();
    }

    public void modify(VMPropertyValue newValue) throws VMWorkerException {
        this.property.getWorker().modifyVM(newValue);
    }

    public void reset() throws VMWorkerException {
        this.property.getWorker().resetVM();
    }

    public void delete() throws VMWorkerException {
        this.property.getWorker().deleteVM();
    }

    public void export(String dest, boolean useCompress) throws VMWorkerException {
        this.property.getWorker().createNewBaseImage(this.property, dest, useCompress);
    }

    public boolean isRunning() {
        return this.property.isRunning() || this.property.getState() == VMProperty.State.BUSY;
    }

    public boolean isNotAvailable() {
        return this.property.getPropertyValue().getPlatform().isNotAvailabale();
    }

    public void setStatus(String status) {
        this.status.set(status);
    }

    public String getStatus() {
        return this.status.get();
    }
}

