/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.platform.item;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import org.tizen.emulator.manager.ui.platform.item.DescBaseViewItem;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;

public class PlatformDescViewItem
extends ViewItem {
    private final TextArea textArea;
    private int maxLen = -1;

    public PlatformDescViewItem() {
        super(new DescBaseViewItem());
        GridPane pane = (GridPane)this.getContent();
        pane.setVgap(8.0);
        this.textArea = new TextArea(){

            public void replaceText(int start, int end, String inputText) {
                if (PlatformDescViewItem.this.validate(inputText, super.getText())) {
                    super.replaceText(start, end, inputText);
                }
            }

            public void replaceSelection(String inputText) {
                if (PlatformDescViewItem.this.validate(inputText, super.getText())) {
                    super.replaceSelection(inputText);
                }
            }
        };
        pane.add((Node)this.textArea, 0, 1, 2, 1);
        this.textArea.setPrefHeight(104.0);
        this.textArea.setWrapText(true);
        this.baseView.setViewItem((Node)new Label());
        this.setPrefHeight(-1.0);
        this.textArea.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                Event event = new Event(EventType.Modify);
                event.text = arg2;
                PlatformDescViewItem.this.sendEvent(event);
            }
        });
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setMaxLen(int maxLen) {
        this.maxLen = maxLen;
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    @Override
    public String toString() {
        return this.textArea.getText();
    }

    private boolean validate(String inputText, String text) {
        if (inputText.isEmpty()) {
            return true;
        }
        if (this.maxLen < 0) {
            return true;
        }
        return text.length() < this.maxLen;
    }
}

