/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import java.util.List;
import javafx.scene.control.ButtonType;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.dialog.network.InputHostIPDialog;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.NetTapDeviceViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;

public class NetTapDeviceItemController
extends ViewItemController {
    private EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            NetTapDeviceItemController.this.initComboList(event.newValue);
        }
    };
    private NetTapDeviceViewItem viewItem;
    private String tapDevice = "";
    private String oldTapDevice = "";
    private static String DEFAULT_HOST_IP = "10.0.2.2";
    private InputHostIPDialog hostIPDialog;
    private String hostIP = DEFAULT_HOST_IP;
    private String userInputIP = "";

    public NetTapDeviceItemController(Item item) {
        super(item);
        ViewItemController.addChangeEventHandler("netConnectType", this.handler);
    }

    @Override
    public void dispose() {
        ViewItemController.removeChangeEventHandler("netConnectType", this.handler);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new NetTapDeviceViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.viewItem = item instanceof NetTapDeviceViewItem ? (NetTapDeviceViewItem)item : new NetTapDeviceViewItem();
        this.viewItem.setTitle(this.getTitle());
        this.addListener();
    }

    private void addListener() {
        this.viewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetTapDeviceItemController.this.onChangedValue(event);
            }
        });
        this.viewItem.addEventHandler(EventType.Modify, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetTapDeviceItemController.this.onChangedValue(event);
            }
        });
    }

    private void initComboList(String type) {
        this.viewItem.clear();
        if (type.equals("NAT")) {
            this.tapDevice = "";
            this.oldTapDevice = "";
            this.changeHostIP();
            this.viewItem.setEnable(false);
        } else {
            this.viewItem.setEnable(true);
            List<String> optionList = null;
            if (OSUtil.isLinux()) {
                optionList = NetworkUtil.getEthernetListForLinux();
            } else if (OSUtil.isMac()) {
                optionList = NetworkUtil.getEthernetListForMac();
            } else if (OSUtil.isWin()) {
                optionList = NetworkUtil.getTapList();
            }
            if (optionList == null || optionList.isEmpty()) {
                this.viewItem.setComboEnable(false);
                this.sendEvent("");
                return;
            }
            for (String option : optionList) {
                this.viewItem.addItem(option);
            }
            if (this.viewItem.getItemList().size() > 0) {
                if (this.tapDevice.isEmpty()) {
                    this.viewItem.selectItem(0);
                } else if (this.viewItem.isExist(this.tapDevice)) {
                    this.viewItem.selectItem(this.tapDevice);
                } else {
                    this.sendEvent("");
                }
            }
        }
    }

    @Override
    protected void onChangedValue(Event event) {
        if (event.type == EventType.Modify) {
            if (event.text == null || event.text.isEmpty()) {
                return;
            }
            EMLogger.getLogger().fine("Add new tap device - " + event.text);
            if (!this.viewItem.isComboEnabled()) {
                this.viewItem.setComboEnable(true);
            }
            this.viewItem.addItem(event.text);
            this.viewItem.selectItem(event.text);
        } else {
            this.oldTapDevice = this.tapDevice;
            this.tapDevice = this.viewItem.getSelectedItem();
            if (!this.oldTapDevice.equals(this.tapDevice)) {
                this.changeHostIP();
            }
            this.sendEvent(this.tapDevice);
        }
    }

    private void sendEvent(String tapDevice) {
        ItemEvent iEvent = new ItemEvent("netTapDevice", this);
        iEvent.newValue = tapDevice;
        iEvent.oldValue = this.oldTapDevice;
        NetTapDeviceItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String connectType = "NAT";
        if (this.mode == MODE.MODIFY && ((connectType = value.getStringValue("netConnectType")) == null || connectType.isEmpty())) {
            connectType = "NAT";
        }
        this.hostIP = value.getStringValue("hostIp");
        if (this.hostIP == null || this.hostIP.isEmpty()) {
            this.hostIP = DEFAULT_HOST_IP;
        }
        if (connectType.equals("Bridge")) {
            this.oldTapDevice = this.tapDevice = value.getStringValue(this.getName());
        }
        this.initComboList(connectType);
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue("netTapDevice", this.tapDevice);
        value.setStringValue("hostIp", this.hostIP);
    }

    @Override
    public void checkValid() {
        EMLogger.getLogger().info("called checkValid of NetTapDeviceItemController");
    }

    private void changeHostIP() {
        this.hostIP = this.tapDevice != null && !this.tapDevice.isEmpty() ? this.getBridgeIP() : DEFAULT_HOST_IP;
    }

    private String getBridgeIP() {
        String ip = "";
        try {
            ip = NetworkUtil.getBridgeIpAddress(this.tapDevice);
            EMLogger.getLogger().info("Host IP: " + ip);
            if (ip != null && !ip.isEmpty()) {
                return ip;
            }
        }
        catch (VMWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        if (this.userInputIP != null && !this.userInputIP.isEmpty()) {
            return this.userInputIP;
        }
        ButtonType res = MessageBox.confirm("Emulator Manager", Messages.getString("NetConnectTypeItem.IPInfo.0") + StringResources.NEW_LINE + Messages.getString("NetConnectTypeItem.IPInfo.1") + StringResources.NEW_LINE + Messages.getString("NetConnectTypeItem.IPInfo.2"));
        if (res == null || res != ButtonType.OK) {
            return DEFAULT_HOST_IP;
        }
        if (this.hostIPDialog == null) {
            this.hostIPDialog = new InputHostIPDialog();
        }
        this.userInputIP = this.hostIPDialog.getHostIP();
        if (this.userInputIP == null) {
            this.userInputIP = DEFAULT_HOST_IP;
        } else {
            ip = this.userInputIP;
        }
        return ip;
    }
}

