/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.network.EthernetTCPIP;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;

class TapDevice {
    private String name;
    private EthernetTCPIP ethernetIP;
    private String mac = "";

    public TapDevice(String name) {
        this.setName(name);
        this.setIPInfo();
    }

    public TapDevice() {
        this.setName("");
        this.mac = HelperClass.getMacAddress();
        this.ethernetIP = new EthernetTCPIP();
        this.ethernetIP.setTCPIP(false, "", "", "", "");
    }

    private void setIPInfo() {
        String subnet = "";
        try {
            subnet = NetworkUtil.getNetmaskFromTap(this.name);
            if (subnet.isEmpty()) {
                subnet = NetworkUtil.getNetmaskFromTap(NetworkUtil.BRIDGE_NAME);
            }
        }
        catch (NumberFormatException | VMWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        String gateway = "";
        try {
            gateway = NetworkUtil.getGatewayFromTap(this.name);
            if (gateway.isEmpty()) {
                gateway = NetworkUtil.getGatewayFromTap(NetworkUtil.BRIDGE_NAME);
            }
        }
        catch (NumberFormatException | VMWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        String dns = "";
        try {
            dns = NetworkUtil.getDnsFromTap(this.name);
        }
        catch (NumberFormatException | VMWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        this.mac = HelperClass.getMacAddress();
        this.ethernetIP = new EthernetTCPIP();
        this.ethernetIP.setTCPIP(true, "", gateway, subnet, dns);
    }

    public void copy(TapDevice tap) {
        this.setIp(tap.getIp());
        this.setGateway(tap.getGateway());
        this.setNetMask(tap.getNetMask());
        this.setDns(tap.getDns());
        this.setMac(tap.getMac());
        this.setUseDHCP(tap.isUseDHCP());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIp() {
        return this.ethernetIP.getIp();
    }

    public void setIp(String ip) {
        this.ethernetIP.setIp(ip);
    }

    public boolean isUseDHCP() {
        return this.ethernetIP.isDhcpOn();
    }

    public void setUseDHCP(boolean useDHCP) {
        this.ethernetIP.setDhcpOn(useDHCP);
    }

    public String getNetMask() {
        return this.ethernetIP.getNetmask();
    }

    public void setNetMask(String netmask) {
        this.ethernetIP.setNetmask(netmask);
    }

    public String getGateway() {
        return this.ethernetIP.getGateway();
    }

    public void setGateway(String gateway) {
        this.ethernetIP.setGateway(gateway);
    }

    public String getDns() {
        return this.ethernetIP.getDns();
    }

    public void setDns(String dns) {
        this.ethernetIP.setDns(dns);
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }
}

