/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Priority;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.ComboItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;

public class ComboViewItem
extends ViewItem {
    protected ComboBox<ComboItem> combo = new ComboBox();
    protected ObservableList<ComboItem> items;
    protected ComboItem selectedItem;
    protected int selectedIndex = -1;

    public ComboViewItem() {
        this.combo.setEditable(false);
        this.items = this.combo.getItems();
        this.combo.setMaxWidth(Double.MAX_VALUE);
        this.baseView.setViewItem((Node)this.combo);
        this.addListener();
    }

    protected void addListener() {
        this.combo.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ComboItem>(){

            public void changed(ObservableValue<? extends ComboItem> observable, ComboItem oldValue, ComboItem newValue) {
                if (ComboViewItem.this.items.isEmpty()) {
                    return;
                }
                ComboViewItem.this.selectedItem = (ComboItem)ComboViewItem.this.combo.getSelectionModel().getSelectedItem();
                ComboViewItem.this.selectedIndex = ComboViewItem.this.combo.getSelectionModel().getSelectedIndex();
                if (ComboViewItem.this.selectedItem == null) {
                    return;
                }
                Event event = new Event(EventType.Selection);
                event.text = ComboViewItem.this.selectedItem.getText();
                event.data = ComboViewItem.this.selectedItem.getData();
                event.index = ComboViewItem.this.selectedIndex;
                ComboViewItem.this.sendEvent(event);
            }
        });
    }

    public boolean checkDuplicated(String item) {
        for (String str : this.getItemList()) {
            if (!str.equals(item)) continue;
            return true;
        }
        return false;
    }

    public void addItem(String item) {
        this.items.add((Object)new ComboItem(item));
    }

    public void addItem(String item, int index) {
        this.items.add(index, (Object)new ComboItem(item));
    }

    public void addItem(String item, Object data) {
        this.items.add((Object)new ComboItem(item, data));
    }

    public void addItem(String item, Object data, int index) {
        this.items.add(index, (Object)new ComboItem(item, data));
    }

    public void removeItem(String item) {
        ComboItem target = null;
        for (ComboItem i : this.items) {
            if (!i.getText().equals(item)) continue;
            target = i;
            break;
        }
        if (target != null) {
            this.items.remove(target);
        }
    }

    public void removeItem(int index) {
        if (index >= this.items.size()) {
            return;
        }
        this.items.remove(index);
    }

    public String getSelectedItem() {
        if (this.selectedItem == null) {
            return null;
        }
        return this.selectedItem.getText();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedData() {
        if (this.selectedItem == null) {
            return null;
        }
        return this.selectedItem.getData();
    }

    public boolean selectItem(String text) {
        for (ComboItem item : this.items) {
            if (!item.getText().equals(text)) continue;
            this.combo.setValue((Object)item);
            return true;
        }
        return false;
    }

    public boolean selectItem(int index) {
        if (index >= this.items.size()) {
            return false;
        }
        ComboItem item = (ComboItem)this.items.get(index);
        this.combo.setValue((Object)item);
        return true;
    }

    public boolean isExist(String item) {
        for (ComboItem i : this.items) {
            if (!i.getText().equals(item)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
    }

    @Override
    public String toString() {
        if (this.selectedItem != null) {
            return this.selectedItem.getText();
        }
        return "";
    }

    public List<String> getItemList() {
        ArrayList<String> list = new ArrayList<String>();
        for (ComboItem item : this.items) {
            list.add(item.getText());
        }
        return list;
    }

    public void setComboWidth(Double comboWidth) {
        this.baseView.sethGrowPriority(Priority.NEVER);
        this.combo.setPrefWidth(comboWidth.doubleValue());
        this.combo.setMaxWidth(-1.0);
    }
}

