/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.template;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformStringResources;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.JAXBHelper;
import org.tizen.emulator.manager.ui.template.TempItemList;
import org.tizen.emulator.manager.ui.template.Template;
import org.tizen.emulator.manager.ui.template.internal.ConvertIntoV2;
import org.tizen.emulator.manager.ui.template.item.Group;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.ui.template.item.Option;
import org.tizen.emulator.manager.vms.xml.template.v2.Information;
import org.tizen.emulator.manager.vms.xml.template.v2.ItemGroup;
import org.tizen.emulator.manager.vms.xml.template.v2.ItemList;

public class TemplateLoader {
    public static Template loadTemplate(Platform platform) {
        Template vmTemplate;
        File templateDir = new File(platform.getPlatformPath() + File.separator + FilePathResources.getPlatformTemplateSuffix());
        if (templateDir == null || !templateDir.exists()) {
            return null;
        }
        String imageName = platform.getImageName();
        ArrayList<File> templateFiles = new ArrayList<File>();
        File standardFile = null;
        File[] fileList = templateDir.listFiles();
        if (fileList != null) {
            for (File f : fileList) {
                if (!f.getName().endsWith(".xml") || !f.getName().contains(PlatformStringResources.TEMPLATEV2)) continue;
                if (f.getName().contains(imageName)) {
                    templateFiles.add(f);
                    break;
                }
                if (!f.getName().contains(PlatformStringResources.STANDARD)) continue;
                standardFile = f;
            }
        }
        if (templateFiles.isEmpty() && standardFile == null) {
            return ConvertIntoV2.loadTemplate(imageName, platform);
        }
        if (templateFiles.isEmpty() && standardFile != null) {
            templateFiles.add(standardFile);
        }
        if (!TemplateLoader.checkTemplate(vmTemplate = TemplateLoader.loadVMTemplate(templateFiles))) {
            EMLogger.getLogger().warning("Available template files for " + imageName + " do not exist. Check your platform directory");
            return null;
        }
        EMLogger.getLogger().info(vmTemplate.getFilePath() + " is loaded for " + imageName);
        return vmTemplate;
    }

    private static boolean checkTemplate(Template template) {
        if (template == null) {
            return false;
        }
        if (template.getProfile().isEmpty()) {
            return false;
        }
        return template.getGroups().size() != 0;
    }

    public static Template loadVMTemplate(List<File> templateFiles) {
        ArrayList<TempItemList> items = new ArrayList<TempItemList>();
        for (File file : templateFiles) {
            ItemList itemList = JAXBHelper.parseXML(file.toPath(), ItemList.class);
            if (itemList == null) {
                EMLogger.getLogger().warning("Failed to load template - " + file.getAbsolutePath());
                return null;
            }
            items.add(new TempItemList(itemList, file.getAbsolutePath()));
        }
        TempItemList item = (TempItemList)items.get(0);
        for (TempItemList i : items) {
            if (item.getVersion().compareTo(i.getVersion()) >= 0) continue;
            item = i;
        }
        return TemplateLoader.convertTemplate(item);
    }

    public static Template loadTemplate(File templateFile) {
        ItemList itemList = JAXBHelper.parseXML(templateFile.toPath(), ItemList.class);
        if (itemList == null) {
            EMLogger.getLogger().warning("Failed to load template - " + templateFile.getAbsolutePath());
            return null;
        }
        return TemplateLoader.convertTemplate(new TempItemList(itemList, templateFile.getAbsolutePath()));
    }

    private static Template convertTemplate(TempItemList item) {
        Information info;
        Template template = new Template();
        template.setFilePath(item.getFilePath());
        ItemList items = item.getItemList();
        if (items.getVersion() != null) {
            template.setTemplateVersion(items.getVersion());
        }
        if ((info = items.getInformation()) != null) {
            if (info.getImage() != null) {
                template.setImageName(info.getImage());
            }
            if (info.getProfile() != null) {
                template.setProfile(info.getProfile());
            }
            if (info.getVersion() != null) {
                template.setPlatformVersion(info.getVersion());
            }
        }
        List<ItemGroup> itemGroups = items.getItemGroup();
        for (ItemGroup itemGroup : itemGroups) {
            Group group = new Group();
            group.setName(itemGroup.getName());
            for (org.tizen.emulator.manager.vms.xml.template.v2.Item i : itemGroup.getItem()) {
                group.getItems().add(TemplateLoader.convertItem(i));
            }
            template.addGroup(group);
        }
        return template;
    }

    private static Item convertItem(org.tizen.emulator.manager.vms.xml.template.v2.Item item) {
        Item target = new Item();
        if (item.getName() != null) {
            target.setName(item.getName());
        }
        target.setTitle(item.getTitle());
        target.setType(item.getType());
        for (org.tizen.emulator.manager.vms.xml.template.v2.Option option : item.getOption()) {
            Option targetOption = new Option();
            if (option.getName() != null) {
                targetOption.setName(option.getName());
            }
            if (option.getValue() != null) {
                targetOption.setValue(option.getValue());
            }
            targetOption.setAttr(option.getAttr());
            target.addOption(targetOption);
        }
        for (org.tizen.emulator.manager.vms.xml.template.v2.Item subItem : item.getItem()) {
            target.addSubItem(TemplateLoader.convertItem(subItem));
        }
        return target;
    }
}

