/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.tizen.web.jsa.safe.bugdetecter.core.BugFilter;
import org.tizen.web.jsa.safe.bugdetecter.core.BugItem;
import org.tizen.web.jsa.safe.bugdetecter.core.ProblemsReporter;
import org.tizen.web.jsa.safe.bugdetecter.preferences.Settings;
import org.tizen.web.jsa.safe.bugdetecter.util.IOUtil;

public class AnalysisDriver {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final int JSA_STATUS_OK = 0;
    public static final int JSA_STATUS_ERROR = 1;
    public static final int JSA_STATUS_ERROR_JVM_HEAP = 10;
    public static final int JSA_STATUS_ERROR_JRE_VERSION = 11;
    public static final int JSA_STATUS_ERROR_SYNTAX = 12;
    public static final int JSA_STATUS_ERROR_EXCEPTION = 13;
    private ArrayList<BugItem> bugList = null;
    private IProject project;
    private Shell shell;
    private IPath logFilePath;
    private String commandStr;

    public AnalysisDriver(Shell shell, IProject project) {
        this.shell = shell;
        this.project = project;
    }

    public void analyze(final ArrayList<String> commandArgs) throws InvocationTargetException, PartInitException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProgressView");
        StringBuffer commandSb = new StringBuffer();
        Object[] objectArray = commandArgs.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object str = objectArray[n2];
            commandSb.append((String)str);
            commandSb.append(" ");
            ++n2;
        }
        this.commandStr = commandSb.toString();
        try {
            StringBuffer jobTitle = new StringBuffer();
            jobTitle.append("Analyzing \"");
            jobTitle.append(this.project.getName());
            jobTitle.append("\" project.");
            this.bugList = new ArrayList();
            ProblemsReporter.clear(this.project);
            Job analysisJob = new Job(jobTitle.toString()){
                private StringBuffer contents;
                private BufferedWriter bwriter;
                private Process proc;
                private int terminationStatus;
                private ArrayList<String> errorMessage;
                {
                    super($anonymous0);
                    this.contents = null;
                    this.bwriter = null;
                    this.proc = null;
                    this.terminationStatus = 0;
                    this.errorMessage = new ArrayList();
                }

                protected IStatus run(IProgressMonitor monitor) {
                    BufferedReader input = null;
                    this.contents = new StringBuffer();
                    String line = null;
                    String preLine = null;
                    this.proc = null;
                    this.contents.append(AnalysisDriver.this.commandStr);
                    this.contents.append("\n");
                    String workingDir = Settings.getSafeDir();
                    try {
                        try {
                            monitor.beginTask("Initializing bug detector...", 100);
                            ProcessBuilder pb = new ProcessBuilder(new String[0]);
                            pb.command(commandArgs);
                            pb.redirectErrorStream(true);
                            if (!Settings.isEmpty(workingDir)) {
                                pb.directory(new File(workingDir));
                            }
                            this.proc = pb.start();
                            monitor.worked(10);
                            input = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
                            this.bwriter = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream()));
                            while ((line = input.readLine()) != null) {
                                if (line.contains("* JavaScript Files *")) {
                                    monitor.setTaskName("Analyzing...");
                                    monitor.worked(20);
                                }
                                if (line.contains("* Analyzing *")) {
                                    monitor.worked(20);
                                }
                                if (line.contains("* Bug Detector *")) {
                                    monitor.setTaskName("Bug detecting...");
                                    monitor.worked(30);
                                }
                                if (line.contains("Could not reserve enough space for object heap")) {
                                    this.errorMessage.add(line);
                                    this.errorMessage.add("512mb");
                                    this.terminationStatus = 10;
                                }
                                if (line.contains("Syntax Error")) {
                                    this.errorMessage.add(preLine);
                                    this.errorMessage.add(line);
                                    this.terminationStatus = 12;
                                }
                                if (line.contains("Exception in thread")) {
                                    this.errorMessage.add(line);
                                    this.terminationStatus = 13;
                                }
                                if (AnalysisDriver.this.checkBugItemLog(line)) {
                                    BugItem bug = AnalysisDriver.this.reportBugItem(line);
                                    if (bug != null) {
                                        AnalysisDriver.this.bugList.add(bug);
                                    }
                                } else {
                                    this.contents.append(line);
                                    this.contents.append(LINE_SEPARATOR);
                                    preLine = line;
                                }
                                System.out.println(line);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                if (this.proc != null) {
                                    this.proc.destroy();
                                }
                                if (input != null) {
                                    input.close();
                                }
                                monitor.setTaskName("Finalizing...");
                                monitor.worked(10);
                                AnalysisDriver.this.project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 0, 4));
                                AnalysisDriver.this.jobProcessDone(this.terminationStatus, this.errorMessage);
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            catch (CoreException e3) {
                                e3.printStackTrace();
                            }
                            monitor.done();
                        }
                    }
                    finally {
                        try {
                            if (this.proc != null) {
                                this.proc.destroy();
                            }
                            if (input != null) {
                                input.close();
                            }
                            monitor.setTaskName("Finalizing...");
                            monitor.worked(10);
                            AnalysisDriver.this.project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 0, 4));
                            AnalysisDriver.this.jobProcessDone(this.terminationStatus, this.errorMessage);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }

                protected void canceling() {
                    block19: {
                        int c = 3;
                        try {
                            this.bwriter.write(c);
                            this.bwriter.flush();
                            Thread.sleep(250L);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                this.bwriter.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            break block19;
                        }
                        catch (InterruptedException e) {
                            try {
                                e.printStackTrace();
                                break block19;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    this.bwriter.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                            }
                        }
                        try {
                            this.bwriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        this.proc.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        this.proc.destroy();
                    }
                    try {
                        AnalysisDriver.this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        AnalysisDriver.this.bugList.add(new BugItem(100, 0, "Analyze canceled by user.", "", 0));
                        AnalysisDriver.this.jobProcessDone(this.terminationStatus, this.errorMessage);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    super.canceling();
                }
            };
            analysisJob.setRule((ISchedulingRule)this.project);
            analysisJob.schedule();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InvocationTargetException(e);
        }
    }

    public BugItem reportSyntaxError(ArrayList<String> errorMsg) {
        if (errorMsg.size() < 2) {
            return null;
        }
        String rawLoc = errorMsg.get(0);
        int split = rawLoc.lastIndexOf(".js:");
        String filePath = rawLoc.substring(0, split + 3);
        String lineNum = rawLoc.substring(split + 3);
        lineNum = lineNum.split(":")[1];
        String msg = errorMsg.get(1).replace("    [Syntax Error]", "");
        int bugCategory = -1;
        if (msg.contains("Missing closing comment")) {
            bugCategory = 68;
        } else if (msg.contains("Missing closing single-quote")) {
            bugCategory = 67;
        } else if (msg.contains("Missing closing brace")) {
            bugCategory = 69;
        } else {
            bugCategory = 1000;
            msg = "JavaScript Syntax Error.";
        }
        BugItem bug = new BugItem(6, bugCategory, msg, filePath, Integer.valueOf(lineNum));
        try {
            ProblemsReporter.reportItem(this.project, bug);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return bug;
    }

    public BugItem reportBugItem(String line) {
        if (line.length() < 5) {
            return null;
        }
        String item = line.substring(5);
        String[] members = item.split("@");
        if (members.length != 5) {
            return null;
        }
        if (BugFilter.isFilteringWebAPI(Integer.valueOf(members[1]), members[2])) {
            return null;
        }
        BugItem bug = new BugItem(Integer.valueOf(members[0]), Integer.valueOf(members[1]), members[2], members[3], Integer.valueOf(members[4]));
        try {
            ProblemsReporter.reportItem(this.project, bug);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return bug;
    }

    public boolean checkBugItemLog(String line) {
        if (line.length() < 4) {
            return false;
        }
        String subStr = line.substring(0, 4);
        return subStr.equals("@BUG");
    }

    private void writeLogFile(String contents) {
        this.logFilePath = this.project.getLocation().append(String.valueOf(File.separator) + this.project.getName() + "_Problems_" + this.getTime() + ".log");
        IOUtil.getInstance().writeToFile(this.logFilePath.toOSString(), contents.toString().trim());
    }

    public String getTime() {
        Date current = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        return sdf.format(current);
    }

    private void jobProcessDone(final int status, final ArrayList<String> message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                switch (status) {
                    case 0: {
                        StringBuilder buginfo = new StringBuilder();
                        buginfo.append("Rule checking has been Finished. Check the Problems view. \n\n");
                        int apiCount = 0;
                        int codingCount = 0;
                        int totalCount = 0;
                        for (BugItem item : AnalysisDriver.this.bugList) {
                            if (item.bugCategory >= 30 && item.bugCategory < 40) {
                                ++apiCount;
                            }
                            if (item.bugCategory < 50 || item.bugCategory >= 70) continue;
                            ++codingCount;
                        }
                        totalCount = apiCount + codingCount;
                        buginfo.append(String.valueOf(Integer.toString(totalCount)) + " bugs was detected in '" + AnalysisDriver.this.project.getName() + "' project. \n");
                        buginfo.append(" - Web API Usage : " + Integer.toString(apiCount) + "\n");
                        buginfo.append(" - Coding Rule : " + Integer.toString(codingCount));
                        MessageDialog.openInformation((Shell)AnalysisDriver.this.shell, (String)"JavaScript Rule Checker", (String)buginfo.toString());
                        break;
                    }
                    case 10: {
                        MessageDialog.openError((Shell)AnalysisDriver.this.shell, (String)"JavaScript Rule Checker", (String)"Error occurred during initialization of VM.\nCould not reserve enough space for object heap. ");
                        break;
                    }
                    case 12: {
                        MessageDialog.openError((Shell)AnalysisDriver.this.shell, (String)"JavaScript Rule Checker", (String)("Error occurred during Analyzing.\n" + (String)message.get(0) + "\n" + (String)message.get(1)));
                        BugItem bug = AnalysisDriver.this.reportSyntaxError(message);
                        if (bug == null) break;
                        AnalysisDriver.this.bugList.add(bug);
                        break;
                    }
                    case 13: {
                        Throwable exception = new Throwable(AnalysisDriver.this.commandStr);
                        Status status2 = new Status(4, "org.tizen.web.jsa", 1, (String)message.get(0), exception);
                        ErrorDialog.openError((Shell)AnalysisDriver.this.shell, (String)"JavaScript Rule Checker", (String)"Error occurred during Analyzing.", (IStatus)status2);
                    }
                }
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }

            public String getBugCount(ArrayList<BugItem> bugList) {
                StringBuilder sb = new StringBuilder();
                int apiCount = 0;
                int codingCount = 0;
                for (BugItem item : bugList) {
                    if (item.bugCategory >= 30 && item.bugCategory < 40) {
                        ++apiCount;
                    }
                    if (item.bugCategory < 50 || item.bugCategory >= 70) continue;
                    ++codingCount;
                }
                sb.append(" - Web API Usage : " + apiCount + "\n");
                sb.append(" - Coding Rule : " + codingCount);
                return sb.toString();
            }
        });
    }
}

