/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.analysis.string.automata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.ac.kaist.jsaf.analysis.string.automata.Pair;
import kr.ac.kaist.jsaf.analysis.string.automata.State;
import kr.ac.kaist.jsaf.analysis.string.cfg.CFG;
import kr.ac.kaist.jsaf.analysis.string.cfg.NonTerminal;
import kr.ac.kaist.jsaf.analysis.string.cfg.Production;
import kr.ac.kaist.jsaf.analysis.string.cfg.Terminal;

public class Automata {
    protected State start;
    protected Set<State> ends;
    protected Map<State, Map<Object, Set<State>>> transition = new HashMap<State, Map<Object, Set<State>>>();
    public static final Epsilon epsilon = new Epsilon();

    public Automata(State start, Set<State> ends) {
        this.start = this.addState(start);
        this.ends = this.addStates(ends);
    }

    public Automata(State start) {
        this(start, new HashSet<State>());
    }

    public Automata() {
        this((State)null);
        this.start = this.addState();
    }

    public Automata(Object[] tokens) {
        this();
        State currentState = this.start;
        for (int i = 0; i < tokens.length; ++i) {
            State nextState = this.addState();
            this.addEdge(currentState, nextState, tokens[i]);
            currentState = nextState;
        }
        this.ends.add(currentState);
    }

    public <E> Automata(List<E> tokens) {
        this(tokens.toArray());
    }

    public Automata(String input) {
        this(Terminal.getTerminals(input));
    }

    public Automata(Automata automata) {
        this();
        HashMap<State, State> stateMap = new HashMap<State, State>();
        HashSet<State> searchSet = new HashSet<State>();
        stateMap.put(automata.start, this.start);
        searchSet.add(automata.start);
        while (!searchSet.isEmpty()) {
            HashSet<State> nextSearchSet = new HashSet<State>();
            for (State from : searchSet) {
                assert (stateMap.containsKey(from));
                State tfrom = (State)stateMap.get(from);
                for (Map.Entry<Object, Set<State>> edges : automata.transition.get(from).entrySet()) {
                    for (State to : edges.getValue()) {
                        boolean searched = true;
                        State tto = null;
                        if (!stateMap.containsKey(to)) {
                            searched = false;
                            tto = this.addState();
                            stateMap.put(to, tto);
                            if (automata.ends.contains(to)) {
                                this.ends.add(tto);
                            }
                        } else {
                            tto = (State)stateMap.get(to);
                        }
                        assert (tto != null);
                        this.addEdge(tfrom, tto, edges.getKey());
                        if (searched) continue;
                        nextSearchSet.add(to);
                    }
                }
            }
            searchSet = nextSearchSet;
        }
    }

    public Automata clone() {
        return new Automata(this);
    }

    public Set<Object> getSigma() {
        HashSet<Object> ret = new HashSet<Object>();
        for (Map.Entry<State, Map<Object, Set<State>>> entry : this.transition.entrySet()) {
            ret.addAll(entry.getValue().keySet());
        }
        return ret;
    }

    public Set<State> getStates() {
        HashSet<State> r = new HashSet<State>();
        for (Map.Entry<State, Map<Object, Set<State>>> entry : this.transition.entrySet()) {
            r.add(entry.getKey());
        }
        return r;
    }

    public Map<State, Map<Object, Set<State>>> getTransition() {
        return this.transition;
    }

    public State getStart() {
        return this.start;
    }

    public Set<State> getEnds() {
        return this.ends;
    }

    public State addState(State state) {
        if (state == null) {
            return null;
        }
        if (this.transition.containsKey(state)) {
            return state;
        }
        this.transition.put(state, new HashMap());
        return state;
    }

    public State addState() {
        return this.addState(new State());
    }

    public Set<State> addStates(Set<State> states) {
        for (State state : states) {
            this.addState(state);
        }
        return states;
    }

    public List<State> addStates(List<State> states) {
        for (State state : states) {
            this.addState(state);
        }
        return states;
    }

    public Automata addEdge(State from, State to, Object value) {
        Map<Object, Set<State>> edges = this.transition.get(from);
        if (!edges.containsKey(value)) {
            edges.put(value, new HashSet());
        }
        edges.get(value).add(to);
        return this;
    }

    public Automata addEdges(Map<State, Map<Object, Set<State>>> edges) {
        for (Map.Entry<State, Map<Object, Set<State>>> entry : edges.entrySet()) {
            State from = entry.getKey();
            this.addState(from);
            for (Map.Entry<Object, Set<State>> entryEdges : entry.getValue().entrySet()) {
                Object value = entryEdges.getKey();
                for (State state : entryEdges.getValue()) {
                    this.addEdge(from, state, value);
                }
            }
        }
        return this;
    }

    public Automata addTransitions(Map<State, Map<Object, Set<State>>> edges) {
        return this.addEdges(edges);
    }

    public Automata removeUnreachables() {
        HashSet<State> searching = new HashSet<State>();
        Set<State> unreachable = this.getStates();
        searching.add(this.start);
        while (!searching.isEmpty()) {
            HashSet<State> nextSearch = new HashSet<State>();
            for (State state : searching) {
                unreachable.remove(state);
                for (Map.Entry<Object, Set<State>> edges : this.transition.get(state).entrySet()) {
                    for (State nextState : edges.getValue()) {
                        if (!unreachable.contains(nextState)) continue;
                        nextSearch.add(nextState);
                    }
                }
            }
            searching = nextSearch;
        }
        for (State state : unreachable) {
            this.transition.remove(state);
        }
        return this;
    }

    protected Automata toDFA() {
        Automata automata = new Automata();
        Set<State> startClosure = this.epsilonClosure(this.start);
        HashMap<Set<State>, State> equivNode = new HashMap<Set<State>, State>();
        equivNode.put(startClosure, automata.start);
        HashSet<Set<State>> toSearch = new HashSet<Set<State>>();
        toSearch.add(startClosure);
        while (!toSearch.isEmpty()) {
            HashSet<Set<State>> nextSearch = new HashSet<Set<State>>();
            for (Set set2 : toSearch) {
                boolean containsEnd = false;
                for (State state : this.ends) {
                    if (!set2.contains(state)) continue;
                    containsEnd = true;
                    break;
                }
                if (containsEnd) {
                    automata.ends.add((State)equivNode.get(set2));
                }
                for (Map.Entry entry : this.getEdges(set2).entrySet()) {
                    Object edgeValue = entry.getKey();
                    if (Automata.isEpsilon(edgeValue)) continue;
                    Set<State> edgeDst = this.epsilonClosure((Set)entry.getValue());
                    if (!equivNode.containsKey(edgeDst)) {
                        equivNode.put(edgeDst, automata.addState());
                        nextSearch.add(edgeDst);
                    }
                    automata.addEdge((State)equivNode.get(set2), (State)equivNode.get(edgeDst), edgeValue);
                }
            }
            toSearch = nextSearch;
        }
        return automata;
    }

    public Automata minimalDFA() {
        Automata dfa = this.removeUnreachables().toDFA();
        if (dfa.ends.isEmpty()) {
            return new Automata();
        }
        Set<Object> sigma = dfa.getSigma();
        HashSet<Set<State>> P = new HashSet<Set<State>>();
        HashSet<Set<State>> W = new HashSet<Set<State>>();
        HashSet<State> QF = new HashSet<State>();
        for (State state : dfa.getStates()) {
            if (dfa.ends.contains(state)) continue;
            QF.add(state);
        }
        P.add(dfa.ends);
        if (!QF.isEmpty()) {
            P.add(QF);
        }
        W.add(dfa.ends);
        while (!W.isEmpty()) {
            Set A = (Set)W.iterator().next();
            W.remove(A);
            for (Object c : sigma) {
                HashSet<State> X = new HashSet<State>();
                for (State state : A) {
                    X.addAll(dfa.reverseSearch(state, c));
                }
                HashSet<Set> hashSet = new HashSet<Set>();
                HashSet pAdd = new HashSet();
                for (Set set2 : P) {
                    HashSet<State> Y_X = new HashSet<State>();
                    HashSet<State> XY = new HashSet<State>();
                    for (State y : set2) {
                        if (X.contains(y)) {
                            XY.add(y);
                            continue;
                        }
                        Y_X.add(y);
                    }
                    if (XY.isEmpty()) continue;
                    hashSet.add(set2);
                    if (!Y_X.isEmpty()) {
                        pAdd.add(Y_X);
                    }
                    pAdd.add(XY);
                    if (W.contains(set2)) {
                        W.remove(set2);
                        W.add(Y_X);
                        W.add(XY);
                        continue;
                    }
                    W.add(XY.size() <= Y_X.size() ? XY : Y_X);
                }
                P.removeAll(hashSet);
                P.addAll(pAdd);
            }
        }
        Automata mdfa = new Automata();
        HashMap<Set, State> equivSet = new HashMap<Set, State>();
        HashMap<State, Set> stateToPart = new HashMap<State, Set>();
        for (Set set3 : P) {
            boolean isStart = false;
            boolean isEnd = false;
            for (State state : set3) {
                if (state.equals(dfa.start)) {
                    isStart = true;
                }
                if (!isEnd && dfa.ends.contains(state)) {
                    isEnd = true;
                }
                stateToPart.put(state, set3);
            }
            if (isStart) {
                equivSet.put(set3, mdfa.start);
            } else {
                equivSet.put(set3, mdfa.addState());
            }
            if (!isEnd) continue;
            mdfa.ends.add((State)equivSet.get(set3));
        }
        for (Set set4 : P) {
            State state = (State)set4.iterator().next();
            for (Map.Entry<Object, Set<State>> entry : dfa.transition.get(state).entrySet()) {
                Set dst = (Set)stateToPart.get(entry.getValue().iterator().next());
                mdfa.addEdge((State)equivSet.get(set4), (State)equivSet.get(dst), entry.getKey());
            }
        }
        return mdfa;
    }

    protected Map<Object, Set<State>> getEdges(Set<State> states) {
        HashMap<Object, Set<State>> ret = new HashMap<Object, Set<State>>();
        for (State state : states) {
            for (Map.Entry<Object, Set<State>> edges : this.transition.get(state).entrySet()) {
                if (ret.containsKey(edges.getKey())) {
                    ((Set)ret.get(edges.getKey())).addAll((Collection)edges.getValue());
                    continue;
                }
                ret.put(edges.getKey(), new HashSet());
                ((Set)ret.get(edges.getKey())).addAll((Collection)edges.getValue());
            }
        }
        return ret;
    }

    protected Set<State> epsilonClosure(State state) {
        HashSet<State> x = new HashSet<State>();
        x.add(state);
        return this.epsilonClosure(x);
    }

    protected Set<State> epsilonClosure(Set<State> states) {
        Set<State> search2 = states;
        HashSet<State> closure = new HashSet<State>();
        while (!search2.isEmpty()) {
            HashSet<State> nextSearch = new HashSet<State>();
            for (State s : search2) {
                closure.add(s);
                Set<State> temp = this.transition.get(s).get(epsilon);
                if (temp == null) continue;
                HashSet<State> epsilon = new HashSet<State>();
                for (State state : temp) {
                    if (closure.contains(state)) continue;
                    epsilon.add(state);
                }
                nextSearch.addAll(epsilon);
            }
            search2 = nextSearch;
        }
        return closure;
    }

    protected Set<State> reachable(Set<State> begins, Object token) {
        HashSet<State> ret = new HashSet<State>();
        for (State state : this.epsilonClosure(begins)) {
            Set<State> destinations = this.transition.get(state).get(token);
            if (destinations == null) continue;
            ret.addAll(destinations);
        }
        return this.epsilonClosure(ret);
    }

    public boolean accept(Object[] input) {
        Set<State> currentStates = this.epsilonClosure(this.start);
        for (int i = 0; i < input.length; ++i) {
            currentStates = this.reachable(currentStates, input[i]);
        }
        for (State state : currentStates) {
            if (!this.ends.contains(state)) continue;
            return true;
        }
        return false;
    }

    public boolean accept(List<Object> input) {
        return this.accept(input.toArray());
    }

    public Automata removeCycle() {
        for (Map.Entry<State, Map<Object, Set<State>>> stateInfo : this.transition.entrySet()) {
            Map<Object, Set<State>> edges = stateInfo.getValue();
            Set<State> states = edges.get(epsilon);
            states.remove(stateInfo.getKey());
            if (!states.isEmpty()) continue;
            edges.remove(epsilon);
        }
        return this;
    }

    public static Automata union(Automata a, Automata b) {
        Automata r = new Automata();
        r.addTransitions(a.transition).addTransitions(b.transition);
        r.addEdge(r.start, a.start, epsilon);
        r.addEdge(r.start, b.start, epsilon);
        r.ends.addAll(a.ends);
        r.ends.addAll(b.ends);
        return r.removeUnreachables();
    }

    public static Automata intersect(Automata a, Automata b) {
        HashMap<Pair<State, State>, State> map2 = new HashMap<Pair<State, State>, State>();
        Automata r = new Automata();
        map2.put(new Pair<State, State>(a.start, b.start), r.start);
        for (Map.Entry<State, Map<Object, Set<State>>> aEntry : a.transition.entrySet()) {
            for (Map.Entry<State, Map<Object, Set<State>>> bEntry : b.transition.entrySet()) {
                Pair<State, State> fromPair = new Pair<State, State>(aEntry.getKey(), bEntry.getKey());
                State from = (State)map2.get(fromPair);
                if (from == null) {
                    from = r.addState();
                    map2.put(fromPair, from);
                    if (a.ends.contains(fromPair.car()) && b.ends.contains(fromPair.cdr())) {
                        r.ends.add(from);
                    }
                }
                for (Map.Entry<Object, Set<State>> aEdges : aEntry.getValue().entrySet()) {
                    Object aObj = aEdges.getKey();
                    Set<State> aStates = aEdges.getValue();
                    for (Map.Entry<Object, Set<State>> bEdges : bEntry.getValue().entrySet()) {
                        State to;
                        Pair<State, State> toPair;
                        Object bObj = bEdges.getKey();
                        Set<State> bStates = bEdges.getValue();
                        if (aObj.equals(bObj)) {
                            for (State aState : aStates) {
                                for (State bState : bStates) {
                                    toPair = new Pair<State, State>(aState, bState);
                                    to = (State)map2.get(toPair);
                                    if (to == null) {
                                        to = r.addState();
                                        map2.put(toPair, to);
                                        if (a.ends.contains(toPair.car()) && b.ends.contains(toPair.cdr())) {
                                            r.ends.add(to);
                                        }
                                    }
                                    r.addEdge(from, to, aObj);
                                }
                            }
                        }
                        if (Automata.isEpsilon(aObj)) {
                            for (State aState : aStates) {
                                toPair = new Pair<State, State>(aState, fromPair.cdr());
                                to = (State)map2.get(toPair);
                                if (to == null) {
                                    to = r.addState();
                                    map2.put(toPair, to);
                                    if (a.ends.contains(toPair.car()) && b.ends.contains(toPair.cdr())) {
                                        r.ends.add(to);
                                    }
                                }
                                r.addEdge(from, to, aObj);
                            }
                        }
                        if (!Automata.isEpsilon(bObj)) continue;
                        for (State bState : bStates) {
                            toPair = new Pair<State, State>(fromPair.car(), bState);
                            to = (State)map2.get(toPair);
                            if (to == null) {
                                to = r.addState();
                                map2.put(toPair, to);
                                if (a.ends.contains(toPair.car()) && b.ends.contains(toPair.cdr())) {
                                    r.ends.add(to);
                                }
                            }
                            r.addEdge(from, to, bObj);
                        }
                    }
                }
            }
        }
        return r.removeUnreachables();
    }

    public static Automata concat(Automata a, Automata b) {
        Automata r = new Automata(a.start, b.ends);
        r.addTransitions(a.transition).addTransitions(b.transition);
        for (State end : a.ends) {
            r.addEdge(end, b.start, epsilon);
        }
        return r.removeUnreachables();
    }

    public static boolean equivalent(Automata a, Automata b) {
        Automata da = a.minimalDFA();
        Automata db = b.minimalDFA();
        if (da.transition.size() != db.transition.size()) {
            return false;
        }
        if (da.ends.size() != db.ends.size()) {
            return false;
        }
        HashMap<State, State> map2 = new HashMap<State, State>();
        map2.put(da.start, db.start);
        HashSet<State> openSet = new HashSet<State>();
        openSet.add(da.start);
        while (!openSet.isEmpty()) {
            HashSet<State> nextSet = new HashSet<State>();
            for (State aState : openSet) {
                State bState = (State)map2.get(aState);
                Map<Object, Set<State>> aInfo = da.transition.get(aState);
                Map<Object, Set<State>> bInfo = db.transition.get(bState);
                if (aInfo.size() != bInfo.size()) {
                    return false;
                }
                for (Map.Entry<Object, Set<State>> aEdges : aInfo.entrySet()) {
                    if (!bInfo.containsKey(aEdges.getKey())) {
                        return false;
                    }
                    State aDst = aEdges.getValue().iterator().next();
                    State bDst = bInfo.get(aEdges.getKey()).iterator().next();
                    if (bDst == null) {
                        return false;
                    }
                    if (map2.containsKey(aDst)) {
                        if (((State)map2.get(aDst)).equals(bDst)) continue;
                        return false;
                    }
                    map2.put(aDst, bDst);
                    nextSet.add(aDst);
                }
            }
            openSet = nextSet;
        }
        return true;
    }

    public Automata addEdgeWithGrammar(CFG c) {
        Automata ret = new Automata(this);
        HashMap<State, Map<Object, Set<State>>> worklist = new HashMap<State, Map<Object, Set<State>>>();
        for (Map.Entry<State, Map<Object, Set<State>>> t : ret.transition.entrySet()) {
            if (t.getValue().isEmpty()) continue;
            worklist.put(t.getKey(), t.getValue());
        }
        for (Production p : c.getP()) {
            if (!p.getTo().isEmpty()) continue;
            Set<State> states = ret.transition.keySet();
            for (State s : states) {
                Map<Object, Set<State>> v1 = ret.transition.get(s);
                if (v1.containsKey(p.getFrom())) {
                    Set<State> v2 = v1.get(p.getFrom());
                    if (v2.contains(s)) continue;
                    ((Set)((Map)worklist.get(s)).get(p.getFrom())).add(s);
                    continue;
                }
                HashMap<Object, Set<State>> e = new HashMap<Object, Set<State>>();
                e.putAll(ret.transition.get(s));
                HashSet<State> newS = new HashSet<State>();
                newS.add(s);
                e.put(p.getFrom(), newS);
                worklist.put(s, e);
                ret.transition.put(s, e);
            }
        }
        while (!worklist.isEmpty()) {
            Set keySet2 = worklist.keySet();
            Object[] keyArray = keySet2.toArray();
            State from = (State)keyArray[0];
            while (worklist.get(from) != null) {
                HashMap queue = new HashMap();
                for (Map.Entry e : ((Map)worklist.get(from)).entrySet()) {
                    Set tos = (Set)e.getValue();
                    for (Production p : c.getP()) {
                        int i;
                        if (!p.getTo().contains(e.getKey())) continue;
                        int front = p.getTo().indexOf(e.getKey());
                        int back = p.getTo().size() - front - 1;
                        HashSet<State> bin = new HashSet<State>();
                        HashSet<State> currentF = new HashSet<State>();
                        HashSet<State> currentB = new HashSet<State>();
                        currentF.add(from);
                        currentB.addAll(tos);
                        for (i = 0; i < front; ++i) {
                            for (State s : currentF) {
                                bin.addAll(ret.reverseSearch(s, p.getTo().get(front - i - 1)));
                            }
                            currentF.clear();
                            currentF.addAll(bin);
                            bin.clear();
                        }
                        for (i = 0; i < back; ++i) {
                            for (State s : currentB) {
                                for (Map.Entry<Object, Set<State>> e_ : ret.transition.get(s).entrySet()) {
                                    if (!e_.getKey().equals(p.getTo().get(front + i + 1))) continue;
                                    bin.addAll((Collection)e_.getValue());
                                }
                            }
                            currentB.clear();
                            currentB.addAll(bin);
                            bin.clear();
                        }
                        for (State f : currentF) {
                            HashSet<State> in;
                            assert (ret.transition.get(f) != null);
                            if (ret.transition.get(f).containsKey(p.getFrom())) {
                                for (State b : currentB) {
                                    HashSet<State> in2;
                                    if (ret.transition.get(f).get(p.getFrom()).contains(b)) continue;
                                    ret.transition.get(f).get(p.getFrom()).add(b);
                                    if (queue.containsKey(f)) {
                                        if (((Map)queue.get(f)).containsKey(p.getFrom())) {
                                            ((Set)((Map)queue.get(f)).get(p.getFrom())).add(b);
                                            continue;
                                        }
                                        in2 = new HashSet();
                                        in2.add(b);
                                        ((Map)queue.get(f)).put(p.getFrom(), in2);
                                        continue;
                                    }
                                    in2 = new HashSet<State>();
                                    in2.add(b);
                                    HashMap<NonTerminal, HashSet<State>> inn = new HashMap<NonTerminal, HashSet<State>>();
                                    inn.put(p.getFrom(), in2);
                                    queue.put(f, inn);
                                }
                                continue;
                            }
                            HashSet<State> newS = new HashSet<State>();
                            newS.addAll(currentB);
                            ret.transition.get(f).put(p.getFrom(), newS);
                            if (queue.containsKey(f)) {
                                if (((Map)queue.get(f)).containsKey(p.getFrom())) {
                                    ((Set)((Map)queue.get(f)).get(p.getFrom())).addAll(currentB);
                                    continue;
                                }
                                in = new HashSet();
                                in.addAll(currentB);
                                ((Map)queue.get(f)).put(p.getFrom(), in);
                                continue;
                            }
                            in = new HashSet<State>();
                            in.addAll(currentB);
                            HashMap<NonTerminal, HashSet<State>> inn = new HashMap<NonTerminal, HashSet<State>>();
                            inn.put(p.getFrom(), in);
                            queue.put(f, inn);
                        }
                    }
                }
                worklist.remove(from);
                worklist.putAll(queue);
            }
            worklist.remove(from);
        }
        return ret.removeUnreachables();
    }

    protected Set<State> reverseSearch(State s) {
        HashSet<State> ret = new HashSet<State>();
        for (Map.Entry<State, Map<Object, Set<State>>> t : this.transition.entrySet()) {
            for (Set<State> stateSet : t.getValue().values()) {
                if (!stateSet.contains(s)) continue;
                ret.add(t.getKey());
            }
        }
        return ret;
    }

    protected Set<State> reverseSearch(State s, Object o) {
        HashSet<State> ret = new HashSet<State>();
        for (Map.Entry<State, Map<Object, Set<State>>> t : this.transition.entrySet()) {
            if (!t.getValue().containsKey(o) || !t.getValue().get(o).contains(s)) continue;
            ret.add(t.getKey());
        }
        return ret;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Automata\n");
        for (Map.Entry<State, Map<Object, Set<State>>> stateInfo : this.transition.entrySet()) {
            buffer.append('\t').append(stateInfo.getKey().toString());
            if (this.start == stateInfo.getKey()) {
                buffer.append(" ^");
            }
            if (this.ends.contains(stateInfo.getKey())) {
                buffer.append(" $");
            }
            buffer.append(":\n");
            for (Map.Entry<Object, Set<State>> edges : stateInfo.getValue().entrySet()) {
                buffer.append("\t\t").append(edges.getKey()).append(" =>");
                for (State state : edges.getValue()) {
                    buffer.append(' ').append(state.toString());
                }
                buffer.append('\n');
            }
        }
        return buffer.append("]").toString();
    }

    private static boolean isEpsilon(Object object) {
        return epsilon.equals(object);
    }

    private static final class Epsilon {
        public int hashCode() {
            return -488493522;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Epsilon;
        }

        public String toString() {
            return "<epsilon>";
        }
    }
}

