/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.concolic.safe_concolic;

import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import edu.rice.cs.plt.tuple.Option;
import java.util.HashMap;
import java.util.List;
import kr.ac.kaist.jsaf.concolic.safe_concolic.Constraint;
import kr.ac.kaist.jsaf.concolic.static_concolic.StaticConcolicInterface;

public final class Z3 {
    boolean debug = false;
    StaticConcolicInterface staticConcolic = null;

    public HashMap<String, Integer> ConstraintSolver(Context ctx, List<Constraint> constraints, Integer inum) throws Z3Exception, TestFailedException {
        if (this.debug) {
            System.out.println("ConstraintSolver");
        }
        HashMap<String, Object> exprMap = new HashMap<String, Object>();
        Solver solver = ctx.mkSolver();
        while (!constraints.isEmpty()) {
            Constraint constraint = constraints.remove(0);
            if (constraint.hasOp()) {
                String op = (String)constraint.getJavaOp().unwrap();
                String lhs = constraint.getLhs().getValue();
                exprMap.put(lhs, ctx.mkIntConst(lhs));
                if (constraint.hasRhs()) {
                    Constraint c = (Constraint)constraint.getJavaRhs().unwrap();
                    String rhs = c.getLhs().getValue();
                    if (rhs.contains("s") || rhs.contains("i") || rhs.contains("this")) {
                        exprMap.put(rhs, ctx.mkIntConst(rhs));
                    } else {
                        exprMap.put(rhs, ctx.mkInt(Integer.parseInt(rhs)));
                    }
                    block0 : switch (op.charAt(0)) {
                        case '=': {
                            if (op.length() > 1 && op.charAt(1) == '=') {
                                solver.assert_(new BoolExpr[]{ctx.mkEq((Expr)exprMap.get(lhs), (Expr)exprMap.get(rhs))});
                                break;
                            }
                            if (c.hasOp()) {
                                if (c.hasRhs()) {
                                    String v = ((Constraint)c.getJavaRhs().unwrap()).getLhs().getValue();
                                    if (v.contains("s") || v.contains("i") || v.contains("this")) {
                                        exprMap.put(v, ctx.mkIntConst(v));
                                    } else {
                                        exprMap.put(v, ctx.mkInt(Integer.parseInt(v)));
                                    }
                                    String cop = (String)c.getJavaOp().unwrap();
                                    switch (cop.charAt(0)) {
                                        case '+': {
                                            solver.assert_(new BoolExpr[]{ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkAdd(new ArithExpr[]{(ArithExpr)exprMap.get(rhs), (ArithExpr)exprMap.get(v)}))});
                                            break block0;
                                        }
                                        case '-': {
                                            solver.assert_(new BoolExpr[]{ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkSub(new ArithExpr[]{(ArithExpr)exprMap.get(rhs), (ArithExpr)exprMap.get(v)}))});
                                            break block0;
                                        }
                                        case '*': {
                                            solver.assert_(new BoolExpr[]{ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkMul(new ArithExpr[]{(ArithExpr)exprMap.get(rhs), (ArithExpr)exprMap.get(v)}))});
                                            break block0;
                                        }
                                        case '/': {
                                            solver.assert_(new BoolExpr[]{ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkDiv((ArithExpr)exprMap.get(rhs), (ArithExpr)exprMap.get(v)))});
                                            break block0;
                                        }
                                        case '%': {
                                            solver.assert_(new BoolExpr[]{ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkMod((IntExpr)exprMap.get(rhs), (IntExpr)exprMap.get(v)))});
                                            break block0;
                                        }
                                        case '&': {
                                            BitVecExpr x = ctx.mkInt2BV(1, (IntExpr)exprMap.get(rhs));
                                            BitVecExpr y = ctx.mkInt2BV(1, (IntExpr)exprMap.get(v));
                                            solver.assert_(new BoolExpr[]{ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkBV2Int(ctx.mkBVAND(x, y), false))});
                                            break block0;
                                        }
                                        case '!': {
                                            solver.assert_(new BoolExpr[]{(BoolExpr)ctx.mkITE(ctx.mkDistinct(new Expr[]{(Expr)exprMap.get(rhs), (Expr)exprMap.get(v)}), (Expr)ctx.mkDistinct(new Expr[]{(Expr)exprMap.get(lhs), ctx.mkInt(0)}), (Expr)ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkInt(0)))});
                                            break block0;
                                        }
                                        case '=': {
                                            solver.assert_(new BoolExpr[]{(BoolExpr)ctx.mkITE(ctx.mkEq((Expr)exprMap.get(rhs), (Expr)exprMap.get(v)), (Expr)ctx.mkDistinct(new Expr[]{(Expr)exprMap.get(lhs), ctx.mkInt(0)}), (Expr)ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkInt(0)))});
                                            break block0;
                                        }
                                        case '>': {
                                            BoolExpr condition = cop.length() > 1 && cop.charAt(1) == '=' ? ctx.mkGe((ArithExpr)exprMap.get(rhs), (ArithExpr)exprMap.get(v)) : ctx.mkGt((ArithExpr)exprMap.get(rhs), (ArithExpr)exprMap.get(v));
                                            solver.assert_(new BoolExpr[]{(BoolExpr)ctx.mkITE(condition, (Expr)ctx.mkDistinct(new Expr[]{(Expr)exprMap.get(lhs), ctx.mkInt(0)}), (Expr)ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkInt(0)))});
                                            break block0;
                                        }
                                        case '<': {
                                            BoolExpr condition = cop.length() > 1 && cop.charAt(1) == '=' ? ctx.mkLe((ArithExpr)exprMap.get(rhs), (ArithExpr)exprMap.get(v)) : ctx.mkLt((ArithExpr)exprMap.get(rhs), (ArithExpr)exprMap.get(v));
                                            solver.assert_(new BoolExpr[]{(BoolExpr)ctx.mkITE(condition, (Expr)ctx.mkDistinct(new Expr[]{(Expr)exprMap.get(lhs), ctx.mkInt(0)}), (Expr)ctx.mkEq((Expr)exprMap.get(lhs), (Expr)ctx.mkInt(0)))});
                                            break block0;
                                        }
                                    }
                                    System.out.println("Not yet supported");
                                    throw new TestFailedException();
                                }
                                System.out.println("Wrong constraint form" + c);
                                throw new TestFailedException();
                            }
                            solver.assert_(new BoolExpr[]{ctx.mkEq((Expr)exprMap.get(lhs), (Expr)exprMap.get(rhs))});
                            break;
                        }
                        case '<': {
                            if (op.length() > 1 && op.charAt(1) == '=') {
                                solver.assert_(new BoolExpr[]{ctx.mkLe((ArithExpr)exprMap.get(lhs), (ArithExpr)exprMap.get(rhs))});
                                break;
                            }
                            solver.assert_(new BoolExpr[]{ctx.mkLt((ArithExpr)exprMap.get(lhs), (ArithExpr)exprMap.get(rhs))});
                            break;
                        }
                        case '>': {
                            if (op.length() > 1 && op.charAt(1) == '=') {
                                solver.assert_(new BoolExpr[]{ctx.mkGe((ArithExpr)exprMap.get(lhs), (ArithExpr)exprMap.get(rhs))});
                                break;
                            }
                            solver.assert_(new BoolExpr[]{ctx.mkGt((ArithExpr)exprMap.get(lhs), (ArithExpr)exprMap.get(rhs))});
                            break;
                        }
                        case '!': {
                            if (op.length() > 1 && op.charAt(1) == '=') {
                                solver.assert_(new BoolExpr[]{ctx.mkDistinct(new Expr[]{(Expr)exprMap.get(lhs), (Expr)exprMap.get(rhs)})});
                                break;
                            }
                            System.out.println("Wrong constraint form" + op);
                            throw new TestFailedException();
                        }
                        default: {
                            System.out.println("Not yet supported");
                            throw new TestFailedException();
                        }
                    }
                    continue;
                }
                System.out.println("Wrong constraint form" + constraint);
                throw new TestFailedException();
            }
            System.out.println("Wrong constraint form" + constraint);
            throw new TestFailedException();
        }
        Model model = null;
        if (Status.SATISFIABLE == solver.check()) {
            model = solver.getModel();
            if (this.debug) {
                System.out.println("Solver = " + solver);
                System.out.println("Model = " + model);
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            List<String> thisProps = this.staticConcolic.getJavaThisProperties();
            for (int j = 0; j < thisProps.size(); ++j) {
                result.put("this." + thisProps.get(j), Integer.parseInt(model.getConstInterp((Expr)exprMap.get("this." + thisProps.get(j))).toString()));
            }
            for (int i = 0; i < inum; ++i) {
                result.put("i" + i, Integer.parseInt(model.getConstInterp((Expr)exprMap.get("i" + i)).toString()));
                if (!this.staticConcolic.hasObjectInformation(i)) continue;
                List<String> props2 = this.staticConcolic.getJavaObjectProperties(i);
                if (this.staticConcolic.getJavaObjectConstructors(i) == "Array") {
                    String length2 = props2.get(0);
                    for (int j = 0; j < Integer.parseInt(length2); ++j) {
                        result.put("i" + i + "." + Integer.toString(j), Integer.parseInt(model.getConstInterp((Expr)exprMap.get("i" + i + "." + Integer.toString(j))).toString()));
                    }
                    continue;
                }
                for (int j = 0; j < props2.size(); ++j) {
                    result.put("i" + i + "." + props2.get(j), Integer.parseInt(model.getConstInterp((Expr)exprMap.get("i" + i + "." + props2.get(j))).toString()));
                }
            }
            return result;
        }
        System.out.println(solver.check());
        System.out.println("BUG, the constraints are not satisfiable.");
        throw new TestFailedException();
    }

    public Option<HashMap<String, Integer>> solve(List<Constraint> constraints, Integer inum, StaticConcolicInterface sc) {
        this.staticConcolic = sc;
        try {
            HashMap<String, String> cfg = new HashMap<String, String>();
            cfg.put("model", "true");
            Context ctx = new Context(cfg);
            if (!constraints.isEmpty()) {
                return Option.some(this.ConstraintSolver(ctx, constraints, inum));
            }
            return Option.none();
        }
        catch (Z3Exception ex) {
            System.out.println("TEST CASE FAILED: " + ex.getMessage());
            System.out.println("Stack trace: ");
            ex.printStackTrace(System.out);
            return Option.none();
        }
        catch (Exception ex) {
            System.out.println("Unknown Exception: " + ex.getMessage());
            System.out.println("Stack trace: ");
            ex.printStackTrace(System.out);
            return Option.none();
        }
    }

    class TestFailedException
    extends Exception {
        public TestFailedException() {
            super("Check FAILED");
        }
    }
}

