/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import kr.ac.kaist.jsaf.nodes.IRExpr;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IROpApp;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRLoad
extends IROpApp {
    private final IRId _obj;
    private final IRExpr _index;

    public IRLoad(IRSpanInfo in_info, IRId in_obj, IRExpr in_index) {
        super(in_info);
        if (in_obj == null) {
            throw new IllegalArgumentException("Parameter 'obj' to the IRLoad constructor was null");
        }
        this._obj = in_obj;
        if (in_index == null) {
            throw new IllegalArgumentException("Parameter 'index' to the IRLoad constructor was null");
        }
        this._index = in_index;
    }

    public final IRId getObj() {
        return this._obj;
    }

    public final IRExpr getIndex() {
        return this._index;
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRLoad(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRLoad(this);
    }

    public boolean equals(Object obj) {
        IRExpr casted_index;
        IRId casted_obj;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRLoad casted = (IRLoad)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        IRId temp_obj = this.getObj();
        if (temp_obj != (casted_obj = casted.getObj()) && !temp_obj.equals(casted_obj)) {
            return false;
        }
        IRExpr temp_index = this.getIndex();
        return temp_index == (casted_index = casted.getIndex()) || temp_index.equals(casted_index);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        IRId temp_obj = this.getObj();
        code ^= temp_obj.hashCode();
        IRExpr temp_index = this.getIndex();
        return code ^= temp_index.hashCode();
    }

    protected IRLoad() {
        this._obj = null;
        this._index = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRLoad", 3)) {
            IRExpr temp_index;
            IRId temp_obj;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("obj", temp_obj = this.getObj())) {
                temp_obj.walk(w);
                w.endNodeField("obj", temp_obj);
            }
            if (w.visitNodeField("index", temp_index = this.getIndex())) {
                temp_index.walk(w);
                w.endNodeField("index", temp_index);
            }
            w.endNode(this, "IRLoad", 3);
        }
    }
}

