/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import java.io.StringWriter;
import java.io.Writer;
import kr.ac.kaist.jsaf.nodes.IRNode;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.LosslessStringWalker;
import kr.ac.kaist.jsaf.nodes.TreeWalker;
import kr.ac.kaist.jsaf.nodes_util.UIDObject;

public class IROp
extends UIDObject
implements IRNode {
    private final String _text;
    private final int _kind;
    private int _hashCode;
    private boolean _hasHashCode = false;

    public IROp(String in_text, int in_kind) {
        if (in_text == null) {
            throw new IllegalArgumentException("Parameter 'text' to the IROp constructor was null");
        }
        this._text = in_text.intern();
        this._kind = in_kind;
    }

    public final String getText() {
        return this._text;
    }

    public final int getKind() {
        return this._kind;
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIROp(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIROp(this);
    }

    @Override
    public final int hashCode() {
        if (!this._hasHashCode) {
            this._hashCode = this.generateHashCode();
            this._hasHashCode = true;
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        int casted_kind;
        String casted_text;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IROp casted = (IROp)obj;
        String temp_text = this.getText();
        if (temp_text != (casted_text = casted.getText())) {
            return false;
        }
        int temp_kind = this.getKind();
        return temp_kind == (casted_kind = casted.getKind());
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        String temp_text = this.getText();
        code ^= temp_text.hashCode();
        int temp_kind = this.getKind();
        return code ^= temp_kind;
    }

    protected IROp() {
        this._text = null;
        this._kind = 0;
    }

    @Override
    public String serialize() {
        StringWriter w = new StringWriter();
        this.walk(new LosslessStringWalker(w, 2));
        return w.toString();
    }

    @Override
    public void serialize(Writer writer) {
        this.walk(new LosslessStringWalker(writer, 2));
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IROp", 2)) {
            int temp_kind;
            String temp_text = this.getText();
            if (w.visitNodeField("text", temp_text)) {
                w.visitString(temp_text);
                w.endNodeField("text", temp_text);
            }
            if (w.visitNodeField("kind", temp_kind = this.getKind())) {
                w.visitInt(temp_kind);
                w.endNodeField("kind", temp_kind);
            }
            w.endNode(this, "IROp", 2);
        }
    }
}

