/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import edu.rice.cs.plt.tuple.Option;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Comparator;
import kr.ac.kaist.jsaf.nodes.Comment;
import kr.ac.kaist.jsaf.nodes.Program;
import kr.ac.kaist.jsaf.nodes_util.Lex;
import kr.ac.kaist.jsaf.nodes_util.NodeUtil;
import kr.ac.kaist.jsaf.nodes_util.Printer;
import kr.ac.kaist.jsaf.nodes_util.SourceLoc;
import kr.ac.kaist.jsaf.nodes_util.Unprinter;

public class ASTIO {
    private static final String LOG_FILE_NONE = "";
    private static String logFileName = "";
    private static volatile FileOutputStream fs = null;
    private static volatile OutputStreamWriter fw = null;
    private static volatile BufferedWriter logFile = null;
    public static final Comparator<Comment> commentComparator = new Comparator<Comment>(){

        public int compareTo(int arg0, int arg1) {
            return arg0 < arg1 ? -1 : (arg0 == arg1 ? 0 : 1);
        }

        @Override
        public int compare(Comment arg0, Comment arg1) {
            SourceLoc begin0 = NodeUtil.getSpan(arg0).getBegin();
            SourceLoc begin1 = NodeUtil.getSpan(arg1).getBegin();
            if (begin0.getLine() == begin1.getLine()) {
                return this.compareTo(begin0.column(), begin1.column());
            }
            return this.compareTo(begin0.getLine(), begin1.getLine());
        }
    };

    private static long logStart() {
        if (logFileName == LOG_FILE_NONE) {
            return 0L;
        }
        return System.nanoTime();
    }

    private static synchronized boolean initLogFile() {
        if (logFile != null) {
            return false;
        }
        try {
            fs = new FileOutputStream(logFileName, true);
            fw = new OutputStreamWriter((OutputStream)fs, Charset.forName("UTF-8"));
            logFile = new BufferedWriter(fw);
        }
        catch (FileNotFoundException x) {
            System.err.println("WARNING: log file " + logFileName + " couldn't be opened.\nTurning logging off.");
            logFileName = LOG_FILE_NONE;
            logFile = null;
            return true;
        }
        return false;
    }

    private static void logStop(long start, String eventName, String fileName) {
        if (logFileName == LOG_FILE_NONE) {
            return;
        }
        long nanos = System.nanoTime() - start;
        if (logFile == null && ASTIO.initLogFile()) {
            return;
        }
        String toWrite = eventName + "," + fileName + "," + nanos + "\n";
        try {
            logFile.write(toWrite);
            logFile.flush();
            logFile.close();
            fw.close();
            fs.close();
        }
        catch (IOException e) {
            System.err.print("WARNING: could not log event.\n" + toWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJavaAst(Object p, String reportedFileName, OutputStream fout) throws IOException {
        long t0 = ASTIO.logStart();
        try {
            BufferedWriter utf8fout = new BufferedWriter(new OutputStreamWriter(fout, Charset.forName("UTF-8")));
            new Printer().dump(p, utf8fout, 0);
            utf8fout.flush();
        }
        finally {
            ASTIO.logStop(t0, "W", reportedFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJavaAst(Object p, String s) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(s);){
            ASTIO.writeJavaAst(p, s, fout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Option<Program> readJavaAst(String reportedFileName, InputStream fin) throws IOException {
        long t0 = ASTIO.logStart();
        BufferedReader br = new BufferedReader(new InputStreamReader(fin, Charset.forName("UTF-8")));
        Lex lex = new Lex(br, reportedFileName);
        try {
            Unprinter up = new Unprinter(lex);
            lex.name();
            Program p = (Program)up.readNode(lex.name());
            if (p == null) {
                Option option = Option.none();
                return option;
            }
            Option option = Option.some((Object)p);
            return option;
        }
        finally {
            if (!lex.atEOF()) {
                System.out.println("Parse of " + reportedFileName + " ended EARLY at line = " + lex.line() + ",  column = " + lex.column());
            }
            ASTIO.logStop(t0, "R", reportedFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Option<Program> readJavaAst(String fileName) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileName);){
            Option<Program> option = ASTIO.readJavaAst(fileName, fin);
            return option;
        }
    }
}

