/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import kr.ac.kaist.jsaf.nodes_util.Unprinter;

public class Lex {
    BufferedReader reader;
    String name;
    int last = -1;
    int lastread = -1;
    int line = 1;
    int column = 0;
    private static final int NORMAL = 0;
    private static final int SAW_BACKSLASH = 1;
    private static final int SAW_BACKSLASH_TICK = 2;

    public Lex(BufferedReader r) {
        this(r, "unnamed file");
    }

    public Lex(BufferedReader r, String name) {
        this.reader = r;
        this.name = name;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    private int read() throws IOException {
        int x = this.last;
        this.last = -1;
        if (x == -1) {
            ++this.column;
            x = this.reader.read();
            if (x == 13) {
                ++this.line;
                this.column = 0;
            } else if (x == 10) {
                if (this.lastread != 13) {
                    ++this.line;
                }
                this.column = 0;
            }
        }
        this.lastread = x;
        return x;
    }

    private void unread() {
        this.last = this.lastread;
    }

    public void white() throws IOException {
        int c = this.read();
        while (c == -1 || Character.isWhitespace(c)) {
            if (c == -1) {
                throw new EOFException();
            }
            c = this.read();
        }
        this.unread();
    }

    public String string() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.white();
        int i = this.read();
        if (i == 40 || i == 41) {
            sb.append((char)i);
            this.read();
            this.unread();
            return sb.toString();
        }
        if (i == 34) {
            sb.append('\"');
            this.readQuoted(sb);
            sb.append('\"');
        } else {
            boolean quoted = false;
            while (i != -1 && (quoted || i != 40 && i != 41 && !Character.isWhitespace(i))) {
                if (quoted) {
                    sb.append((char)i);
                    quoted = false;
                } else if (i == 96) {
                    quoted = true;
                } else {
                    sb.append((char)i);
                }
                i = this.read();
            }
        }
        this.unread();
        return sb.toString();
    }

    public boolean atEOF() throws IOException {
        int c = this.read();
        while (c != -1 && Character.isWhitespace(c)) {
            c = this.read();
        }
        if (c == -1) {
            return true;
        }
        this.unread();
        return false;
    }

    public String name() throws IOException {
        return this.name(true);
    }

    public String name(boolean skipLeadingWhite) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        if (skipLeadingWhite) {
            this.white();
        }
        if ((c = this.read()) == 40 || c == 41 || c == 91 || c == 93 || c == 64 || c == 61 || c == 44 || c == 58 || c == 126 || c == 33) {
            sb.append((char)c);
            this.read();
            this.unread();
            return sb.toString();
        }
        if (c == 34) {
            sb.append('\"');
            this.readQuoted(sb);
            sb.append('\"');
        } else {
            if (c == 45) {
                sb.append((char)c);
                c = this.read();
            }
            while (c != -1 && (c == 95 || c == 36 || Character.isLetterOrDigit(c))) {
                sb.append((char)c);
                c = this.read();
            }
        }
        this.unread();
        return sb.toString();
    }

    private void readQuoted(StringBuilder sb) throws IOException {
        int i = this.read();
        int state = 0;
        while (i != -1) {
            char c = (char)i;
            if (state == 0) {
                if (c == '\"') {
                    this.read();
                    break;
                }
                if (c == '\\') {
                    state = 1;
                }
            } else if (state == 1) {
                if (c == 'b' || c == 't' || c == 'n' || c == 'f' || c == 'r' || c == 'v' || c == '\"' || c == '\\') {
                    state = 0;
                } else if (c == '\'') {
                    state = 2;
                } else if (File.separator.equals("\\")) {
                    state = 0;
                } else {
                    this.unexpected("Backslash escape " + c + "(hex " + Integer.toHexString(c) + ") ");
                }
            } else if (state == 2 && c == '\'') {
                state = 0;
            }
            sb.append(c);
            i = this.read();
        }
    }

    public int integer() throws IOException {
        String s = this.string();
        if (s.startsWith("-")) {
            return -Integer.parseInt(s.substring(1));
        }
        return Integer.parseInt(s);
    }

    public void unexpected(String got, String wanted) throws IOException {
        throw new IOException("Near line " + this.line + " and column " + this.column + " got " + got + ", wanted " + wanted + ", reading " + this.name);
    }

    public void unexpected(String got) throws IOException {
        throw new IOException("Near line " + this.line + " and column " + this.column + " got " + got + ", reading " + this.name);
    }

    public Lex lp() throws IOException {
        this.expectPrefix("(");
        return this;
    }

    public Lex rp() throws IOException {
        this.expectPrefix(")");
        return this;
    }

    public void expect(String s) throws IOException {
        int i;
        this.white();
        int l = s.length();
        if (l == 0) {
            return;
        }
        int c = this.read();
        for (i = 0; c != -1 && i < l; ++i) {
            if (s.charAt(i) != c) {
                if (Character.isWhitespace(c) || c == 40 || c == 41) break;
                throw new IOException("Expected " + s.substring(0, i) + "[" + s.substring(i, i + 1) + "]" + s.substring(i + 1) + " saw [" + (char)c + "] instead at line " + this.line() + " and column " + this.column() + " of " + this.name);
            }
            c = this.read();
        }
        if (c != -1 && !Character.isWhitespace(c) && c != 40 && c != 41 || i != l) {
            if (i != l) {
                throw new IOException("Expected " + s.substring(0, i) + "[" + s.substring(i, i + 1) + "]" + s.substring(i + 1) + " saw [" + (char)c + "] instead at line " + this.line() + " and column " + this.column() + " of " + this.name);
            }
            throw new IOException("Expected " + s + " followed by whitespace but saw [" + (char)c + "] instead at line " + this.line() + " and column " + this.column() + " of " + this.name);
        }
        this.unread();
    }

    public void expectPrefix(String s) throws IOException {
        int i;
        this.white();
        int l = s.length();
        if (l == 0) {
            return;
        }
        int c = this.read();
        for (i = 0; c != -1 && !Character.isWhitespace(c) && i < l; ++i) {
            if (s.charAt(i) != c) {
                throw new IOException("Expected " + s.substring(0, i) + "[" + s.substring(i, i + 1) + "]" + s.substring(i + 1) + " saw [" + (char)c + "] instead at line " + this.line() + " and column " + this.column() + " of " + this.name);
            }
            c = this.read();
        }
        if (i != l) {
            throw new IOException("Expected " + s.substring(0, i) + "[" + s.substring(i, i + 1) + "]" + s.substring(i + 1) + " saw [" + (char)c + "] instead at line " + this.line() + " and column " + this.column() + " of " + this.name);
        }
        this.unread();
    }

    public String conditionallyUnquotedString() throws IOException {
        String s = this.string();
        if (s.startsWith("\"")) {
            s = Unprinter.deQuote(s);
        }
        return s;
    }

    public boolean boolean_() throws IOException {
        String s = this.string();
        if (s.startsWith("t")) {
            return true;
        }
        if (s.startsWith("f")) {
            return false;
        }
        if (s.startsWith("T")) {
            return true;
        }
        if (s.startsWith("F")) {
            return false;
        }
        throw new IOException("Expected true or false, saw " + s + "instead at line " + this.line() + " and column " + this.column() + " of " + this.name);
    }
}

