/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kr.ac.kaist.jsaf.exceptions.JSAFError;
import kr.ac.kaist.jsaf.nodes.ASTNode;
import kr.ac.kaist.jsaf.nodes.AbstractNode;
import kr.ac.kaist.jsaf.nodes.Node;
import kr.ac.kaist.jsaf.nodes_util.NodeFactory;
import kr.ac.kaist.jsaf.nodes_util.Span;
import kr.ac.kaist.jsaf.nodes_util.SpanInfo;

public abstract class NodeReflection {
    public static final String NODES_PACKAGE_PREFIX = "kr.ac.kaist.jsaf.nodes.";
    public static final Object[] args0 = new Object[0];
    private HashMap<String, HashMap<String, Field>> shortClassNameToFieldNameToField = new HashMap();
    private HashMap<String, Class> classMap = new HashMap();
    private HashMap<String, Constructor> constructorMap = new HashMap();
    private HashMap<String, Constructor> constructorMapZero = new HashMap();
    private HashMap<String, Field[]> shortClassNameToFieldArray = new HashMap();
    private Field infoField;
    static Class[] zeroArg = new Class[0];
    protected static final Comparator<Field> fieldComparator = new Comparator<Field>(){

        @Override
        public int compare(Field arg0, Field arg1) {
            Class<?> c0 = arg0.getType();
            Class<?> c1 = arg1.getType();
            if (c0 == List.class && c1 != List.class) {
                return 1;
            }
            if (c0 != List.class && c1 == List.class) {
                return -1;
            }
            String s0 = arg0.getName();
            String s1 = arg1.getName();
            return s0.compareTo(s1);
        }
    };

    protected NodeReflection() {
        try {
            this.infoField = AbstractNode.class.getDeclaredField("_info");
            this.infoField.setAccessible(true);
        }
        catch (SecurityException e) {
            JSAFError.error(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            JSAFError.error(e.getMessage());
        }
    }

    protected Field fieldFor(String class_name, String field_name) {
        return this.shortClassNameToFieldNameToField.get(class_name).get(field_name);
    }

    protected Constructor constructorFor(String class_name) {
        return this.constructorMap.get(class_name);
    }

    protected Constructor constructorZeroFor(String class_name) {
        return this.constructorMapZero.get(class_name);
    }

    protected Node makeNodeFromSpan(String s, Class c, Span span) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor con;
        Constructor constructor = con = s != null ? this.constructorZeroFor(s) : this.constructorZeroFor(c);
        if (con != null) {
            Node node = (Node)con.newInstance(args0);
            if (node instanceof ASTNode) {
                this.infoField.set((ASTNode)node, NodeFactory.makeSpanInfo(span));
            }
            return node;
        }
        con = s != null ? this.constructorFor(s) : this.constructorFor(c);
        Object[] args = new Object[]{span};
        return (Node)con.newInstance(args);
    }

    protected Constructor constructorFor(Class cls) {
        String sn = cls.getSimpleName();
        Constructor c = this.constructorMap.get(sn);
        if (c == null) {
            this.classFor(sn);
            c = this.constructorMap.get(sn);
        }
        return c;
    }

    protected Constructor constructorZeroFor(Class cls) {
        String sn = cls.getSimpleName();
        Constructor c = this.constructorMapZero.get(sn);
        if (c == null) {
            c = this.constructorFor(cls);
            c = this.constructorMapZero.get(sn);
        }
        return c;
    }

    protected Field[] fieldArrayFor(String class_name) {
        return this.shortClassNameToFieldArray.get(class_name);
    }

    protected abstract Constructor defaultConstructorFor(Class var1) throws NoSuchMethodException;

    protected Constructor defaultConstructorZeroFor(Class cl) {
        try {
            return cl.getDeclaredConstructor(zeroArg);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    protected Class classFor(String class_name) {
        String full_class_name = NODES_PACKAGE_PREFIX + class_name;
        Class<?> cl = this.classMap.get(class_name);
        if (cl == null) {
            try {
                Constructor c0;
                cl = Class.forName(full_class_name);
                Field[] fields = NodeReflection.getPrintableFields(cl);
                HashMap<String, Field> h = new HashMap<String, Field>();
                for (int i = 0; i < fields.length; ++i) {
                    Field f = fields[i];
                    h.put(f.getName(), f);
                }
                this.shortClassNameToFieldArray.put(class_name, fields);
                this.shortClassNameToFieldNameToField.put(class_name, h);
                this.classMap.put(class_name, cl);
                Constructor c = this.defaultConstructorFor(cl);
                if (c != null) {
                    c.setAccessible(true);
                    this.constructorMap.put(class_name, c);
                }
                if ((c0 = this.defaultConstructorZeroFor(cl)) != null) {
                    c0.setAccessible(true);
                    this.constructorMapZero.put(class_name, c0);
                }
                if (c == null && c0 == null) {
                    JSAFError.error("Could not find an appropriate constructor for " + full_class_name);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                JSAFError.error("Error reading node type " + class_name);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                JSAFError.error("Error reading node type " + class_name);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                JSAFError.error("Error reading node type " + class_name + ", missing constructor (Span)");
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return cl;
    }

    protected static Field[] getPrintableFields(Class cl) throws SecurityException, NoSuchFieldException {
        ArrayList<Field> fal = new ArrayList<Field>();
        for (Class icl = cl; icl != SpanInfo.class && icl != Object.class; icl = icl.getSuperclass()) {
            Field[] fields = icl.getDeclaredFields();
            NodeReflection.handleFields(fields, fal);
        }
        Field[] ifields = new Field[fal.size()];
        ifields = fal.toArray(ifields);
        Arrays.sort(ifields, fieldComparator);
        return ifields;
    }

    private static void handleFields(Field[] fields, ArrayList<Field> fal) {
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if ((f.getModifiers() & 0x88) != 0 || f.getName().equals("_hashCode") || f.getName().equals("_hasHashCode")) continue;
            f.setAccessible(true);
            fal.add(f);
        }
    }

    protected final Field[] getCachedPrintableFields(Class cl) {
        return this.getCachedPrintableFields(cl, cl.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Field[] getCachedPrintableFields(Class cl, String clname) {
        Field[] fields = this.shortClassNameToFieldArray.get(clname);
        if (fields == null) {
            try {
                fields = NodeReflection.getPrintableFields(cl);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            HashMap<String, HashMap<String, Field>> hashMap = this.shortClassNameToFieldNameToField;
            synchronized (hashMap) {
                this.shortClassNameToFieldArray.put(clname, fields);
            }
        }
        return fields;
    }
}

