/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;

public class MemoryMeasurer {
    private static final Runtime runtime = Runtime.getRuntime();
    private static int gcRepeat = 4;

    public static double peakMemory() {
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        Long peakMemory = 0L;
        for (MemoryPoolMXBean pool : pools) {
            if (pool.getType() != MemoryType.HEAP) continue;
            peakMemory = peakMemory + pool.getPeakUsage().getUsed();
        }
        return (double)peakMemory.longValue() / 1048576.0;
    }

    public static double measureHeap() {
        for (int i = 0; i < gcRepeat; ++i) {
            MemoryMeasurer._runGC();
        }
        return (double)MemoryMeasurer.usedMemory() / 1048576.0;
    }

    private static void _runGC() {
        long usedMem1 = MemoryMeasurer.usedMemory();
        long usedMem2 = Long.MAX_VALUE;
        for (int i = 0; usedMem1 < usedMem2 && i < 500; ++i) {
            runtime.runFinalization();
            runtime.gc();
            Thread.yield();
            usedMem2 = usedMem1;
            usedMem1 = MemoryMeasurer.usedMemory();
        }
    }

    private static long usedMemory() {
        return runtime.totalMemory() - runtime.freeMemory();
    }
}

