/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.context;

import com.ibm.wala.util.collections.HashMapFactory;
import com.samsung.memoryanalysis.context.Context;
import com.samsung.memoryanalysis.context.ContextAwareAnalysis;
import com.samsung.memoryanalysis.context.ContextListener;
import com.samsung.memoryanalysis.context.DummyContextAwareAnalysis;
import com.samsung.memoryanalysis.options.MemoryAnalysisOptions;
import com.samsung.memoryanalysis.referencecounter.heap.ContextOrObjectId;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.Timer;
import com.samsung.memoryanalysis.traceparser.TraceAnalysis;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;

public class ContextProvider<T>
implements TraceAnalysis<T> {
    private final ContextAwareAnalysis<T> callbacks;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private final Map<Integer, WeakReference<Context>> contexts = HashMapFactory.make();
    private final Context GLOBAL;
    private final MemoryAnalysisOptions options;
    public static final int GLOBAL_OBJECT_ID = 1;
    private IIDMap iidMap;

    public ContextProvider(ContextAwareAnalysis<T> s, MemoryAnalysisOptions options) {
        this.options = options;
        this.GLOBAL = Context.makeGlobal();
        this.callbacks = s == null ? new DummyContextAwareAnalysis() : s;
    }

    @Override
    public void init(Timer timer, IIDMap iidMap) {
        this.contextStack.push(this.GLOBAL);
        this.iidMap = iidMap;
        ContextListener c = new ContextListener(){

            @Override
            public Context getGlobal() {
                return ContextProvider.this.GLOBAL;
            }

            @Override
            public Context getCurrent() {
                return (Context)ContextProvider.this.contextStack.peek();
            }

            @Override
            public Collection<Context> getLiveContexts() {
                return ContextProvider.this.contextStack;
            }
        };
        this.callbacks.init(timer, c, iidMap);
    }

    @Override
    public void declare(int iid, String name, int objectId) {
        if (objectId == 1) {
            objectId = 0;
        }
        Context ctx = this.contextStack.peek();
        ctx.newVariable(iid, name, objectId);
        this.callbacks.declare(iid, name, objectId, ctx);
    }

    @Override
    public void create(int iid, int objectId) {
        this.callbacks.create(iid, objectId);
    }

    @Override
    public void createFun(int iid, int objectId, int prototypeId, int functionEnterIID, Set<String> namesReferencedByClosures) {
        Context curr = this.contextStack.peek();
        curr.markReferenced(namesReferencedByClosures);
        this.contexts.put(objectId, new WeakReference<Context>(curr));
        this.callbacks.createFun(iid, objectId, prototypeId, functionEnterIID, namesReferencedByClosures, this.contextStack.peek());
    }

    @Override
    public void putField(int iid, int baseId, String offset, int objectId) {
        if (baseId == 1) {
            this.write(iid, offset, objectId);
        } else {
            if (objectId == 1) {
                objectId = 0;
            }
            this.callbacks.putField(iid, baseId, offset, objectId);
        }
    }

    @Override
    public void write(int iid, String name, int objectId) {
        if (objectId == 1) {
            objectId = 0;
        }
        Context ctx = this.contextStack.peek();
        Context res = ctx.writeToVariable(iid, name, objectId);
        this.callbacks.write(iid, name, objectId, res);
    }

    @Override
    public void lastUse(int objectId, int iid, int time) {
        this.callbacks.lastUse(objectId, iid, time);
    }

    @Override
    public void functionEnter(int iid, int functionId, int callSiteIID) {
        WeakReference<Context> contextWeakRef = this.contexts.get(functionId);
        Context context = null;
        if (contextWeakRef == null) {
            context = this.GLOBAL;
        } else {
            context = (Context)contextWeakRef.get();
            if (context == null) {
                context = this.GLOBAL;
            }
        }
        Context ctx = new Context(context, this.iidMap.get(iid).toString());
        this.contextStack.push(ctx);
        this.callbacks.functionEnter(iid, functionId, callSiteIID, ctx);
    }

    @Override
    public void functionExit(int iid) {
        Context ctx = this.contextStack.pop();
        Set<String> unReferenced = ctx.seal();
        this.callbacks.functionExit(iid, ctx, this.contextStack.peek(), unReferenced);
    }

    @Override
    public void topLevelFlush(int iid) {
        this.callbacks.topLevelFlush(iid, this.contextStack.peek());
    }

    @Override
    public T endExecution() {
        Set<String> c = this.GLOBAL.seal();
        return this.callbacks.endExecution(this.GLOBAL, c);
    }

    @Override
    public void updateIID(int objId, int newIID) {
        this.callbacks.updateIID(objId, newIID);
    }

    @Override
    public void debug(int iid, int oid) {
        this.callbacks.debug(iid, oid, this.contextStack.peek());
    }

    @Override
    public void returnStmt(int i) {
        this.callbacks.returnStmt(i);
    }

    @Override
    public void createDomNode(int iid, int objectId) {
        this.callbacks.createDomNode(iid, objectId);
    }

    @Override
    public void addDOMChild(int parentId, int childId) {
        this.callbacks.addDOMChild(parentId, childId);
    }

    @Override
    public void removeDOMChild(int parentId, int childId) {
        this.callbacks.removeDOMChild(parentId, childId);
    }

    @Override
    public void addToChildSet(int iid, int parent, String name, int child) {
        if (child == 1) {
            return;
        }
        ContextOrObjectId parentNode = parent == 1 ? ContextOrObjectId.make(this.GLOBAL) : ContextOrObjectId.make(parent);
        ContextOrObjectId childNode = ContextOrObjectId.make(child);
        this.callbacks.addToChildSet(iid, parentNode, name, childNode);
    }

    @Override
    public void removeFromChildSet(int iid, int parent, String name, int child) {
        if (child == 1) {
            return;
        }
        ContextOrObjectId parentNode = parent == 1 ? ContextOrObjectId.make(this.GLOBAL) : ContextOrObjectId.make(parent);
        ContextOrObjectId childNode = ContextOrObjectId.make(child);
        this.callbacks.removeFromChildSet(iid, parentNode, name, childNode);
    }

    @Override
    public void domRoot(int nodeId) {
        this.callbacks.domRoot(nodeId);
    }

    @Override
    public void scriptEnter(int iid, String filename) {
        if (this.options.isModuleScope()) {
            Context moduleContext = new Context(this.GLOBAL, "module " + filename);
            this.contextStack.push(moduleContext);
        }
        this.callbacks.scriptEnter(iid, filename);
    }

    @Override
    public void scriptExit(int iid) {
        if (this.options.isModuleScope()) {
            this.contextStack.pop();
        }
        this.callbacks.scriptExit(iid);
    }
}

