/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.staleness;

import com.ibm.wala.util.collections.HashMapFactory;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectStaleness {
    public static final int DEFAULT_VAL = -20;
    public static final int REMOVE_FROM_DOM_SITE = -50;
    public final int iid;
    public final int objectId;
    public final long creationTime;
    public final List<Integer> creationCallStack;
    public final ObjectType type;
    public long staleness = -20L;
    public long lastUseTime = -20L;
    public long lastUseSite = -20L;
    public long unreachableTime = -20L;
    public int unreachableSite = -20;
    public int shallowSize = -20;

    protected ObjectStaleness(int iid, int objectId, long creationTime, List<Integer> creationCallStack, ObjectType type) {
        this.iid = iid;
        this.objectId = objectId;
        this.creationTime = creationTime;
        this.creationCallStack = creationCallStack;
        this.type = type;
    }

    private List<String> callStackSourceLocs(boolean relative, IIDMap iidMap) {
        ArrayList<String> result = new ArrayList<String>();
        for (Integer iid : this.creationCallStack) {
            String s = relative ? Util.makeRelative(iidMap.get(iid)) : iidMap.get(iid).toString();
            result.add(s);
        }
        return result;
    }

    public Map toMap(IIDMap iidMap, boolean relative, boolean callStackSourceLocs) {
        HashMap o = HashMapFactory.make();
        o.put("objectId", this.objectId);
        o.put("creationTime", this.creationTime);
        if (callStackSourceLocs) {
            o.put("creationCallStack", this.callStackSourceLocs(relative, iidMap));
        } else {
            o.put("creationCallStack", this.creationCallStack);
        }
        o.put("unreachableTime", this.unreachableTime);
        String sourceLocation = this.unreachableSite == -20 ? "no information" : (this.unreachableSite == -1 ? "unknown" : (this.unreachableSite == 0 ? "end of program" : (relative ? Util.makeRelative(iidMap.get(this.unreachableSite)) : iidMap.get(this.unreachableSite).toString())));
        o.put("unreachableSite", sourceLocation);
        o.put("staleness", this.staleness == -20L ? -1L : this.staleness);
        o.put("lastUseTime", this.lastUseTime == -20L ? "never used" : Long.valueOf(this.lastUseTime));
        o.put("lastUseSite", this.lastUseSite == -20L ? "never used" : (this.lastUseSite == -50L ? "removed from DOM" : Long.valueOf(this.lastUseSite)));
        o.put("shallowSize", this.shallowSize);
        o.put("type", this.type.toString());
        return o;
    }

    public ObjectStaleness updateIID(int newIID, List<Integer> newCallStack) {
        ObjectStaleness result = new ObjectStaleness(newIID, this.objectId, this.creationTime, newCallStack, this.type);
        result.staleness = this.staleness;
        result.lastUseTime = this.lastUseTime;
        result.lastUseSite = this.lastUseSite;
        result.unreachableTime = this.unreachableTime;
        result.unreachableSite = this.unreachableSite;
        result.shallowSize = this.shallowSize;
        return result;
    }

    public static enum ObjectType {
        FUNCTION,
        OBJECT,
        DOM,
        PROTOTYPE;

    }
}

