/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.IndentedTextLogSink;
import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.debug.TextLogSink;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.text.TextUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLogSink
extends IndentedTextLogSink {
    private final Thunk<BufferedWriter> _writer;
    private volatile boolean _active;

    public FileLogSink(String filename) {
        this(new File(filename), null, true);
    }

    public FileLogSink(File f) {
        this(f, null, true);
    }

    public FileLogSink(File f, int idealLineWidth) {
        this(f, null, idealLineWidth, true);
    }

    public FileLogSink(File f, boolean closeOnExit) {
        this(f, null, closeOnExit);
    }

    public FileLogSink(File f, int idealLineWidth, boolean closeOnExit) {
        this(f, null, idealLineWidth, closeOnExit);
    }

    public FileLogSink(File f, String charset) {
        this(f, charset, true);
    }

    public FileLogSink(File f, String charset, boolean closeOnExit) {
        this._writer = this.initWriter(f, charset);
        this._active = false;
        if (closeOnExit) {
            IOUtil.closeOnExit(this);
        }
    }

    public FileLogSink(File f, String charset, int idealLineWidth) {
        this(f, charset, idealLineWidth, true);
    }

    public FileLogSink(File f, String charset, int idealLineWidth, boolean closeOnExit) {
        super(idealLineWidth);
        this._writer = this.initWriter(f, charset);
        this._active = false;
        if (closeOnExit) {
            IOUtil.closeOnExit(this);
        }
    }

    private Thunk<BufferedWriter> initWriter(final File f, final String charset) {
        return LazyThunk.make(new Thunk<BufferedWriter>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BufferedWriter value() {
                BufferedWriter bufferedWriter;
                FileOutputStream out = new FileOutputStream(f, true);
                try {
                    OutputStreamWriter w = charset == null ? new OutputStreamWriter(out) : new OutputStreamWriter((OutputStream)out, charset);
                    BufferedWriter result = new BufferedWriter(w);
                    IOUtil.closeOnExit(result);
                    String stars = TextUtil.repeat('*', 40);
                    result.write(stars);
                    result.newLine();
                    result.write("Opened log file " + TextLogSink.formatTime(new Date()));
                    result.newLine();
                    result.write(stars);
                    result.newLine();
                    result.newLine();
                    result.flush();
                    FileLogSink.this._active = true;
                    bufferedWriter = result;
                }
                catch (Throwable throwable) {
                    try {
                        if (!FileLogSink.this._active) {
                            ((OutputStream)out).close();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new WrappedException(e);
                    }
                }
                if (!FileLogSink.this._active) {
                    ((OutputStream)out).close();
                }
                return bufferedWriter;
            }
        });
    }

    @Override
    protected BufferedWriter writer(LogSink.Message m) {
        return this._writer.value();
    }

    @Override
    public void close() throws IOException {
        if (this._active) {
            this._writer.value().close();
            this._active = false;
        }
    }
}

