/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.debug.TextLogSink;
import edu.rice.cs.plt.debug.ThreadSnapshot;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.swing.ShadedTreeCellRenderer;
import edu.rice.cs.plt.swing.SwingUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLogSink
extends TextLogSink {
    private final String _name;
    private final Map<Long, Tree> _trees;
    private final boolean _exitOnClose;

    public TreeLogSink(String name) {
        this(name, false);
    }

    public TreeLogSink(String name, boolean exitOnClose) {
        this._name = name;
        this._trees = new HashMap<Long, Tree>();
        this._exitOnClose = exitOnClose;
    }

    @Override
    public void close() {
        for (Tree t : IterUtil.snapshot(this._trees.values())) {
            t.dispose();
        }
    }

    @Override
    protected void write(LogSink.Message m, SizedIterable<String> text) {
        final Tree tree = this.getTree(m.thread());
        final Entry entry = new Entry(m, text);
        tree.checkQueue();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                tree.addEntry(entry);
            }
        });
    }

    @Override
    protected void writeStart(LogSink.StartMessage m, SizedIterable<String> text) {
        final Tree tree = this.getTree(m.thread());
        final Entry entry = new Entry(m, text);
        tree.checkQueue();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                tree.addEntry(entry);
                tree.push();
            }
        });
    }

    @Override
    protected void writeEnd(LogSink.EndMessage m, SizedIterable<String> text) {
        final Tree tree = this.getTree(m.thread());
        final Entry entry = new Entry(m, text);
        tree.checkQueue();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                tree.addEntry(entry);
                tree.pop();
            }
        });
    }

    private synchronized Tree getTree(ThreadSnapshot thread) {
        final Long id = thread.getId();
        if (!this._trees.containsKey(id)) {
            this._trees.put(id, new Tree(this._name + ": " + TreeLogSink.formatThread(thread), new Runnable(){

                public void run() {
                    TreeLogSink.this._trees.remove(id);
                    if (TreeLogSink.this._exitOnClose && TreeLogSink.this._trees.isEmpty()) {
                        System.exit(0);
                    }
                }
            }));
        }
        return this._trees.get(id);
    }

    public static Thunk<TreeLogSink> factory(String name) {
        return TreeLogSink.factory(name, false);
    }

    public static Thunk<TreeLogSink> factory(String name, boolean exitOnClose) {
        return new Factory(name, exitOnClose);
    }

    private static class Tree {
        private volatile long _lastPainted;
        private volatile JFrame _frame;
        private final Runnable _onClose;
        private final LinkedList<DefaultMutableTreeNode> _stack;
        private final DefaultTreeModel _treeModel;

        public Tree(final String name, Runnable onClose) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(Entry.ROOT);
            this._stack = new LinkedList();
            this._stack.addFirst(root);
            this._treeModel = new DefaultTreeModel(root);
            this._lastPainted = 0L;
            this._onClose = onClose;
            this._frame = null;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Tree.this.initGUI(name);
                }
            });
        }

        private void initGUI(String name) {
            this._frame = SwingUtil.makeDisposableFrame(name, 600, 600);
            SwingUtil.onWindowClosed(this._frame, this._onClose);
            final JTree tree = new JTree(this._treeModel){

                public void paint(Graphics g) {
                    super.paint(g);
                    Tree.this._lastPainted = System.currentTimeMillis();
                }
            };
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
            tree.setRowHeight(0);
            this._treeModel.addTreeModelListener(new TreeModelListener(){

                public void treeNodesInserted(TreeModelEvent e) {
                    Tree.this._treeModel.removeTreeModelListener(this);
                    tree.expandPath(e.getTreePath());
                }

                public void treeNodesChanged(TreeModelEvent e) {
                }

                public void treeNodesRemoved(TreeModelEvent e) {
                }

                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
            final JPanel entryCell = SwingUtil.makeVerticalBoxPanel(3, 5);
            JPanel top = SwingUtil.makeHorizontalBoxPanel();
            final JPanel bottom = SwingUtil.makeBorderPanel(3, 15, 0, 0);
            SwingUtil.setOpaque(false, top, bottom);
            SwingUtil.setLeftAlignment(top, bottom);
            SwingUtil.add(entryCell, top, bottom);
            final JLabel location = new JLabel();
            final JLabel time = new JLabel();
            final JLabel descendents = new JLabel();
            final JTextArea text = new JTextArea();
            SwingUtil.setMonospacedFont(12, location, time, descendents, text);
            SwingUtil.setEmptyBorder(0, 10, 0, 0, location, descendents);
            text.setOpaque(false);
            SwingUtil.add(top, time, location, descendents);
            bottom.add(text);
            tree.setCellRenderer(new TreeCellRenderer(){

                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Entry e = (Entry)((DefaultMutableTreeNode)value).getUserObject();
                    if (e.descendents() == 0) {
                        descendents.setVisible(false);
                    } else {
                        descendents.setVisible(true);
                        descendents.setText("(" + e.descendents() + ")");
                    }
                    time.setText(e.time());
                    location.setText(e.location());
                    text.setText(IterUtil.multilineToString(e.text()));
                    bottom.setVisible(!text.getText().equals(""));
                    return entryCell;
                }
            });
            ShadedTreeCellRenderer.shadeTree(tree, SwingUtil.gray(0.1f), SwingUtil.gray(0.03f));
            this._frame.getContentPane().add(new JScrollPane(tree));
            SwingUtil.displayWindow(this._frame);
        }

        public void checkQueue() {
            if (System.currentTimeMillis() - this._lastPainted > 200L) {
                SwingUtil.attemptClearEventQueue();
            }
        }

        public void addEntry(Entry e) {
            DefaultMutableTreeNode parent = this._stack.getFirst();
            this._treeModel.insertNodeInto(new DefaultMutableTreeNode(e), parent, parent.getChildCount());
            for (DefaultMutableTreeNode ancestor : this._stack) {
                ((Entry)ancestor.getUserObject()).incrementDescendents();
                this._treeModel.nodeChanged(ancestor);
            }
        }

        public void push() {
            this._stack.addFirst((DefaultMutableTreeNode)this._stack.getFirst().getLastChild());
        }

        public void pop() {
            if (this._stack.size() > 1) {
                this._stack.removeFirst();
            }
        }

        public void dispose() {
            if (this._frame != null) {
                this._frame.dispose();
            }
            this._onClose.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private final String _time;
        private final String _location;
        private final SizedIterable<String> _text;
        private int _descendents;
        private static final Entry ROOT = new Entry();

        public Entry(LogSink.Message m, SizedIterable<String> text) {
            this._time = TextLogSink.formatTime(m.time());
            this._location = TextLogSink.formatLocation(m.caller());
            this._text = text;
            this._descendents = 0;
        }

        private Entry() {
            this._time = "<root>";
            this._location = "<root>";
            this._text = IterUtil.empty();
            this._descendents = 0;
        }

        public int descendents() {
            return this._descendents;
        }

        public String time() {
            return this._time;
        }

        public String location() {
            return this._location;
        }

        public SizedIterable<String> text() {
            return this._text;
        }

        public void incrementDescendents() {
            ++this._descendents;
        }

        public String toString() {
            return this._location + " " + this._time;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    implements Thunk<TreeLogSink>,
    Serializable {
        private final String _name;
        private final boolean _exitOnClose;

        public Factory(String name, boolean exitOnClose) {
            this._name = name;
            this._exitOnClose = exitOnClose;
        }

        @Override
        public TreeLogSink value() {
            return new TreeLogSink(this._name, this._exitOnClose);
        }
    }
}

