/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipFirstIterable<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
OptimizedLastIterable<T>,
Composite,
Serializable {
    private final Iterable<T> _iterable;

    public SkipFirstIterable(Iterable<T> iterable) {
        this._iterable = iterable;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._iterable) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._iterable) + 1;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> result = this._iterable.iterator();
        if (result.hasNext()) {
            result.next();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return IterUtil.sizeOf(this._iterable, 2) < 2;
    }

    @Override
    public int size() {
        int nestedSize = IterUtil.sizeOf(this._iterable);
        if (nestedSize == 0) {
            return 0;
        }
        if (nestedSize == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return nestedSize - 1;
    }

    @Override
    public int size(int bound) {
        if (bound == Integer.MAX_VALUE) {
            return this.size();
        }
        int nestedSize = IterUtil.sizeOf(this._iterable, bound + 1);
        return nestedSize == 0 ? 0 : nestedSize - 1;
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._iterable);
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._iterable);
    }

    @Override
    public boolean isStatic() {
        return IterUtil.isStatic(this._iterable);
    }

    @Override
    public T last() {
        IterUtil.first(this);
        return IterUtil.last(this._iterable);
    }

    public static <T> SkipFirstIterable<T> make(Iterable<T> iterable) {
        return new SkipFirstIterable<T>(iterable);
    }

    public static <T> SnapshotIterable<T> makeSnapshot(Iterable<T> iterable) {
        return new SnapshotIterable<T>(new SkipFirstIterable<T>(iterable));
    }
}

