/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Iterator;
import java.util.Map;

public class ExtensionGraph<T>
implements NumberedGraph<T> {
    private final NumberedGraph<T> original;
    private final NumberedNodeManager<T> additionalNodes = new SlowNumberedNodeManager();
    private final NumberedEdgeManager<T> edgeManager = new NumberedEdgeManager<T>(){
        private final Map<T, MutableIntSet> inEdges = HashMapFactory.make();
        private final Map<T, MutableIntSet> outEdges = HashMapFactory.make();

        private Iterator<T> nodes(final T node, final Map<T, ? extends IntSet> extra) {
            if (extra.containsKey(node)) {
                return new Iterator<T>(){
                    private final IntIterator i;
                    {
                        this.i = ((IntSet)extra.get(node)).intIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public T next() {
                        return ExtensionGraph.this.getNode(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return EmptyIterator.instance();
        }

        @Override
        public Iterator<T> getPredNodes(T n) {
            EmptyIterator orig = ExtensionGraph.this.original.containsNode(n) ? ExtensionGraph.this.original.getPredNodes(n) : EmptyIterator.instance();
            return new CompoundIterator(orig, this.nodes(n, this.inEdges));
        }

        @Override
        public int getPredNodeCount(T n) {
            return (ExtensionGraph.this.original.containsNode(n) ? ExtensionGraph.this.original.getPredNodeCount(n) : 0) + (this.inEdges.containsKey(n) ? this.inEdges.get(n).size() : 0);
        }

        @Override
        public Iterator<T> getSuccNodes(T n) {
            EmptyIterator orig = ExtensionGraph.this.original.containsNode(n) ? ExtensionGraph.this.original.getSuccNodes(n) : EmptyIterator.instance();
            return new CompoundIterator(orig, this.nodes(n, this.outEdges));
        }

        @Override
        public int getSuccNodeCount(T n) {
            return (ExtensionGraph.this.original.containsNode(n) ? ExtensionGraph.this.original.getSuccNodeCount(n) : 0) + (this.outEdges.containsKey(n) ? this.outEdges.get(n).size() : 0);
        }

        @Override
        public void addEdge(T src, T dst) {
            assert (!ExtensionGraph.this.original.hasEdge(src, dst));
            assert (ExtensionGraph.this.containsNode(src) && ExtensionGraph.this.containsNode(dst));
            if (!this.inEdges.containsKey(dst)) {
                this.inEdges.put(dst, IntSetUtil.make());
            }
            this.inEdges.get(dst).add(ExtensionGraph.this.getNumber(src));
            if (!this.outEdges.containsKey(src)) {
                this.outEdges.put(src, IntSetUtil.make());
            }
            this.outEdges.get(src).add(ExtensionGraph.this.getNumber(dst));
        }

        @Override
        public void removeEdge(T src, T dst) throws UnsupportedOperationException {
            assert (this.hasEdge(src, dst));
            assert (!ExtensionGraph.this.original.hasEdge(src, dst));
            assert (ExtensionGraph.this.containsNode(src) && ExtensionGraph.this.containsNode(dst));
            this.inEdges.get(dst).remove(ExtensionGraph.this.getNumber(src));
            this.outEdges.get(src).remove(ExtensionGraph.this.getNumber(dst));
        }

        @Override
        public void removeAllIncidentEdges(T node) throws UnsupportedOperationException {
            this.removeIncomingEdges(node);
            this.removeOutgoingEdges(node);
        }

        @Override
        public void removeIncomingEdges(T node) throws UnsupportedOperationException {
            assert (!ExtensionGraph.this.original.containsNode(node) || ExtensionGraph.this.original.getPredNodeCount(node) == 0);
            this.inEdges.remove(node);
        }

        @Override
        public void removeOutgoingEdges(T node) throws UnsupportedOperationException {
            assert (!ExtensionGraph.this.original.containsNode(node) || ExtensionGraph.this.original.getSuccNodeCount(node) == 0);
            this.outEdges.remove(node);
        }

        @Override
        public boolean hasEdge(T src, T dst) {
            return ExtensionGraph.this.original.hasEdge(src, dst) || this.outEdges.containsKey(src) && this.outEdges.get(src).contains(ExtensionGraph.this.getNumber(dst));
        }

        @Override
        public IntSet getSuccNodeNumbers(T node) {
            if (ExtensionGraph.this.original.containsNode(node)) {
                if (this.outEdges.containsKey(node)) {
                    MutableIntSet x = IntSetUtil.makeMutableCopy(ExtensionGraph.this.original.getSuccNodeNumbers(node));
                    x.addAll(this.outEdges.get(node));
                    return x;
                }
                return ExtensionGraph.this.original.getSuccNodeNumbers(node);
            }
            if (this.outEdges.containsKey(node)) {
                return this.outEdges.get(node);
            }
            return EmptyIntSet.instance;
        }

        @Override
        public IntSet getPredNodeNumbers(T node) {
            if (ExtensionGraph.this.original.containsNode(node)) {
                if (this.inEdges.containsKey(node)) {
                    MutableIntSet x = IntSetUtil.makeMutableCopy(ExtensionGraph.this.original.getPredNodeNumbers(node));
                    x.addAll(this.inEdges.get(node));
                    return x;
                }
                return ExtensionGraph.this.original.getPredNodeNumbers(node);
            }
            if (this.inEdges.containsKey(node)) {
                return this.inEdges.get(node);
            }
            return EmptyIntSet.instance;
        }
    };

    public ExtensionGraph(NumberedGraph<T> original) {
        this.original = original;
    }

    @Override
    public Iterator<T> iterator() {
        return new CompoundIterator(this.original.iterator(), this.additionalNodes.iterator());
    }

    @Override
    public int getNumberOfNodes() {
        return this.original.getNumberOfNodes() + this.additionalNodes.getNumberOfNodes();
    }

    @Override
    public void addNode(T n) {
        assert (!this.original.containsNode(n));
        this.additionalNodes.addNode(n);
    }

    @Override
    public void removeNode(T n) throws UnsupportedOperationException {
        assert (!this.original.containsNode(n));
        this.additionalNodes.removeNode(n);
    }

    @Override
    public boolean containsNode(T n) {
        return this.original.containsNode(n) || this.additionalNodes.containsNode(n);
    }

    @Override
    public int getNumber(T N) {
        if (this.original.containsNode(N)) {
            return this.original.getNumber(N);
        }
        return this.additionalNodes.getNumber(N) + this.original.getMaxNumber() + 1;
    }

    @Override
    public T getNode(int number) {
        if (number <= this.original.getMaxNumber()) {
            return this.original.getNode(number);
        }
        return this.additionalNodes.getNode(number - this.original.getMaxNumber() - 1);
    }

    @Override
    public int getMaxNumber() {
        if (this.additionalNodes.iterator().hasNext()) {
            return this.original.getMaxNumber() + 1 + this.additionalNodes.getMaxNumber();
        }
        return this.original.getMaxNumber();
    }

    @Override
    public Iterator<T> iterateNodes(IntSet s) {
        final MutableIntSet os = IntSetUtil.make();
        final MutableIntSet es = IntSetUtil.make();
        s.foreach(new IntSetAction(){

            @Override
            public void act(int x) {
                if (x <= ExtensionGraph.this.original.getMaxNumber()) {
                    os.add(x);
                } else {
                    es.add(x - ExtensionGraph.this.original.getMaxNumber() - 1);
                }
            }
        });
        return new CompoundIterator(this.original.iterateNodes(os), this.additionalNodes.iterateNodes(es));
    }

    @Override
    public Iterator<T> getPredNodes(T n) {
        return this.edgeManager.getPredNodes(n);
    }

    @Override
    public int getPredNodeCount(T n) {
        return this.edgeManager.getPredNodeCount(n);
    }

    @Override
    public IntSet getPredNodeNumbers(T node) {
        return this.edgeManager.getPredNodeNumbers(node);
    }

    @Override
    public Iterator<T> getSuccNodes(T n) {
        return this.edgeManager.getSuccNodes(n);
    }

    @Override
    public int getSuccNodeCount(T N) {
        return this.edgeManager.getSuccNodeCount(N);
    }

    @Override
    public IntSet getSuccNodeNumbers(T node) {
        return this.edgeManager.getSuccNodeNumbers(node);
    }

    @Override
    public void addEdge(T src, T dst) {
        assert (!this.original.hasEdge(src, dst));
        this.edgeManager.addEdge(src, dst);
    }

    @Override
    public void removeEdge(T src, T dst) throws UnsupportedOperationException {
        assert (!this.original.hasEdge(src, dst));
        this.edgeManager.removeEdge(src, dst);
    }

    @Override
    public void removeAllIncidentEdges(T node) throws UnsupportedOperationException {
        assert (!this.original.containsNode(node));
        this.edgeManager.removeAllIncidentEdges(node);
    }

    @Override
    public void removeIncomingEdges(T node) throws UnsupportedOperationException {
        assert (!this.original.containsNode(node));
        this.edgeManager.removeIncomingEdges(node);
    }

    @Override
    public void removeOutgoingEdges(T node) throws UnsupportedOperationException {
        assert (!this.original.containsNode(node));
        this.edgeManager.removeOutgoingEdges(node);
    }

    @Override
    public boolean hasEdge(T src, T dst) {
        return this.edgeManager.hasEdge(src, dst);
    }

    @Override
    public void removeNodeAndEdges(T n) throws UnsupportedOperationException {
        assert (!this.original.containsNode(n));
        this.edgeManager.removeAllIncidentEdges(n);
        this.additionalNodes.removeNode(n);
    }
}

