/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.TaskController;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorTaskController<R>
extends TaskController<R> {
    private Executor _executor;
    private Thunk<? extends R> _task;
    private volatile Thread _t;

    public ExecutorTaskController(Executor executor, Thunk<? extends R> task) {
        this._executor = executor;
        this._task = task;
        this._t = null;
    }

    @Override
    protected void doStart() {
        this._executor.execute(new Runnable(){

            public void run() {
                ExecutorTaskController.this._t = Thread.currentThread();
                ExecutorTaskController.this.started();
                try {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    ExecutorTaskController.this.finishedCleanly(ExecutorTaskController.this._task.value());
                }
                catch (InterruptedException e) {
                    ExecutorTaskController.this.stopped();
                }
                catch (WrappedException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        ExecutorTaskController.this.stopped();
                    } else {
                        ExecutorTaskController.this.finishedWithTaskException(e);
                    }
                }
                catch (RuntimeException e) {
                    ExecutorTaskController.this.finishedWithTaskException(e);
                }
            }
        });
    }

    @Override
    protected void doStop() {
        this._t.interrupt();
    }

    @Override
    protected void discard() {
        this._executor = null;
        this._task = null;
        this._t = null;
    }
}

