/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SkipLastIterator;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipLastIterable<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
Composite,
Serializable {
    private final Iterable<? extends T> _iterable;

    public SkipLastIterable(Iterable<? extends T> iterable) {
        this._iterable = iterable;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._iterable) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._iterable) + 1;
    }

    @Override
    public SkipLastIterator<T> iterator() {
        return new SkipLastIterator<T>(this._iterable.iterator());
    }

    @Override
    public boolean isEmpty() {
        return IterUtil.sizeOf(this._iterable, 2) < 2;
    }

    @Override
    public int size() {
        int nestedSize = IterUtil.sizeOf(this._iterable);
        if (nestedSize == 0) {
            return 0;
        }
        if (nestedSize == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return nestedSize - 1;
    }

    @Override
    public int size(int bound) {
        if (bound == Integer.MAX_VALUE) {
            return this.size();
        }
        int nestedSize = IterUtil.sizeOf(this._iterable, bound + 1);
        return nestedSize == 0 ? 0 : nestedSize - 1;
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._iterable);
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._iterable);
    }

    @Override
    public boolean isStatic() {
        return IterUtil.isStatic(this._iterable);
    }

    public static <T> SkipLastIterable<T> make(Iterable<? extends T> iterable) {
        return new SkipLastIterable<T>(iterable);
    }

    public static <T> SnapshotIterable<T> makeSnapshot(Iterable<? extends T> iterable) {
        return new SnapshotIterable<T>(new SkipLastIterable<T>(iterable));
    }
}

