/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.lambda;

import edu.rice.cs.plt.lambda.ResolvingThunk;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedThunk<R>
implements ResolvingThunk<R> {
    private final Thunk<? extends R> _thunk;
    private volatile Option<R> _val;

    public CachedThunk(Thunk<? extends R> value) {
        this._thunk = value;
        this._val = Option.none();
    }

    @Override
    public R value() {
        Option<R> v = this._val;
        if (v.isNone()) {
            return this.resolve();
        }
        return v.unwrap();
    }

    public synchronized void reset() {
        this._val = Option.none();
    }

    @Override
    public boolean isResolved() {
        return this._val.isSome();
    }

    public Option<R> cachedValue() {
        return this._val;
    }

    private synchronized R resolve() {
        if (this._val.isNone()) {
            R result = this._thunk.value();
            this._val = Option.some(result);
            return result;
        }
        return this._val.unwrap();
    }

    public static <R> CachedThunk<R> make(Thunk<? extends R> value) {
        return new CachedThunk<R>(value);
    }
}

