/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.reflect;

import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.ReflectUtil;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowingClassLoader
extends ClassLoader {
    private final Iterable<? extends String> _prefixes;
    private final boolean _blackList;
    private final boolean _filterBootClasses;

    public static ShadowingClassLoader blackList(ClassLoader parent, String ... excludePrefixes) {
        return new ShadowingClassLoader(parent, true, IterUtil.asIterable(excludePrefixes), false);
    }

    public static ShadowingClassLoader whiteList(ClassLoader parent, String ... includePrefixes) {
        return new ShadowingClassLoader(parent, false, IterUtil.asIterable(includePrefixes), false);
    }

    public ShadowingClassLoader(ClassLoader parent, boolean blackList, Iterable<? extends String> prefixes, boolean filterBootClasses) {
        super(parent);
        this._blackList = blackList;
        this._prefixes = prefixes;
        this._filterBootClasses = filterBootClasses;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if ((this._filterBootClasses || !this.isBootClass(name)) && this.matchesPrefixes(name) == this._blackList) {
            throw new ClassNotFoundException(name + " is being shadowed");
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        if ((this._filterBootClasses || !this.isBootResource(name)) && this.matchesPrefixes(name.replace('/', '.')) == this._blackList) {
            return null;
        }
        return super.getResource(name);
    }

    private boolean isBootClass(String name) {
        try {
            ReflectUtil.BOOT_CLASS_LOADER.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isBootResource(String name) {
        return ReflectUtil.BOOT_CLASS_LOADER.getResource(name) != null;
    }

    private boolean matchesPrefixes(String name) {
        for (String string : this._prefixes) {
            if (!name.startsWith(string) || !name.equals(string) && !name.startsWith(string + ".") && !name.startsWith(string + "$")) continue;
            return true;
        }
        return false;
    }
}

