/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import xtc.tree.Annotation;
import xtc.tree.GNode;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.tree.Token;
import xtc.util.Pair;
import xtc.util.Utilities;

public abstract class Node
implements Iterable<Object>,
Locatable {
    Map<String, Object> properties;
    Location location;

    public Node() {
    }

    public Node(Location location) {
        this.location = location;
    }

    public boolean isToken() {
        return false;
    }

    public Token toToken() {
        throw new ClassCastException("Not a token");
    }

    public String getTokenText() {
        throw new ClassCastException("Not a token");
    }

    public boolean isAnnotation() {
        return false;
    }

    public Annotation toAnnotation() {
        throw new ClassCastException("Not an annotation");
    }

    public boolean isGeneric() {
        return false;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean hasName(String name) {
        return this.getClass().getName().equals(name);
    }

    public Object setProperty(String name, Object value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(name, value);
    }

    public boolean hasProperty(String name) {
        if (null == this.properties) {
            return false;
        }
        return this.properties.containsKey(name);
    }

    public Object getProperty(String name) {
        if (null == this.properties) {
            return null;
        }
        return this.properties.get(name);
    }

    public boolean getBooleanProperty(String name) {
        if (null == this.properties) {
            return false;
        }
        Object o = this.properties.get(name);
        if (null == o) {
            return false;
        }
        return (Boolean)o;
    }

    public String getStringProperty(String name) {
        if (null == this.properties) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public Object removeProperty(String name) {
        if (null == this.properties) {
            return null;
        }
        return this.properties.remove(name);
    }

    public Set<String> properties() {
        if (null == this.properties) {
            return Collections.emptySet();
        }
        return this.properties.keySet();
    }

    @Override
    public boolean hasLocation() {
        return null != this.location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public void setLocation(Locatable locatable) {
        if (locatable.hasLocation()) {
            this.location = locatable.getLocation();
        }
    }

    public boolean hasTraversal() {
        return false;
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public Iterator<Object> iterator() {
        final int size = this.size();
        return new Iterator<Object>(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < size;
            }

            @Override
            public Object next() {
                if (this.cursor < size) {
                    return Node.this.get(this.cursor++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Down with Iterator.remove()");
            }
        };
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Object get(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.get(index);
    }

    public String getString(int index) {
        Object o = this.get(index);
        if (null == o) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return ((Node)o).getTokenText();
    }

    public Node getNode(int index) {
        return (Node)this.get(index);
    }

    public GNode getGeneric(int index) {
        Object o = this.get(index);
        return null == o ? null : (GNode)((Node)o).strip();
    }

    public <T> Pair<T> getList(int index) {
        return (Pair)this.get(index);
    }

    public Object set(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object o) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object child = this.get(i);
            if (!(null == o ? null == child : o.equals(child))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Object child = this.get(i);
            if (!(null == o ? null == child : o.equals(child))) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Object o) {
        return -1 != this.indexOf(o);
    }

    public void addAllTo(Collection<Object> c) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            c.add(this.get(i));
        }
    }

    public boolean hasVariable() {
        return false;
    }

    public Node add(Object o) {
        throw new UnsupportedOperationException();
    }

    public Node addNode(Node node) {
        return this.add(node);
    }

    public Node add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public Node addAll(Pair<?> p) {
        while (Pair.empty() != p) {
            this.add(p.head());
            p = p.tail();
        }
        return this;
    }

    public Node addAll(int index, Pair<?> p) {
        while (Pair.empty() != p) {
            this.add(index++, p.head());
            p = p.tail();
        }
        return this;
    }

    public Node addAll(Collection<?> c) {
        for (Object o : c) {
            this.add(o);
        }
        return this;
    }

    public Node addAll(int index, Collection<?> c) {
        for (Object o : c) {
            this.add(index++, o);
        }
        return this;
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public Node strip() {
        return this;
    }

    public void write(Appendable out) throws IOException {
        if (!this.hasTraversal()) {
            out.append(super.toString());
        } else {
            out.append(this.getName());
            out.append('(');
            boolean first = true;
            for (Object o : this) {
                if (first) {
                    first = false;
                } else {
                    out.append(", ");
                }
                if (null == o) {
                    out.append("null");
                    continue;
                }
                if (o instanceof String) {
                    out.append('\"');
                    Utilities.escape((String)o, out, 8);
                    out.append('\"');
                    continue;
                }
                if (o instanceof Node) {
                    ((Node)o).write(out);
                    continue;
                }
                out.append(o.toString());
            }
            out.append(')');
        }
    }

    public String toString() {
        StringBuilder buf;
        block2: {
            buf = new StringBuilder();
            try {
                this.write(buf);
            }
            catch (IOException x) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return buf.toString();
    }

    public static final boolean isList(Object o) {
        if (!(o instanceof Pair)) {
            return false;
        }
        if (Pair.EMPTY == o) {
            return true;
        }
        return ((Pair)o).head() instanceof Node;
    }

    public static final Pair<Node> toList(Object o) {
        if (Node.isList(o)) {
            return (Pair)o;
        }
        throw new ClassCastException("Not a list of nodes " + o);
    }
}

