/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.driver;

import com.ibm.wala.util.collections.HashMapFactory;
import com.samsung.memoryanalysis.context.ContextProvider;
import com.samsung.memoryanalysis.options.MemoryAnalysisOptions;
import com.samsung.memoryanalysis.referencecounter.DummyUnreachabilityAnalysis;
import com.samsung.memoryanalysis.referencecounter.ReferenceCounter;
import com.samsung.memoryanalysis.referencecounter.UnreachabilityAwareDuplex;
import com.samsung.memoryanalysis.referencecounter.UnreachabilityTraceWriter;
import com.samsung.memoryanalysis.referencecounter.heap.JGraphHeap;
import com.samsung.memoryanalysis.staleness.Staleness;
import com.samsung.memoryanalysis.staleness.StalenessAnalysis;
import com.samsung.memoryanalysis.traceparser.ProgressMonitor;
import com.samsung.memoryanalysis.traceparser.TraceAnalysisRunner;
import com.samsung.memoryanalysis.traceparser.TracePrettyPrinter;
import com.samsung.memoryanalysis.util.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class CommandLineDriver {
    private static int lastPercent = -1;

    public static void printProgBar(int total, int prog) {
        int percent = (int)((float)prog / (float)total * 100.0f);
        if (percent <= lastPercent) {
            return;
        }
        lastPercent = percent;
        StringBuilder bar = new StringBuilder("[");
        for (int i = 0; i < 50; ++i) {
            if (i < percent / 2) {
                bar.append("=");
                continue;
            }
            if (i == percent / 2) {
                bar.append(">");
                continue;
            }
            bar.append(" ");
        }
        bar.append(String.format("]    %d%%   (%d/%d)    ", percent, prog, total));
        System.out.print("\r" + bar.toString());
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        InputStream traceStream;
        OptionParser parser = new OptionParser();
        parser.accepts("context", "Run only the context analysis");
        parser.accepts("ref", "Run the reference count analysis only");
        parser.accepts("staleness", "Run the staleness analysis");
        parser.accepts("ref-trace", "Output the enhanced trace format");
        parser.accepts("pretty-print", "Just parse and pretty print the trace");
        parser.accepts("no-progress", "Don't print progress bar");
        parser.accepts("access-paths", "Reads object ids on stdin and timestamp on stdin, prints access paths on stdout");
        parser.accepts("enhanced", "If doing staleness, will also generate the enhanced trace in cwd");
        parser.accepts("nodejs", "Model the module scope of nodejs");
        ArgumentAcceptingOptionSpec traceOpt = parser.accepts("trace", "Trace file to analyze").withRequiredArg().describedAs("trace file").ofType(String.class);
        ArgumentAcceptingOptionSpec dirOpt = parser.accepts("directory", "Directory containing the instrumented source code").withRequiredArg().describedAs("directory").ofType(String.class);
        final OptionSet options = parser.parse(args);
        File dir = null;
        if (options.has((OptionSpec)traceOpt)) {
            String file = (String)options.valueOf((OptionSpec)traceOpt);
            traceStream = new BufferedInputStream(new FileInputStream(file));
            dir = new File(file).getParentFile();
        } else {
            traceStream = System.in;
            if (options.has((OptionSpec)dirOpt)) {
                dir = new File((String)options.valueOf((OptionSpec)dirOpt));
            } else {
                System.out.println("In streaming mode you must provide a directory (with --directory)");
                System.exit(1);
            }
        }
        ProgressMonitor prog = new ProgressMonitor(){
            int total;

            @Override
            public void start(int total) {
                this.total = total;
            }

            @Override
            public void tick(int progress) {
                if (!options.has("no-progress")) {
                    CommandLineDriver.printProgBar(this.total, progress);
                }
            }
        };
        MemoryAnalysisOptions refOptions = new MemoryAnalysisOptions();
        if (options.has("nodejs")) {
            refOptions.setModuleScope();
        }
        if (options.has("ref")) {
            ReferenceCounter f = new ReferenceCounter(new JGraphHeap(), null, refOptions);
            new TraceAnalysisRunner(traceStream, prog, dir).runAnalysis(new ContextProvider(f, refOptions));
        } else if (options.has("context")) {
            new TraceAnalysisRunner(traceStream, prog, dir).runAnalysis(new ContextProvider(null, refOptions));
        } else if (options.has("staleness")) {
            if (options.has("enhanced")) {
                File pf = new File(dir, "enhanced-trace");
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(pf));
                UnreachabilityTraceWriter aw = new UnreachabilityTraceWriter(stream);
                UnreachabilityAwareDuplex<Staleness, Void> analysis = new UnreachabilityAwareDuplex<Staleness, Void>(new StalenessAnalysis(), aw);
                ReferenceCounter f = new ReferenceCounter(new JGraphHeap(), analysis, refOptions);
                Pair p = (Pair)new TraceAnalysisRunner(traceStream, prog, dir).runAnalysis(new ContextProvider(f, refOptions));
                ((Staleness)p.first).toJSON(System.out, false);
            } else {
                ReferenceCounter<Staleness> f = new ReferenceCounter<Staleness>(new JGraphHeap(), new StalenessAnalysis(), refOptions);
                Staleness staleness = new TraceAnalysisRunner(traceStream, prog, dir).runAnalysis(new ContextProvider<Staleness>(f, refOptions));
                staleness.toJSON(System.out, false);
            }
        } else if (options.has("ref-trace")) {
            BufferedOutputStream out = new BufferedOutputStream(System.out);
            ReferenceCounter<Void> f = new ReferenceCounter<Void>(new JGraphHeap(), new UnreachabilityTraceWriter(out), refOptions);
            new TraceAnalysisRunner(traceStream, prog, dir).runAnalysis(new ContextProvider<Void>(f, refOptions));
            out.close();
        } else if (options.has("pretty-print")) {
            new TraceAnalysisRunner(traceStream, prog, dir).runAnalysis(new TracePrettyPrinter());
        } else if (options.has("access-paths")) {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            HashMap watchList = HashMapFactory.make();
            while ((line = in.readLine()) != null) {
                String[] comp = line.split(",");
                assert (comp.length == 2);
                int objectId = Integer.parseInt(comp[0]);
                int printAtTime = Integer.parseInt(comp[1]);
                watchList.put(objectId, printAtTime);
            }
            refOptions.setAccessPathObjects(watchList);
            ReferenceCounter f = new ReferenceCounter(new JGraphHeap(), new DummyUnreachabilityAnalysis(), refOptions);
            new TraceAnalysisRunner(traceStream, prog, dir).runAnalysisJSON(new ContextProvider(f, refOptions));
        }
    }
}

