/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.jalangi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.tizen.web.jsa.JsaPlugin;
import org.tizen.web.jsa.jalangi.util.CommandExecutor;
import org.tizen.web.jsa.jalangi.util.EnvironmentMgr;
import org.tizen.web.jsa.jalangi.util.FileUtil;

public class JalangiCommandExecutor {
    static boolean isNotTV = false;

    public static File instrumentForMemoryLeak(boolean isBrowser) {
        String jalangiDir = EnvironmentMgr.getJalangiDir();
        String currentProjectPath = EnvironmentMgr.getProject().getLocation().toString();
        File instrOutputDir = null;
        instrOutputDir = EnvironmentMgr.isWindows ? new File(String.valueOf(EnvironmentMgr.getWorkspacePath()) + File.separator + EnvironmentMgr.INSTRUMENT_OUTPUT) : new File(EnvironmentMgr.INSTRUMENT_OUTPUT);
        if (instrOutputDir.exists()) {
            if (EnvironmentMgr.isWindows) {
                FileUtil.delFolder(instrOutputDir);
            } else {
                FileUtil.delFolder(String.valueOf(instrOutputDir.toString()) + File.separator + EnvironmentMgr.getProject().getName());
            }
        }
        instrOutputDir.mkdir();
        StringBuilder command = new StringBuilder();
        command.append("node drivers/memTraceDriver.js").append(" --justGenerate --verbose --outputDir ").append(instrOutputDir.getAbsolutePath()).append(" ").append(currentProjectPath);
        if (!isBrowser) {
            command.append(" --serverIP 127.0.0.2");
        }
        CommandExecutor.exec(command.toString(), new File(jalangiDir), new CommandExecutor.LineHandler(){

            @Override
            void realLine(String line) {
                JsaPlugin.printToConsole("FILE : " + line);
            }
        });
        return new File(instrOutputDir, EnvironmentMgr.getProject().getName());
    }

    public static void killNodeProcess() {
        CommandExecutor.execJalangiCommand(EnvironmentMgr.Commands.KILL_NODEJS);
    }

    public static void killSdbProcess() {
        JalangiCommandExecutor.checkTV();
        if (!EnvironmentMgr.isMac && isNotTV) {
            CommandExecutor.execJalangiCommand(EnvironmentMgr.Commands.KILL_SDB);
        }
    }

    private static void checkTV() {
        isNotTV = false;
        CommandExecutor.exec(String.valueOf(EnvironmentMgr.getSdbPath()) + " devices", null, new CommandExecutor.InputStreamHandler(){

            @Override
            public void handler(InputStream is) {
                block13: {
                    BufferedReader br = null;
                    try {
                        try {
                            br = new BufferedReader(new InputStreamReader(is));
                            String str = null;
                            while ((str = br.readLine()) != null) {
                                String ss;
                                if (str.split("\t").length < 3 || EnvironmentMgr.isIp(ss = str.split("\t")[0].trim())) continue;
                                isNotTV = true;
                                break;
                            }
                            br = null;
                        }
                        catch (Exception e) {
                            JsaPlugin.printErrorToConsole(e);
                            if (br == null) break block13;
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                JsaPlugin.printErrorToConsole(e2);
                            }
                        }
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                JsaPlugin.printErrorToConsole(e);
                            }
                        }
                    }
                }
            }
        });
    }
}

