/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRAssign;
import kr.ac.kaist.jsaf.nodes.IRExpr;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRExprStmt
extends IRAssign {
    private final IRExpr _right;
    private final boolean _ref;

    public IRExprStmt(IRSpanInfo in_info, IRId in_lhs, IRExpr in_right, boolean in_ref) {
        super(in_info, in_lhs);
        if (in_right == null) {
            throw new IllegalArgumentException("Parameter 'right' to the IRExprStmt constructor was null");
        }
        this._right = in_right;
        this._ref = in_ref;
    }

    public IRExprStmt(IRSpanInfo in_info, IRId in_lhs, IRExpr in_right) {
        this(in_info, in_lhs, in_right, false);
    }

    public final IRExpr getRight() {
        return this._right;
    }

    public final boolean isRef() {
        return this._ref;
    }

    @Override
    public <RetType> RetType accept(IRAbstractNodeVisitor<RetType> visitor) {
        return visitor.forIRExprStmt(this);
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRExprStmt(this);
    }

    @Override
    public void accept(IRAbstractNodeVisitor_void visitor) {
        visitor.forIRExprStmt(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRExprStmt(this);
    }

    public boolean equals(Object obj) {
        boolean casted_ref;
        IRExpr casted_right;
        IRId casted_lhs;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRExprStmt casted = (IRExprStmt)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        IRId temp_lhs = this.getLhs();
        if (temp_lhs != (casted_lhs = casted.getLhs()) && !temp_lhs.equals(casted_lhs)) {
            return false;
        }
        IRExpr temp_right = this.getRight();
        if (temp_right != (casted_right = casted.getRight()) && !temp_right.equals(casted_right)) {
            return false;
        }
        boolean temp_ref = this.isRef();
        return temp_ref == (casted_ref = casted.isRef());
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        IRId temp_lhs = this.getLhs();
        code ^= temp_lhs.hashCode();
        IRExpr temp_right = this.getRight();
        code ^= temp_right.hashCode();
        boolean temp_ref = this.isRef();
        return code ^= temp_ref ? 1231 : 1237;
    }

    protected IRExprStmt() {
        this._right = null;
        this._ref = false;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRExprStmt", 4)) {
            boolean temp_ref;
            IRExpr temp_right;
            IRId temp_lhs;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("lhs", temp_lhs = this.getLhs())) {
                temp_lhs.walk(w);
                w.endNodeField("lhs", temp_lhs);
            }
            if (w.visitNodeField("right", temp_right = this.getRight())) {
                temp_right.walk(w);
                w.endNodeField("right", temp_right);
            }
            if (w.visitNodeField("ref", temp_ref = this.isRef())) {
                w.visitBoolean(temp_ref);
                w.endNodeField("ref", temp_ref);
            }
            w.endNode(this, "IRExprStmt", 4);
        }
    }
}

