/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import kr.ac.kaist.jsaf.nodes.ASTSpanInfo;
import kr.ac.kaist.jsaf.nodes.AmbClsDecl;
import kr.ac.kaist.jsaf.nodes.AmbClsElt;
import kr.ac.kaist.jsaf.nodes.AmbCnstDecl;
import kr.ac.kaist.jsaf.nodes.AmbEnumDecl;
import kr.ac.kaist.jsaf.nodes.AmbEnumMem;
import kr.ac.kaist.jsaf.nodes.AmbExtModDecl;
import kr.ac.kaist.jsaf.nodes.AmbExtModElt;
import kr.ac.kaist.jsaf.nodes.AmbFunDecl;
import kr.ac.kaist.jsaf.nodes.AmbIndDecl;
import kr.ac.kaist.jsaf.nodes.AmbMemDecl;
import kr.ac.kaist.jsaf.nodes.AmbModDecl;
import kr.ac.kaist.jsaf.nodes.AmbModElt;
import kr.ac.kaist.jsaf.nodes.AmbVarDecl;
import kr.ac.kaist.jsaf.nodes.AnonymousFnName;
import kr.ac.kaist.jsaf.nodes.AnyT;
import kr.ac.kaist.jsaf.nodes.ArrayExpr;
import kr.ac.kaist.jsaf.nodes.ArrayNumberExpr;
import kr.ac.kaist.jsaf.nodes.ArrayType;
import kr.ac.kaist.jsaf.nodes.AssignOpApp;
import kr.ac.kaist.jsaf.nodes.Block;
import kr.ac.kaist.jsaf.nodes.Bool;
import kr.ac.kaist.jsaf.nodes.BoolT;
import kr.ac.kaist.jsaf.nodes.Bracket;
import kr.ac.kaist.jsaf.nodes.Break;
import kr.ac.kaist.jsaf.nodes.CallSig;
import kr.ac.kaist.jsaf.nodes.Case;
import kr.ac.kaist.jsaf.nodes.Catch;
import kr.ac.kaist.jsaf.nodes.Comment;
import kr.ac.kaist.jsaf.nodes.Cond;
import kr.ac.kaist.jsaf.nodes.ConstructSig;
import kr.ac.kaist.jsaf.nodes.ConstructorType;
import kr.ac.kaist.jsaf.nodes.Continue;
import kr.ac.kaist.jsaf.nodes.Debugger;
import kr.ac.kaist.jsaf.nodes.DoWhile;
import kr.ac.kaist.jsaf.nodes.DoWhileSS;
import kr.ac.kaist.jsaf.nodes.Dot;
import kr.ac.kaist.jsaf.nodes.DoubleLiteral;
import kr.ac.kaist.jsaf.nodes.EmptyStmt;
import kr.ac.kaist.jsaf.nodes.Expr;
import kr.ac.kaist.jsaf.nodes.ExprList;
import kr.ac.kaist.jsaf.nodes.ExprStmt;
import kr.ac.kaist.jsaf.nodes.ExprType;
import kr.ac.kaist.jsaf.nodes.ExtImpDecl;
import kr.ac.kaist.jsaf.nodes.Field;
import kr.ac.kaist.jsaf.nodes.For;
import kr.ac.kaist.jsaf.nodes.ForIn;
import kr.ac.kaist.jsaf.nodes.ForVar;
import kr.ac.kaist.jsaf.nodes.ForVarIn;
import kr.ac.kaist.jsaf.nodes.FunApp;
import kr.ac.kaist.jsaf.nodes.FunDecl;
import kr.ac.kaist.jsaf.nodes.FunExpr;
import kr.ac.kaist.jsaf.nodes.FunctionType;
import kr.ac.kaist.jsaf.nodes.Functional;
import kr.ac.kaist.jsaf.nodes.FunctionalSS;
import kr.ac.kaist.jsaf.nodes.GetProp;
import kr.ac.kaist.jsaf.nodes.Id;
import kr.ac.kaist.jsaf.nodes.If;
import kr.ac.kaist.jsaf.nodes.IfSS;
import kr.ac.kaist.jsaf.nodes.IndexSig;
import kr.ac.kaist.jsaf.nodes.InfixOpApp;
import kr.ac.kaist.jsaf.nodes.IntLiteral;
import kr.ac.kaist.jsaf.nodes.IntfDecl;
import kr.ac.kaist.jsaf.nodes.LHS;
import kr.ac.kaist.jsaf.nodes.Label;
import kr.ac.kaist.jsaf.nodes.LabelStmt;
import kr.ac.kaist.jsaf.nodes.Member;
import kr.ac.kaist.jsaf.nodes.MethodSig;
import kr.ac.kaist.jsaf.nodes.ModDecl;
import kr.ac.kaist.jsaf.nodes.ModExpAlias;
import kr.ac.kaist.jsaf.nodes.ModExpAssignment;
import kr.ac.kaist.jsaf.nodes.ModExpFunDecl;
import kr.ac.kaist.jsaf.nodes.ModExpGetter;
import kr.ac.kaist.jsaf.nodes.ModExpName;
import kr.ac.kaist.jsaf.nodes.ModExpSetter;
import kr.ac.kaist.jsaf.nodes.ModExpSpecifier;
import kr.ac.kaist.jsaf.nodes.ModExpSpecifiers;
import kr.ac.kaist.jsaf.nodes.ModExpStar;
import kr.ac.kaist.jsaf.nodes.ModExpStarFromPath;
import kr.ac.kaist.jsaf.nodes.ModExpVarStmt;
import kr.ac.kaist.jsaf.nodes.ModImpAlias;
import kr.ac.kaist.jsaf.nodes.ModImpAliasClause;
import kr.ac.kaist.jsaf.nodes.ModImpDecl;
import kr.ac.kaist.jsaf.nodes.ModImpName;
import kr.ac.kaist.jsaf.nodes.ModImpSpecifier;
import kr.ac.kaist.jsaf.nodes.ModImpSpecifierSet;
import kr.ac.kaist.jsaf.nodes.ModImport;
import kr.ac.kaist.jsaf.nodes.Modifier;
import kr.ac.kaist.jsaf.nodes.New;
import kr.ac.kaist.jsaf.nodes.NoOp;
import kr.ac.kaist.jsaf.nodes.Node;
import kr.ac.kaist.jsaf.nodes.Null;
import kr.ac.kaist.jsaf.nodes.NumberLiteral;
import kr.ac.kaist.jsaf.nodes.NumberT;
import kr.ac.kaist.jsaf.nodes.ObjectExpr;
import kr.ac.kaist.jsaf.nodes.ObjectType;
import kr.ac.kaist.jsaf.nodes.Op;
import kr.ac.kaist.jsaf.nodes.Param;
import kr.ac.kaist.jsaf.nodes.Parenthesized;
import kr.ac.kaist.jsaf.nodes.Path;
import kr.ac.kaist.jsaf.nodes.PrefixOpApp;
import kr.ac.kaist.jsaf.nodes.PrivateMod;
import kr.ac.kaist.jsaf.nodes.Program;
import kr.ac.kaist.jsaf.nodes.PropId;
import kr.ac.kaist.jsaf.nodes.PropNum;
import kr.ac.kaist.jsaf.nodes.PropStr;
import kr.ac.kaist.jsaf.nodes.Property;
import kr.ac.kaist.jsaf.nodes.PropertySig;
import kr.ac.kaist.jsaf.nodes.PublicMod;
import kr.ac.kaist.jsaf.nodes.RegularExpression;
import kr.ac.kaist.jsaf.nodes.Return;
import kr.ac.kaist.jsaf.nodes.SetProp;
import kr.ac.kaist.jsaf.nodes.SourceElement;
import kr.ac.kaist.jsaf.nodes.SourceElements;
import kr.ac.kaist.jsaf.nodes.StaticMod;
import kr.ac.kaist.jsaf.nodes.Stmt;
import kr.ac.kaist.jsaf.nodes.StmtUnit;
import kr.ac.kaist.jsaf.nodes.StringLiteral;
import kr.ac.kaist.jsaf.nodes.StringT;
import kr.ac.kaist.jsaf.nodes.Switch;
import kr.ac.kaist.jsaf.nodes.SwitchSS;
import kr.ac.kaist.jsaf.nodes.TSImpDecl;
import kr.ac.kaist.jsaf.nodes.This;
import kr.ac.kaist.jsaf.nodes.Throw;
import kr.ac.kaist.jsaf.nodes.TopLevel;
import kr.ac.kaist.jsaf.nodes.Try;
import kr.ac.kaist.jsaf.nodes.TrySS;
import kr.ac.kaist.jsaf.nodes.Type;
import kr.ac.kaist.jsaf.nodes.TypeMember;
import kr.ac.kaist.jsaf.nodes.TypeName;
import kr.ac.kaist.jsaf.nodes.TypeParam;
import kr.ac.kaist.jsaf.nodes.TypeQuery;
import kr.ac.kaist.jsaf.nodes.TypeRef;
import kr.ac.kaist.jsaf.nodes.UnaryAssignOpApp;
import kr.ac.kaist.jsaf.nodes.VarDecl;
import kr.ac.kaist.jsaf.nodes.VarRef;
import kr.ac.kaist.jsaf.nodes.VarStmt;
import kr.ac.kaist.jsaf.nodes.VoidT;
import kr.ac.kaist.jsaf.nodes.While;
import kr.ac.kaist.jsaf.nodes.With;
import kr.ac.kaist.jsaf.nodes_util.Span;

public class NodeReader {
    protected BufferedReader in;
    protected char currentChar = (char)32;

    public static Node read(String s) throws IOException {
        return NodeReader.read(new StringReader(s));
    }

    public static Node read(Reader r) throws IOException {
        return new NodeReader(new BufferedReader(r)).readNode();
    }

    protected NodeReader(BufferedReader r) {
        this.in = r;
    }

    public Node readNode() throws IOException {
        String name = this.readWord();
        if (name.equals("_")) {
            return null;
        }
        if (name.equals("Program:")) {
            return this.readProgramBody();
        }
        if (name.equals("ModDecl:")) {
            return this.readModDeclBody();
        }
        if (name.equals("ModExpVarStmt:")) {
            return this.readModExpVarStmtBody();
        }
        if (name.equals("ModExpFunDecl:")) {
            return this.readModExpFunDeclBody();
        }
        if (name.equals("ModExpGetter:")) {
            return this.readModExpGetterBody();
        }
        if (name.equals("ModExpSetter:")) {
            return this.readModExpSetterBody();
        }
        if (name.equals("ModExpSpecifiers:")) {
            return this.readModExpSpecifiersBody();
        }
        if (name.equals("ModExpAssignment:")) {
            return this.readModExpAssignmentBody();
        }
        if (name.equals("ModImpDecl:")) {
            return this.readModImpDeclBody();
        }
        if (name.equals("ExtImpDecl:")) {
            return this.readExtImpDeclBody();
        }
        if (name.equals("TSImpDecl:")) {
            return this.readTSImpDeclBody();
        }
        if (name.equals("IntfDecl:")) {
            return this.readIntfDeclBody();
        }
        if (name.equals("AmbVarDecl:")) {
            return this.readAmbVarDeclBody();
        }
        if (name.equals("AmbFunDecl:")) {
            return this.readAmbFunDeclBody();
        }
        if (name.equals("AmbClsDecl:")) {
            return this.readAmbClsDeclBody();
        }
        if (name.equals("AmbEnumDecl:")) {
            return this.readAmbEnumDeclBody();
        }
        if (name.equals("AmbModDecl:")) {
            return this.readAmbModDeclBody();
        }
        if (name.equals("AmbExtModDecl:")) {
            return this.readAmbExtModDeclBody();
        }
        if (name.equals("NoOp:")) {
            return this.readNoOpBody();
        }
        if (name.equals("StmtUnit:")) {
            return this.readStmtUnitBody();
        }
        if (name.equals("FunDecl:")) {
            return this.readFunDeclBody();
        }
        if (name.equals("Block:")) {
            return this.readBlockBody();
        }
        if (name.equals("VarStmt:")) {
            return this.readVarStmtBody();
        }
        if (name.equals("EmptyStmt:")) {
            return this.readEmptyStmtBody();
        }
        if (name.equals("ExprStmt:")) {
            return this.readExprStmtBody();
        }
        if (name.equals("If:")) {
            return this.readIfBody();
        }
        if (name.equals("IfSS:")) {
            return this.readIfSSBody();
        }
        if (name.equals("DoWhile:")) {
            return this.readDoWhileBody();
        }
        if (name.equals("DoWhileSS:")) {
            return this.readDoWhileSSBody();
        }
        if (name.equals("While:")) {
            return this.readWhileBody();
        }
        if (name.equals("For:")) {
            return this.readForBody();
        }
        if (name.equals("ForIn:")) {
            return this.readForInBody();
        }
        if (name.equals("ForVar:")) {
            return this.readForVarBody();
        }
        if (name.equals("ForVarIn:")) {
            return this.readForVarInBody();
        }
        if (name.equals("Continue:")) {
            return this.readContinueBody();
        }
        if (name.equals("Break:")) {
            return this.readBreakBody();
        }
        if (name.equals("Return:")) {
            return this.readReturnBody();
        }
        if (name.equals("With:")) {
            return this.readWithBody();
        }
        if (name.equals("Switch:")) {
            return this.readSwitchBody();
        }
        if (name.equals("SwitchSS:")) {
            return this.readSwitchSSBody();
        }
        if (name.equals("LabelStmt:")) {
            return this.readLabelStmtBody();
        }
        if (name.equals("Throw:")) {
            return this.readThrowBody();
        }
        if (name.equals("Try:")) {
            return this.readTryBody();
        }
        if (name.equals("TrySS:")) {
            return this.readTrySSBody();
        }
        if (name.equals("Debugger:")) {
            return this.readDebuggerBody();
        }
        if (name.equals("SourceElements:")) {
            return this.readSourceElementsBody();
        }
        if (name.equals("VarDecl:")) {
            return this.readVarDeclBody();
        }
        if (name.equals("Case:")) {
            return this.readCaseBody();
        }
        if (name.equals("Catch:")) {
            return this.readCatchBody();
        }
        if (name.equals("ModImpSpecifierSet:")) {
            return this.readModImpSpecifierSetBody();
        }
        if (name.equals("ModImpAliasClause:")) {
            return this.readModImpAliasClauseBody();
        }
        if (name.equals("AmbCnstDecl:")) {
            return this.readAmbCnstDeclBody();
        }
        if (name.equals("AmbMemDecl:")) {
            return this.readAmbMemDeclBody();
        }
        if (name.equals("AmbIndDecl:")) {
            return this.readAmbIndDeclBody();
        }
        if (name.equals("AmbEnumMem:")) {
            return this.readAmbEnumMemBody();
        }
        if (name.equals("AmbModElt:")) {
            return this.readAmbModEltBody();
        }
        if (name.equals("AmbExtModElt:")) {
            return this.readAmbExtModEltBody();
        }
        if (name.equals("ExprList:")) {
            return this.readExprListBody();
        }
        if (name.equals("Cond:")) {
            return this.readCondBody();
        }
        if (name.equals("InfixOpApp:")) {
            return this.readInfixOpAppBody();
        }
        if (name.equals("PrefixOpApp:")) {
            return this.readPrefixOpAppBody();
        }
        if (name.equals("UnaryAssignOpApp:")) {
            return this.readUnaryAssignOpAppBody();
        }
        if (name.equals("AssignOpApp:")) {
            return this.readAssignOpAppBody();
        }
        if (name.equals("This:")) {
            return this.readThisBody();
        }
        if (name.equals("Null:")) {
            return this.readNullBody();
        }
        if (name.equals("Bool:")) {
            return this.readBoolBody();
        }
        if (name.equals("DoubleLiteral:")) {
            return this.readDoubleLiteralBody();
        }
        if (name.equals("IntLiteral:")) {
            return this.readIntLiteralBody();
        }
        if (name.equals("StringLiteral:")) {
            return this.readStringLiteralBody();
        }
        if (name.equals("RegularExpression:")) {
            return this.readRegularExpressionBody();
        }
        if (name.equals("VarRef:")) {
            return this.readVarRefBody();
        }
        if (name.equals("ArrayExpr:")) {
            return this.readArrayExprBody();
        }
        if (name.equals("ArrayNumberExpr:")) {
            return this.readArrayNumberExprBody();
        }
        if (name.equals("ObjectExpr:")) {
            return this.readObjectExprBody();
        }
        if (name.equals("Parenthesized:")) {
            return this.readParenthesizedBody();
        }
        if (name.equals("FunExpr:")) {
            return this.readFunExprBody();
        }
        if (name.equals("Bracket:")) {
            return this.readBracketBody();
        }
        if (name.equals("Dot:")) {
            return this.readDotBody();
        }
        if (name.equals("New:")) {
            return this.readNewBody();
        }
        if (name.equals("FunApp:")) {
            return this.readFunAppBody();
        }
        if (name.equals("PropId:")) {
            return this.readPropIdBody();
        }
        if (name.equals("PropStr:")) {
            return this.readPropStrBody();
        }
        if (name.equals("PropNum:")) {
            return this.readPropNumBody();
        }
        if (name.equals("Field:")) {
            return this.readFieldBody();
        }
        if (name.equals("GetProp:")) {
            return this.readGetPropBody();
        }
        if (name.equals("SetProp:")) {
            return this.readSetPropBody();
        }
        if (name.equals("Id:")) {
            return this.readIdBody();
        }
        if (name.equals("Op:")) {
            return this.readOpBody();
        }
        if (name.equals("TypeName:")) {
            return this.readTypeNameBody();
        }
        if (name.equals("AnonymousFnName:")) {
            return this.readAnonymousFnNameBody();
        }
        if (name.equals("Path:")) {
            return this.readPathBody();
        }
        if (name.equals("ModExpStarFromPath:")) {
            return this.readModExpStarFromPathBody();
        }
        if (name.equals("ModExpStar:")) {
            return this.readModExpStarBody();
        }
        if (name.equals("ModExpAlias:")) {
            return this.readModExpAliasBody();
        }
        if (name.equals("ModExpName:")) {
            return this.readModExpNameBody();
        }
        if (name.equals("ModImpAlias:")) {
            return this.readModImpAliasBody();
        }
        if (name.equals("ModImpName:")) {
            return this.readModImpNameBody();
        }
        if (name.equals("Label:")) {
            return this.readLabelBody();
        }
        if (name.equals("Comment:")) {
            return this.readCommentBody();
        }
        if (name.equals("Param:")) {
            return this.readParamBody();
        }
        if (name.equals("AnyT:")) {
            return this.readAnyTBody();
        }
        if (name.equals("NumberT:")) {
            return this.readNumberTBody();
        }
        if (name.equals("BoolT:")) {
            return this.readBoolTBody();
        }
        if (name.equals("StringT:")) {
            return this.readStringTBody();
        }
        if (name.equals("VoidT:")) {
            return this.readVoidTBody();
        }
        if (name.equals("TypeRef:")) {
            return this.readTypeRefBody();
        }
        if (name.equals("TypeQuery:")) {
            return this.readTypeQueryBody();
        }
        if (name.equals("ObjectType:")) {
            return this.readObjectTypeBody();
        }
        if (name.equals("ArrayType:")) {
            return this.readArrayTypeBody();
        }
        if (name.equals("FunctionType:")) {
            return this.readFunctionTypeBody();
        }
        if (name.equals("ConstructorType:")) {
            return this.readConstructorTypeBody();
        }
        if (name.equals("ExprType:")) {
            return this.readExprTypeBody();
        }
        if (name.equals("PropertySig:")) {
            return this.readPropertySigBody();
        }
        if (name.equals("CallSig:")) {
            return this.readCallSigBody();
        }
        if (name.equals("ConstructSig:")) {
            return this.readConstructSigBody();
        }
        if (name.equals("IndexSig:")) {
            return this.readIndexSigBody();
        }
        if (name.equals("MethodSig:")) {
            return this.readMethodSigBody();
        }
        if (name.equals("TypeParam:")) {
            return this.readTypeParamBody();
        }
        if (name.equals("TopLevel:")) {
            return this.readTopLevelBody();
        }
        if (name.equals("Functional:")) {
            return this.readFunctionalBody();
        }
        if (name.equals("FunctionalSS:")) {
            return this.readFunctionalSSBody();
        }
        if (name.equals("ASTSpanInfo:")) {
            return this.readASTSpanInfoBody();
        }
        if (name.equals("PublicMod:")) {
            return this.readPublicModBody();
        }
        if (name.equals("PrivateMod:")) {
            return this.readPrivateModBody();
        }
        if (name.equals("StaticMod:")) {
            return this.readStaticModBody();
        }
        throw this.error();
    }

    private Program readProgramBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("body = ");
        TopLevel read_body = (TopLevel)this.readNode();
        return new Program(read_info, read_body);
    }

    private ModDecl readModDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        this.readFieldDelim("body = ");
        TopLevel read_body = (TopLevel)this.readNode();
        return new ModDecl(read_info, read_name, read_body);
    }

    private ModExpVarStmt readModExpVarStmtBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("vds = ");
        List<VarDecl> read_vds = this.readListOfVarDecl();
        return new ModExpVarStmt(read_info, read_vds);
    }

    private ModExpFunDecl readModExpFunDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("fd = ");
        FunDecl read_fd = (FunDecl)this.readNode();
        return new ModExpFunDecl(read_info, read_fd);
    }

    private ModExpGetter readModExpGetterBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("fd = ");
        GetProp read_fd = (GetProp)this.readNode();
        return new ModExpGetter(read_info, read_fd);
    }

    private ModExpSetter readModExpSetterBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("fd = ");
        SetProp read_fd = (SetProp)this.readNode();
        return new ModExpSetter(read_info, read_fd);
    }

    private ModExpSpecifiers readModExpSpecifiersBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("names = ");
        List<ModExpSpecifier> read_names = this.readListOfModExpSpecifier();
        return new ModExpSpecifiers(read_info, read_names);
    }

    private ModExpAssignment readModExpAssignmentBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        return new ModExpAssignment(read_info, read_id);
    }

    private ModImpDecl readModImpDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("imports = ");
        List<ModImport> read_imports = this.readListOfModImport();
        return new ModImpDecl(read_info, read_imports);
    }

    private ExtImpDecl readExtImpDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("module = ");
        String read_module = this.readString();
        return new ExtImpDecl(read_info, read_id, read_module);
    }

    private TSImpDecl readTSImpDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("path = ");
        Path read_path = (Path)this.readNode();
        return new TSImpDecl(read_info, read_id, read_path);
    }

    private IntfDecl readIntfDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("tps = ");
        List<TypeParam> read_tps = this.readListOfTypeParam();
        this.readFieldDelim("ext = ");
        List<TypeRef> read_ext = this.readListOfTypeRef();
        this.readFieldDelim("typ = ");
        ObjectType read_typ = (ObjectType)this.readNode();
        return new IntfDecl(read_info, read_id, read_tps, read_ext, read_typ);
    }

    private AmbVarDecl readAmbVarDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("ty = ");
        Option<Type> read_ty = this.readOptionOfType();
        return new AmbVarDecl(read_info, read_id, read_ty);
    }

    private AmbFunDecl readAmbFunDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("sig = ");
        CallSig read_sig = (CallSig)this.readNode();
        return new AmbFunDecl(read_info, read_id, read_sig);
    }

    private AmbClsDecl readAmbClsDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("tps = ");
        List<TypeParam> read_tps = this.readListOfTypeParam();
        this.readFieldDelim("ext = ");
        Option<TypeRef> read_ext = this.readOptionOfTypeRef();
        this.readFieldDelim("imp = ");
        List<TypeRef> read_imp = this.readListOfTypeRef();
        this.readFieldDelim("elts = ");
        List<AmbClsElt> read_elts = this.readListOfAmbClsElt();
        return new AmbClsDecl(read_info, read_id, read_tps, read_ext, read_imp, read_elts);
    }

    private AmbEnumDecl readAmbEnumDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("mem = ");
        List<AmbEnumMem> read_mem = this.readListOfAmbEnumMem();
        return new AmbEnumDecl(read_info, read_id, read_mem);
    }

    private AmbModDecl readAmbModDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("path = ");
        Path read_path = (Path)this.readNode();
        this.readFieldDelim("mem = ");
        List<AmbModElt> read_mem = this.readListOfAmbModElt();
        return new AmbModDecl(read_info, read_path, read_mem);
    }

    private AmbExtModDecl readAmbExtModDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("mem = ");
        List<AmbExtModElt> read_mem = this.readListOfAmbExtModElt();
        return new AmbExtModDecl(read_info, read_name, read_mem);
    }

    private NoOp readNoOpBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("desc = ");
        String read_desc = this.readString();
        return new NoOp(read_info, read_desc);
    }

    private StmtUnit readStmtUnitBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("stmts = ");
        List<Stmt> read_stmts = this.readListOfStmt();
        return new StmtUnit(read_info, read_stmts);
    }

    private FunDecl readFunDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("ftn = ");
        Functional read_ftn = (Functional)this.readNode();
        this.readFieldDelim("strict = ");
        boolean read_strict = this.readBoolean();
        return new FunDecl(read_info, read_ftn, read_strict);
    }

    private Block readBlockBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("stmts = ");
        List<Stmt> read_stmts = this.readListOfStmt();
        this.readFieldDelim("internal = ");
        boolean read_internal = this.readBoolean();
        return new Block(read_info, read_stmts, read_internal);
    }

    private VarStmt readVarStmtBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("vds = ");
        List<VarDecl> read_vds = this.readListOfVarDecl();
        return new VarStmt(read_info, read_vds);
    }

    private EmptyStmt readEmptyStmtBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new EmptyStmt(read_info);
    }

    private ExprStmt readExprStmtBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("expr = ");
        Expr read_expr = (Expr)this.readNode();
        this.readFieldDelim("internal = ");
        boolean read_internal = this.readBoolean();
        return new ExprStmt(read_info, read_expr, read_internal);
    }

    private If readIfBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        this.readFieldDelim("trueBranch = ");
        Stmt read_trueBranch = (Stmt)this.readNode();
        this.readFieldDelim("falseBranch = ");
        Option<Stmt> read_falseBranch = this.readOptionOfStmt();
        return new If(read_info, read_cond, read_trueBranch, read_falseBranch);
    }

    private IfSS readIfSSBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        this.readFieldDelim("trueBranch = ");
        Stmt read_trueBranch = (Stmt)this.readNode();
        this.readFieldDelim("falseBranch = ");
        Option<Stmt> read_falseBranch = this.readOptionOfStmt();
        this.readFieldDelim("elseSpan = ");
        Span read_elseSpan = (Span)this.readUnknownObject();
        return new IfSS(read_info, read_cond, read_trueBranch, read_falseBranch, read_elseSpan);
    }

    private DoWhile readDoWhileBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("body = ");
        Stmt read_body = (Stmt)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        return new DoWhile(read_info, read_body, read_cond);
    }

    private DoWhileSS readDoWhileSSBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("body = ");
        Stmt read_body = (Stmt)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        this.readFieldDelim("whileSpan = ");
        Span read_whileSpan = (Span)this.readUnknownObject();
        return new DoWhileSS(read_info, read_body, read_cond, read_whileSpan);
    }

    private While readWhileBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        this.readFieldDelim("body = ");
        Stmt read_body = (Stmt)this.readNode();
        return new While(read_info, read_cond, read_body);
    }

    private For readForBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("init = ");
        Option<Expr> read_init = this.readOptionOfExpr();
        this.readFieldDelim("cond = ");
        Option<Expr> read_cond = this.readOptionOfExpr();
        this.readFieldDelim("action = ");
        Option<Expr> read_action = this.readOptionOfExpr();
        this.readFieldDelim("body = ");
        Stmt read_body = (Stmt)this.readNode();
        return new For(read_info, read_init, read_cond, read_action, read_body);
    }

    private ForIn readForInBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("lhs = ");
        LHS read_lhs = (LHS)this.readNode();
        this.readFieldDelim("expr = ");
        Expr read_expr = (Expr)this.readNode();
        this.readFieldDelim("body = ");
        Stmt read_body = (Stmt)this.readNode();
        return new ForIn(read_info, read_lhs, read_expr, read_body);
    }

    private ForVar readForVarBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("vars = ");
        List<VarDecl> read_vars = this.readListOfVarDecl();
        this.readFieldDelim("cond = ");
        Option<Expr> read_cond = this.readOptionOfExpr();
        this.readFieldDelim("action = ");
        Option<Expr> read_action = this.readOptionOfExpr();
        this.readFieldDelim("body = ");
        Stmt read_body = (Stmt)this.readNode();
        return new ForVar(read_info, read_vars, read_cond, read_action, read_body);
    }

    private ForVarIn readForVarInBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("var = ");
        VarDecl read_var = (VarDecl)this.readNode();
        this.readFieldDelim("expr = ");
        Expr read_expr = (Expr)this.readNode();
        this.readFieldDelim("body = ");
        Stmt read_body = (Stmt)this.readNode();
        return new ForVarIn(read_info, read_var, read_expr, read_body);
    }

    private Continue readContinueBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("target = ");
        Option<Label> read_target = this.readOptionOfLabel();
        return new Continue(read_info, read_target);
    }

    private Break readBreakBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("target = ");
        Option<Label> read_target = this.readOptionOfLabel();
        return new Break(read_info, read_target);
    }

    private Return readReturnBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("expr = ");
        Option<Expr> read_expr = this.readOptionOfExpr();
        return new Return(read_info, read_expr);
    }

    private With readWithBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("expr = ");
        Expr read_expr = (Expr)this.readNode();
        this.readFieldDelim("stmt = ");
        Stmt read_stmt = (Stmt)this.readNode();
        return new With(read_info, read_expr, read_stmt);
    }

    private Switch readSwitchBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        this.readFieldDelim("frontCases = ");
        List<Case> read_frontCases = this.readListOfCase();
        this.readFieldDelim("def = ");
        Option<List<Stmt>> read_def = this.readOptionOfListOfStmt();
        this.readFieldDelim("backCases = ");
        List<Case> read_backCases = this.readListOfCase();
        return new Switch(read_info, read_cond, read_frontCases, read_def, read_backCases);
    }

    private SwitchSS readSwitchSSBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        this.readFieldDelim("frontCases = ");
        List<Case> read_frontCases = this.readListOfCase();
        this.readFieldDelim("def = ");
        Option<List<Stmt>> read_def = this.readOptionOfListOfStmt();
        this.readFieldDelim("backCases = ");
        List<Case> read_backCases = this.readListOfCase();
        this.readFieldDelim("openSpan = ");
        Span read_openSpan = (Span)this.readUnknownObject();
        return new SwitchSS(read_info, read_cond, read_frontCases, read_def, read_backCases, read_openSpan);
    }

    private LabelStmt readLabelStmtBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("label = ");
        Label read_label = (Label)this.readNode();
        this.readFieldDelim("stmt = ");
        Stmt read_stmt = (Stmt)this.readNode();
        return new LabelStmt(read_info, read_label, read_stmt);
    }

    private Throw readThrowBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("expr = ");
        Expr read_expr = (Expr)this.readNode();
        return new Throw(read_info, read_expr);
    }

    private Try readTryBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("body = ");
        List<Stmt> read_body = this.readListOfStmt();
        this.readFieldDelim("catchBlock = ");
        Option<Catch> read_catchBlock = this.readOptionOfCatch();
        this.readFieldDelim("fin = ");
        Option<List<Stmt>> read_fin = this.readOptionOfListOfStmt();
        return new Try(read_info, read_body, read_catchBlock, read_fin);
    }

    private TrySS readTrySSBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("body = ");
        List<Stmt> read_body = this.readListOfStmt();
        this.readFieldDelim("catchBlock = ");
        Option<Catch> read_catchBlock = this.readOptionOfCatch();
        this.readFieldDelim("fin = ");
        Option<List<Stmt>> read_fin = this.readOptionOfListOfStmt();
        this.readFieldDelim("finallySpan = ");
        Span read_finallySpan = (Span)this.readUnknownObject();
        return new TrySS(read_info, read_body, read_catchBlock, read_fin, read_finallySpan);
    }

    private Debugger readDebuggerBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new Debugger(read_info);
    }

    private SourceElements readSourceElementsBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("body = ");
        List<SourceElement> read_body = this.readListOfSourceElement();
        this.readFieldDelim("strict = ");
        boolean read_strict = this.readBoolean();
        return new SourceElements(read_info, read_body, read_strict);
    }

    private VarDecl readVarDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        this.readFieldDelim("expr = ");
        Option<Expr> read_expr = this.readOptionOfExpr();
        this.readFieldDelim("strict = ");
        boolean read_strict = this.readBoolean();
        return new VarDecl(read_info, read_name, read_expr, read_strict);
    }

    private Case readCaseBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        this.readFieldDelim("body = ");
        List<Stmt> read_body = this.readListOfStmt();
        return new Case(read_info, read_cond, read_body);
    }

    private Catch readCatchBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("body = ");
        List<Stmt> read_body = this.readListOfStmt();
        return new Catch(read_info, read_id, read_body);
    }

    private ModImpSpecifierSet readModImpSpecifierSetBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("imports = ");
        List<ModImpSpecifier> read_imports = this.readListOfModImpSpecifier();
        this.readFieldDelim("module = ");
        Path read_module = (Path)this.readNode();
        return new ModImpSpecifierSet(read_info, read_imports, read_module);
    }

    private ModImpAliasClause readModImpAliasClauseBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Path read_name = (Path)this.readNode();
        this.readFieldDelim("alias = ");
        Id read_alias = (Id)this.readNode();
        return new ModImpAliasClause(read_info, read_name, read_alias);
    }

    private AmbCnstDecl readAmbCnstDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("ps = ");
        List<Param> read_ps = this.readListOfParam();
        return new AmbCnstDecl(read_info, read_ps);
    }

    private AmbMemDecl readAmbMemDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("mods = ");
        List<Modifier> read_mods = this.readListOfModifier();
        this.readFieldDelim("prop = ");
        Property read_prop = (Property)this.readNode();
        this.readFieldDelim("typ = ");
        Option<Type> read_typ = this.readOptionOfType();
        return new AmbMemDecl(read_info, read_mods, read_prop, read_typ);
    }

    private AmbIndDecl readAmbIndDeclBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("ind = ");
        IndexSig read_ind = (IndexSig)this.readNode();
        return new AmbIndDecl(read_info, read_ind);
    }

    private AmbEnumMem readAmbEnumMemBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("prop = ");
        Property read_prop = (Property)this.readNode();
        this.readFieldDelim("num = ");
        Option<NumberLiteral> read_num = this.readOptionOfNumberLiteral();
        return new AmbEnumMem(read_info, read_prop, read_num);
    }

    private AmbModElt readAmbModEltBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("decl = ");
        SourceElement read_decl = (SourceElement)this.readNode();
        return new AmbModElt(read_info, read_decl);
    }

    private AmbExtModElt readAmbExtModEltBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("decl = ");
        SourceElement read_decl = (SourceElement)this.readNode();
        return new AmbExtModElt(read_info, read_decl);
    }

    private ExprList readExprListBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("exprs = ");
        List<Expr> read_exprs = this.readListOfExpr();
        return new ExprList(read_info, read_exprs);
    }

    private Cond readCondBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("cond = ");
        Expr read_cond = (Expr)this.readNode();
        this.readFieldDelim("trueBranch = ");
        Expr read_trueBranch = (Expr)this.readNode();
        this.readFieldDelim("falseBranch = ");
        Expr read_falseBranch = (Expr)this.readNode();
        return new Cond(read_info, read_cond, read_trueBranch, read_falseBranch);
    }

    private InfixOpApp readInfixOpAppBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("left = ");
        Expr read_left = (Expr)this.readNode();
        this.readFieldDelim("op = ");
        Op read_op = (Op)this.readNode();
        this.readFieldDelim("right = ");
        Expr read_right = (Expr)this.readNode();
        return new InfixOpApp(read_info, read_left, read_op, read_right);
    }

    private PrefixOpApp readPrefixOpAppBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("op = ");
        Op read_op = (Op)this.readNode();
        this.readFieldDelim("right = ");
        Expr read_right = (Expr)this.readNode();
        return new PrefixOpApp(read_info, read_op, read_right);
    }

    private UnaryAssignOpApp readUnaryAssignOpAppBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("lhs = ");
        LHS read_lhs = (LHS)this.readNode();
        this.readFieldDelim("op = ");
        Op read_op = (Op)this.readNode();
        return new UnaryAssignOpApp(read_info, read_lhs, read_op);
    }

    private AssignOpApp readAssignOpAppBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("lhs = ");
        LHS read_lhs = (LHS)this.readNode();
        this.readFieldDelim("op = ");
        Op read_op = (Op)this.readNode();
        this.readFieldDelim("right = ");
        Expr read_right = (Expr)this.readNode();
        return new AssignOpApp(read_info, read_lhs, read_op, read_right);
    }

    private This readThisBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new This(read_info);
    }

    private Null readNullBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new Null(read_info);
    }

    private Bool readBoolBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("bool = ");
        boolean read_bool = this.readBoolean();
        return new Bool(read_info, read_bool);
    }

    private DoubleLiteral readDoubleLiteralBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("text = ");
        String read_text = this.readString();
        this.readFieldDelim("num = ");
        Double read_num = (Double)this.readUnknownObject();
        return new DoubleLiteral(read_info, read_text, read_num);
    }

    private IntLiteral readIntLiteralBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("intVal = ");
        BigInteger read_intVal = (BigInteger)this.readUnknownObject();
        this.readFieldDelim("radix = ");
        int read_radix = this.readInt();
        return new IntLiteral(read_info, read_intVal, read_radix);
    }

    private StringLiteral readStringLiteralBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("quote = ");
        String read_quote = this.readString();
        this.readFieldDelim("escaped = ");
        String read_escaped = this.readString();
        return new StringLiteral(read_info, read_quote, read_escaped);
    }

    private RegularExpression readRegularExpressionBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("body = ");
        String read_body = this.readString();
        this.readFieldDelim("flag = ");
        String read_flag = this.readString();
        return new RegularExpression(read_info, read_body, read_flag);
    }

    private VarRef readVarRefBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        return new VarRef(read_info, read_id);
    }

    private ArrayExpr readArrayExprBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("elements = ");
        List<Option<Expr>> read_elements = this.readListOfOptionOfExpr();
        return new ArrayExpr(read_info, read_elements);
    }

    private ArrayNumberExpr readArrayNumberExprBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("elements = ");
        List<Double> read_elements = this.readListOfDouble();
        return new ArrayNumberExpr(read_info, read_elements);
    }

    private ObjectExpr readObjectExprBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("members = ");
        List<Member> read_members = this.readListOfMember();
        return new ObjectExpr(read_info, read_members);
    }

    private Parenthesized readParenthesizedBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("expr = ");
        Expr read_expr = (Expr)this.readNode();
        return new Parenthesized(read_info, read_expr);
    }

    private FunExpr readFunExprBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("ftn = ");
        Functional read_ftn = (Functional)this.readNode();
        return new FunExpr(read_info, read_ftn);
    }

    private Bracket readBracketBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("obj = ");
        LHS read_obj = (LHS)this.readNode();
        this.readFieldDelim("index = ");
        Expr read_index = (Expr)this.readNode();
        return new Bracket(read_info, read_obj, read_index);
    }

    private Dot readDotBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("obj = ");
        LHS read_obj = (LHS)this.readNode();
        this.readFieldDelim("member = ");
        Id read_member = (Id)this.readNode();
        return new Dot(read_info, read_obj, read_member);
    }

    private New readNewBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("lhs = ");
        LHS read_lhs = (LHS)this.readNode();
        return new New(read_info, read_lhs);
    }

    private FunApp readFunAppBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("fun = ");
        LHS read_fun = (LHS)this.readNode();
        this.readFieldDelim("args = ");
        List<Expr> read_args = this.readListOfExpr();
        return new FunApp(read_info, read_fun, read_args);
    }

    private PropId readPropIdBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        return new PropId(read_info, read_id);
    }

    private PropStr readPropStrBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new PropStr(read_info, read_str);
    }

    private PropNum readPropNumBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("num = ");
        NumberLiteral read_num = (NumberLiteral)this.readNode();
        return new PropNum(read_info, read_num);
    }

    private Field readFieldBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("prop = ");
        Property read_prop = (Property)this.readNode();
        this.readFieldDelim("expr = ");
        Expr read_expr = (Expr)this.readNode();
        return new Field(read_info, read_prop, read_expr);
    }

    private GetProp readGetPropBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("prop = ");
        Property read_prop = (Property)this.readNode();
        this.readFieldDelim("ftn = ");
        Functional read_ftn = (Functional)this.readNode();
        return new GetProp(read_info, read_prop, read_ftn);
    }

    private SetProp readSetPropBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("prop = ");
        Property read_prop = (Property)this.readNode();
        this.readFieldDelim("ftn = ");
        Functional read_ftn = (Functional)this.readNode();
        return new SetProp(read_info, read_prop, read_ftn);
    }

    private Id readIdBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("text = ");
        String read_text = this.readString();
        this.readFieldDelim("uniqueName = ");
        Option<String> read_uniqueName = this.readOptionOfString();
        this.readFieldDelim("with = ");
        boolean read_with = this.readBoolean();
        return new Id(read_info, read_text, read_uniqueName, read_with);
    }

    private Op readOpBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("text = ");
        String read_text = this.readString();
        return new Op(read_info, read_text);
    }

    private TypeName readTypeNameBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("text = ");
        String read_text = this.readString();
        this.readFieldDelim("names = ");
        List<Id> read_names = this.readListOfId();
        return new TypeName(read_info, read_text, read_names);
    }

    private AnonymousFnName readAnonymousFnNameBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new AnonymousFnName(read_info);
    }

    private Path readPathBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("names = ");
        List<Id> read_names = this.readListOfId();
        return new Path(read_info, read_names);
    }

    private ModExpStarFromPath readModExpStarFromPathBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("module = ");
        Path read_module = (Path)this.readNode();
        return new ModExpStarFromPath(read_info, read_module);
    }

    private ModExpStar readModExpStarBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new ModExpStar(read_info);
    }

    private ModExpAlias readModExpAliasBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        this.readFieldDelim("alias = ");
        Path read_alias = (Path)this.readNode();
        return new ModExpAlias(read_info, read_name, read_alias);
    }

    private ModExpName readModExpNameBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Path read_name = (Path)this.readNode();
        return new ModExpName(read_info, read_name);
    }

    private ModImpAlias readModImpAliasBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        this.readFieldDelim("alias = ");
        Id read_alias = (Id)this.readNode();
        return new ModImpAlias(read_info, read_name, read_alias);
    }

    private ModImpName readModImpNameBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        return new ModImpName(read_info, read_name);
    }

    private Label readLabelBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        return new Label(read_info, read_id);
    }

    private Comment readCommentBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("comment = ");
        String read_comment = this.readString();
        return new Comment(read_info, read_comment);
    }

    private Param readParamBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        this.readFieldDelim("mod = ");
        Option<Modifier> read_mod = this.readOptionOfModifier();
        this.readFieldDelim("typ = ");
        Option<Type> read_typ = this.readOptionOfType();
        this.readFieldDelim("defaultExpr = ");
        Option<Expr> read_defaultExpr = this.readOptionOfExpr();
        this.readFieldDelim("optional = ");
        boolean read_optional = this.readBoolean();
        this.readFieldDelim("rest = ");
        boolean read_rest = this.readBoolean();
        return new Param(read_info, read_name, read_mod, read_typ, read_defaultExpr, read_optional, read_rest);
    }

    private AnyT readAnyTBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new AnyT(read_info);
    }

    private NumberT readNumberTBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new NumberT(read_info);
    }

    private BoolT readBoolTBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new BoolT(read_info);
    }

    private StringT readStringTBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new StringT(read_info);
    }

    private VoidT readVoidTBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        return new VoidT(read_info);
    }

    private TypeRef readTypeRefBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        TypeName read_name = (TypeName)this.readNode();
        this.readFieldDelim("args = ");
        List<Type> read_args = this.readListOfType();
        return new TypeRef(read_info, read_name, read_args);
    }

    private TypeQuery readTypeQueryBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("path = ");
        Path read_path = (Path)this.readNode();
        return new TypeQuery(read_info, read_path);
    }

    private ObjectType readObjectTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("members = ");
        List<TypeMember> read_members = this.readListOfTypeMember();
        return new ObjectType(read_info, read_members);
    }

    private ArrayType readArrayTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("typ = ");
        Type read_typ = (Type)this.readNode();
        return new ArrayType(read_info, read_typ);
    }

    private FunctionType readFunctionTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("tparams = ");
        List<TypeParam> read_tparams = this.readListOfTypeParam();
        this.readFieldDelim("params = ");
        List<Param> read_params = this.readListOfParam();
        this.readFieldDelim("typ = ");
        Type read_typ = (Type)this.readNode();
        return new FunctionType(read_info, read_tparams, read_params, read_typ);
    }

    private ConstructorType readConstructorTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("tparams = ");
        List<TypeParam> read_tparams = this.readListOfTypeParam();
        this.readFieldDelim("params = ");
        List<Param> read_params = this.readListOfParam();
        this.readFieldDelim("typ = ");
        Type read_typ = (Type)this.readNode();
        return new ConstructorType(read_info, read_tparams, read_params, read_typ);
    }

    private ExprType readExprTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        return new ExprType(read_info, read_name);
    }

    private PropertySig readPropertySigBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("prop = ");
        Property read_prop = (Property)this.readNode();
        this.readFieldDelim("optional = ");
        boolean read_optional = this.readBoolean();
        this.readFieldDelim("typ = ");
        Option<Type> read_typ = this.readOptionOfType();
        return new PropertySig(read_info, read_prop, read_optional, read_typ);
    }

    private CallSig readCallSigBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("tparams = ");
        List<TypeParam> read_tparams = this.readListOfTypeParam();
        this.readFieldDelim("params = ");
        List<Param> read_params = this.readListOfParam();
        this.readFieldDelim("typ = ");
        Option<Type> read_typ = this.readOptionOfType();
        return new CallSig(read_info, read_tparams, read_params, read_typ);
    }

    private ConstructSig readConstructSigBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("tparams = ");
        List<TypeParam> read_tparams = this.readListOfTypeParam();
        this.readFieldDelim("params = ");
        List<Param> read_params = this.readListOfParam();
        this.readFieldDelim("typ = ");
        Option<Type> read_typ = this.readOptionOfType();
        return new ConstructSig(read_info, read_tparams, read_params, read_typ);
    }

    private IndexSig readIndexSigBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("id = ");
        Id read_id = (Id)this.readNode();
        this.readFieldDelim("annot = ");
        Type read_annot = (Type)this.readNode();
        this.readFieldDelim("num = ");
        boolean read_num = this.readBoolean();
        return new IndexSig(read_info, read_id, read_annot, read_num);
    }

    private MethodSig readMethodSigBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("prop = ");
        Property read_prop = (Property)this.readNode();
        this.readFieldDelim("optional = ");
        boolean read_optional = this.readBoolean();
        this.readFieldDelim("sig = ");
        CallSig read_sig = (CallSig)this.readNode();
        return new MethodSig(read_info, read_prop, read_optional, read_sig);
    }

    private TypeParam readTypeParamBody() throws IOException {
        this.readFieldDelim("info = ");
        ASTSpanInfo read_info = (ASTSpanInfo)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        this.readFieldDelim("ext = ");
        Option<Type> read_ext = this.readOptionOfType();
        return new TypeParam(read_info, read_name, read_ext);
    }

    private TopLevel readTopLevelBody() throws IOException {
        this.readFieldDelim("fds = ");
        List<FunDecl> read_fds = this.readListOfFunDecl();
        this.readFieldDelim("vds = ");
        List<VarDecl> read_vds = this.readListOfVarDecl();
        this.readFieldDelim("stmts = ");
        List<SourceElements> read_stmts = this.readListOfSourceElements();
        return new TopLevel(read_fds, read_vds, read_stmts);
    }

    private Functional readFunctionalBody() throws IOException {
        this.readFieldDelim("fds = ");
        List<FunDecl> read_fds = this.readListOfFunDecl();
        this.readFieldDelim("vds = ");
        List<VarDecl> read_vds = this.readListOfVarDecl();
        this.readFieldDelim("stmts = ");
        SourceElements read_stmts = (SourceElements)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        this.readFieldDelim("params = ");
        List<Id> read_params = this.readListOfId();
        return new Functional(read_fds, read_vds, read_stmts, read_name, read_params);
    }

    private FunctionalSS readFunctionalSSBody() throws IOException {
        this.readFieldDelim("fds = ");
        List<FunDecl> read_fds = this.readListOfFunDecl();
        this.readFieldDelim("vds = ");
        List<VarDecl> read_vds = this.readListOfVarDecl();
        this.readFieldDelim("stmts = ");
        SourceElements read_stmts = (SourceElements)this.readNode();
        this.readFieldDelim("name = ");
        Id read_name = (Id)this.readNode();
        this.readFieldDelim("params = ");
        List<Id> read_params = this.readListOfId();
        this.readFieldDelim("openSpan = ");
        Span read_openSpan = (Span)this.readUnknownObject();
        return new FunctionalSS(read_fds, read_vds, read_stmts, read_name, read_params, read_openSpan);
    }

    private ASTSpanInfo readASTSpanInfoBody() throws IOException {
        this.readFieldDelim("span = ");
        Span read_span = (Span)this.readUnknownObject();
        this.readFieldDelim("comment = ");
        Option<Comment> read_comment = this.readOptionOfComment();
        return new ASTSpanInfo(read_span, read_comment);
    }

    private PublicMod readPublicModBody() throws IOException {
        return new PublicMod();
    }

    private PrivateMod readPrivateModBody() throws IOException {
        return new PrivateMod();
    }

    private StaticMod readStaticModBody() throws IOException {
        return new StaticMod();
    }

    private List<VarDecl> readListOfVarDecl() throws IOException {
        this.readExpected("{");
        ArrayList<VarDecl> accum = new ArrayList<VarDecl>();
        while (this.readMoreListElements()) {
            accum.add((VarDecl)this.readNode());
        }
        return accum;
    }

    private List<ModExpSpecifier> readListOfModExpSpecifier() throws IOException {
        this.readExpected("{");
        ArrayList<ModExpSpecifier> accum = new ArrayList<ModExpSpecifier>();
        while (this.readMoreListElements()) {
            accum.add((ModExpSpecifier)this.readNode());
        }
        return accum;
    }

    private List<ModImport> readListOfModImport() throws IOException {
        this.readExpected("{");
        ArrayList<ModImport> accum = new ArrayList<ModImport>();
        while (this.readMoreListElements()) {
            accum.add((ModImport)this.readNode());
        }
        return accum;
    }

    private List<TypeParam> readListOfTypeParam() throws IOException {
        this.readExpected("{");
        ArrayList<TypeParam> accum = new ArrayList<TypeParam>();
        while (this.readMoreListElements()) {
            accum.add((TypeParam)this.readNode());
        }
        return accum;
    }

    private List<TypeRef> readListOfTypeRef() throws IOException {
        this.readExpected("{");
        ArrayList<TypeRef> accum = new ArrayList<TypeRef>();
        while (this.readMoreListElements()) {
            accum.add((TypeRef)this.readNode());
        }
        return accum;
    }

    private Option<Type> readOptionOfType() throws IOException {
        if (this.readOptionHeader()) {
            Type elt_result = (Type)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private Option<TypeRef> readOptionOfTypeRef() throws IOException {
        if (this.readOptionHeader()) {
            TypeRef elt_result = (TypeRef)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<AmbClsElt> readListOfAmbClsElt() throws IOException {
        this.readExpected("{");
        ArrayList<AmbClsElt> accum = new ArrayList<AmbClsElt>();
        while (this.readMoreListElements()) {
            accum.add((AmbClsElt)this.readNode());
        }
        return accum;
    }

    private List<AmbEnumMem> readListOfAmbEnumMem() throws IOException {
        this.readExpected("{");
        ArrayList<AmbEnumMem> accum = new ArrayList<AmbEnumMem>();
        while (this.readMoreListElements()) {
            accum.add((AmbEnumMem)this.readNode());
        }
        return accum;
    }

    private List<AmbModElt> readListOfAmbModElt() throws IOException {
        this.readExpected("{");
        ArrayList<AmbModElt> accum = new ArrayList<AmbModElt>();
        while (this.readMoreListElements()) {
            accum.add((AmbModElt)this.readNode());
        }
        return accum;
    }

    private List<AmbExtModElt> readListOfAmbExtModElt() throws IOException {
        this.readExpected("{");
        ArrayList<AmbExtModElt> accum = new ArrayList<AmbExtModElt>();
        while (this.readMoreListElements()) {
            accum.add((AmbExtModElt)this.readNode());
        }
        return accum;
    }

    private List<Stmt> readListOfStmt() throws IOException {
        this.readExpected("{");
        ArrayList<Stmt> accum = new ArrayList<Stmt>();
        while (this.readMoreListElements()) {
            accum.add((Stmt)this.readNode());
        }
        return accum;
    }

    private Option<Stmt> readOptionOfStmt() throws IOException {
        if (this.readOptionHeader()) {
            Stmt elt_result = (Stmt)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private Option<Expr> readOptionOfExpr() throws IOException {
        if (this.readOptionHeader()) {
            Expr elt_result = (Expr)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private Option<Label> readOptionOfLabel() throws IOException {
        if (this.readOptionHeader()) {
            Label elt_result = (Label)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<Case> readListOfCase() throws IOException {
        this.readExpected("{");
        ArrayList<Case> accum = new ArrayList<Case>();
        while (this.readMoreListElements()) {
            accum.add((Case)this.readNode());
        }
        return accum;
    }

    private Option<List<Stmt>> readOptionOfListOfStmt() throws IOException {
        if (this.readOptionHeader()) {
            List<Stmt> elt_result = this.readListOfStmt();
            this.readExpected(")");
            return Option.some(elt_result);
        }
        return Option.none();
    }

    private Option<Catch> readOptionOfCatch() throws IOException {
        if (this.readOptionHeader()) {
            Catch elt_result = (Catch)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<SourceElement> readListOfSourceElement() throws IOException {
        this.readExpected("{");
        ArrayList<SourceElement> accum = new ArrayList<SourceElement>();
        while (this.readMoreListElements()) {
            accum.add((SourceElement)this.readNode());
        }
        return accum;
    }

    private List<ModImpSpecifier> readListOfModImpSpecifier() throws IOException {
        this.readExpected("{");
        ArrayList<ModImpSpecifier> accum = new ArrayList<ModImpSpecifier>();
        while (this.readMoreListElements()) {
            accum.add((ModImpSpecifier)this.readNode());
        }
        return accum;
    }

    private List<Param> readListOfParam() throws IOException {
        this.readExpected("{");
        ArrayList<Param> accum = new ArrayList<Param>();
        while (this.readMoreListElements()) {
            accum.add((Param)this.readNode());
        }
        return accum;
    }

    private List<Modifier> readListOfModifier() throws IOException {
        this.readExpected("{");
        ArrayList<Modifier> accum = new ArrayList<Modifier>();
        while (this.readMoreListElements()) {
            accum.add((Modifier)this.readNode());
        }
        return accum;
    }

    private Option<NumberLiteral> readOptionOfNumberLiteral() throws IOException {
        if (this.readOptionHeader()) {
            NumberLiteral elt_result = (NumberLiteral)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<Expr> readListOfExpr() throws IOException {
        this.readExpected("{");
        ArrayList<Expr> accum = new ArrayList<Expr>();
        while (this.readMoreListElements()) {
            accum.add((Expr)this.readNode());
        }
        return accum;
    }

    private List<Option<Expr>> readListOfOptionOfExpr() throws IOException {
        this.readExpected("{");
        ArrayList<Option<Expr>> accum = new ArrayList<Option<Expr>>();
        while (this.readMoreListElements()) {
            accum.add(this.readOptionOfExpr());
        }
        return accum;
    }

    private List<Double> readListOfDouble() throws IOException {
        this.readExpected("{");
        ArrayList<Double> accum = new ArrayList<Double>();
        while (this.readMoreListElements()) {
            accum.add((Double)this.readUnknownObject());
        }
        return accum;
    }

    private List<Member> readListOfMember() throws IOException {
        this.readExpected("{");
        ArrayList<Member> accum = new ArrayList<Member>();
        while (this.readMoreListElements()) {
            accum.add((Member)this.readNode());
        }
        return accum;
    }

    private Option<String> readOptionOfString() throws IOException {
        if (this.readOptionHeader()) {
            String elt_result = this.readString();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<Id> readListOfId() throws IOException {
        this.readExpected("{");
        ArrayList<Id> accum = new ArrayList<Id>();
        while (this.readMoreListElements()) {
            accum.add((Id)this.readNode());
        }
        return accum;
    }

    private Option<Modifier> readOptionOfModifier() throws IOException {
        if (this.readOptionHeader()) {
            Modifier elt_result = (Modifier)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<Type> readListOfType() throws IOException {
        this.readExpected("{");
        ArrayList<Type> accum = new ArrayList<Type>();
        while (this.readMoreListElements()) {
            accum.add((Type)this.readNode());
        }
        return accum;
    }

    private List<TypeMember> readListOfTypeMember() throws IOException {
        this.readExpected("{");
        ArrayList<TypeMember> accum = new ArrayList<TypeMember>();
        while (this.readMoreListElements()) {
            accum.add((TypeMember)this.readNode());
        }
        return accum;
    }

    private List<FunDecl> readListOfFunDecl() throws IOException {
        this.readExpected("{");
        ArrayList<FunDecl> accum = new ArrayList<FunDecl>();
        while (this.readMoreListElements()) {
            accum.add((FunDecl)this.readNode());
        }
        return accum;
    }

    private List<SourceElements> readListOfSourceElements() throws IOException {
        this.readExpected("{");
        ArrayList<SourceElements> accum = new ArrayList<SourceElements>();
        while (this.readMoreListElements()) {
            accum.add((SourceElements)this.readNode());
        }
        return accum;
    }

    private Option<Comment> readOptionOfComment() throws IOException {
        if (this.readOptionHeader()) {
            Comment elt_result = (Comment)this.readNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    protected boolean readBoolean() throws IOException {
        char c;
        char t = c = this.readCharWord();
        while (!Character.isWhitespace(t)) {
            t = this.next();
        }
        if (c == 't') {
            return true;
        }
        if (c == 'f') {
            return false;
        }
        throw this.error();
    }

    protected char readChar() throws IOException {
        this.readExpected("\"");
        String word = this.readTo('\"', true);
        String result = this.unescape(word);
        if (result.length() != 1) {
            throw this.error();
        }
        return result.charAt(0);
    }

    protected byte readByte() throws IOException {
        String word = this.readNum();
        try {
            return Byte.parseByte(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected short readShort() throws IOException {
        String word = this.readNum();
        try {
            return Short.parseShort(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected int readInt() throws IOException {
        String word = this.readNum();
        try {
            return Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected long readLong() throws IOException {
        String word = this.readNum();
        try {
            return Long.parseLong(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected float readFloat() throws IOException {
        String word = this.readWord();
        try {
            return Float.parseFloat(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected double readDouble() throws IOException {
        String word = this.readWord();
        try {
            return Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected String readString() throws IOException {
        char delim = this.readCharWord();
        if (delim == '_') {
            return null;
        }
        if (delim != '\"') {
            throw this.error();
        }
        this.next();
        String word = this.readTo('\"', true);
        return this.unescape(word);
    }

    protected Object wordToUnknownObject(String word) throws IOException {
        if (word.equals("_")) {
            return null;
        }
        ObjectInputStream objIn = this.toObjectStream(word);
        try {
            Object object = objIn.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException: " + e.getMessage());
        }
        finally {
            try {
                objIn.close();
            }
            catch (IOException e) {}
        }
    }

    protected Object readUnknownObject() throws IOException {
        String word = this.readWord();
        this.readToNewline();
        return this.wordToUnknownObject(word);
    }

    protected String readWord() throws IOException {
        char c = this.readCharWord();
        StringBuilder result = new StringBuilder();
        do {
            result.append(c);
        } while (!Character.isWhitespace(c = this.next()));
        return result.toString();
    }

    protected String readNum() throws IOException {
        char c = this.readCharWord();
        StringBuilder result = new StringBuilder();
        if (c != '-' && !Character.isDigit(c)) {
            throw this.error();
        }
        do {
            result.append(c);
        } while (Character.isDigit(c = this.next()));
        return result.toString();
    }

    protected char readCharWord() throws IOException {
        char c = this.currentChar;
        while (Character.isWhitespace(c)) {
            c = this.next();
        }
        return c;
    }

    protected void readExpected(String s) throws IOException {
        char c = this.readCharWord();
        for (int i = 0; i < s.length(); ++i) {
            if (c != s.charAt(i)) {
                System.out.println("Was expecting '" + s + "', saw '" + c + "' instead of '" + s.charAt(i) + "'");
                throw this.error();
            }
            c = this.next();
        }
    }

    protected void readFieldDelim(String s) throws IOException {
        this.readExpected(s);
    }

    protected boolean readMoreListElements() throws IOException {
        char c = this.readCharWord();
        if (c == '}') {
            this.next();
            return false;
        }
        if (c == '*') {
            this.next();
            return true;
        }
        throw this.error();
    }

    protected boolean readOptionHeader() throws IOException {
        char c = this.readCharWord();
        if (c == '~') {
            this.next();
            return false;
        }
        if (c == '(') {
            this.next();
            return true;
        }
        throw this.error();
    }

    protected String readTo(char delim, boolean skipEscape) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean escape2 = false;
        char c = this.curr();
        while (escape2 || c != delim) {
            if (c == '\n' || c == '\r') {
                throw this.error();
            }
            result.append(c);
            if (escape2) {
                escape2 = false;
            } else if (skipEscape && c == '\\') {
                escape2 = true;
            }
            c = this.next();
        }
        this.next();
        return result.toString();
    }

    protected char skipTo(char ... delims) throws IOException {
        char c = this.currentChar;
        while (true) {
            if (c == '\n' || c == '\r') {
                throw this.error();
            }
            for (char delim : delims) {
                if (c != delim) continue;
                return delim;
            }
            c = this.next();
        }
    }

    protected String readToNewline() throws IOException {
        String result = this.in.readLine();
        if (result == null) {
            throw this.error();
        }
        this.readCharWord();
        return result;
    }

    protected char next() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            throw this.error();
        }
        this.currentChar = (char)c;
        return this.currentChar;
    }

    protected char curr() {
        return this.currentChar;
    }

    protected String unescape(String s) throws IOException {
        boolean escape2 = false;
        StringBuilder digits = new StringBuilder();
        boolean changed = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escape2) {
                switch (c) {
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        result.append(c);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        digits.append(c);
                        if (digits.length() != 3) break;
                        result.append((char)Integer.parseInt(digits.toString(), 8));
                        digits.setLength(0);
                        break;
                    }
                    default: {
                        throw this.error();
                    }
                }
                if (digits.length() != 0) continue;
                escape2 = false;
                continue;
            }
            if (c == '\\') {
                escape2 = true;
                changed = true;
                continue;
            }
            result.append(c);
        }
        if (escape2) {
            throw this.error();
        }
        return changed ? result.toString() : s;
    }

    protected ObjectInputStream toObjectStream(String byteString) throws IOException {
        if (byteString.length() % 2 != 0) {
            throw this.error();
        }
        int length2 = byteString.length() / 2;
        byte[] bytes = new byte[length2];
        for (int i = 0; i < length2; ++i) {
            String b = byteString.substring(i * 2, i * 2 + 2);
            try {
                int unsigned = Integer.parseInt(b, 16);
                if (unsigned < 128) {
                    bytes[i] = (byte)unsigned;
                    continue;
                }
                bytes[i] = (byte)(unsigned - 256);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.error();
            }
        }
        return new ObjectInputStream(new ByteArrayInputStream(bytes));
    }

    protected IOException error() {
        return new IOException("Serialized data is not properly encoded");
    }
}

