/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import java.util.Collections;
import java.util.List;
import kr.ac.kaist.jsaf.nodes.TreeWalker;
import kr.ac.kaist.jsaf.nodes.WDefinition;
import kr.ac.kaist.jsaf.nodes.WDictionaryMember;
import kr.ac.kaist.jsaf.nodes.WEAttribute;
import kr.ac.kaist.jsaf.nodes.WIDLVisitor;
import kr.ac.kaist.jsaf.nodes.WIDLVisitor_void;
import kr.ac.kaist.jsaf.nodes.WId;
import kr.ac.kaist.jsaf.nodes.WNodeVisitor;
import kr.ac.kaist.jsaf.nodes.WNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes_util.SpanInfo;

public class WDictionary
extends WDefinition {
    private final String _name;
    private final Option<WId> _parent;
    private final List<WDictionaryMember> _members;

    public WDictionary(SpanInfo in_info, List<WEAttribute> in_attrs, String in_name, Option<WId> in_parent, List<WDictionaryMember> in_members) {
        super(in_info, in_attrs);
        if (in_name == null) {
            throw new IllegalArgumentException("Parameter 'name' to the WDictionary constructor was null");
        }
        this._name = in_name.intern();
        if (in_parent == null) {
            throw new IllegalArgumentException("Parameter 'parent' to the WDictionary constructor was null");
        }
        this._parent = in_parent;
        if (in_members == null) {
            throw new IllegalArgumentException("Parameter 'members' to the WDictionary constructor was null");
        }
        this._members = in_members;
    }

    public WDictionary(SpanInfo in_info, String in_name, Option<WId> in_parent, List<WDictionaryMember> in_members) {
        this(in_info, Collections.emptyList(), in_name, in_parent, in_members);
    }

    public final String getName() {
        return this._name;
    }

    public final Option<WId> getParent() {
        return this._parent;
    }

    public final List<WDictionaryMember> getMembers() {
        return this._members;
    }

    @Override
    public <RetType> RetType accept(WIDLVisitor<RetType> visitor) {
        return visitor.forWDictionary(this);
    }

    @Override
    public <RetType> RetType accept(WNodeVisitor<RetType> visitor) {
        return visitor.forWDictionary(this);
    }

    @Override
    public void accept(WIDLVisitor_void visitor) {
        visitor.forWDictionary(this);
    }

    @Override
    public void accept(WNodeVisitor_void visitor) {
        visitor.forWDictionary(this);
    }

    public boolean equals(Object obj) {
        List<WDictionaryMember> casted_members;
        Option<WId> casted_parent;
        String casted_name;
        List<WEAttribute> casted_attrs;
        SpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        WDictionary casted = (WDictionary)obj;
        SpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        List<WEAttribute> temp_attrs = this.getAttrs();
        if (temp_attrs != (casted_attrs = casted.getAttrs()) && !temp_attrs.equals(casted_attrs)) {
            return false;
        }
        String temp_name = this.getName();
        if (temp_name != (casted_name = casted.getName())) {
            return false;
        }
        Option<WId> temp_parent = this.getParent();
        if (temp_parent != (casted_parent = casted.getParent()) && !temp_parent.equals(casted_parent)) {
            return false;
        }
        List<WDictionaryMember> temp_members = this.getMembers();
        return temp_members == (casted_members = casted.getMembers()) || temp_members.equals(casted_members);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        SpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        List<WEAttribute> temp_attrs = this.getAttrs();
        code ^= temp_attrs.hashCode();
        String temp_name = this.getName();
        code ^= temp_name.hashCode();
        Option<WId> temp_parent = this.getParent();
        code ^= temp_parent.hashCode();
        List<WDictionaryMember> temp_members = this.getMembers();
        return code ^= temp_members.hashCode();
    }

    protected WDictionary() {
        this._name = null;
        this._parent = null;
        this._members = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "WDictionary", 5)) {
            List<WDictionaryMember> temp_members;
            Option<WId> temp_parent;
            String temp_name;
            List<WEAttribute> temp_attrs;
            SpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                w.visitUnknownObject(temp_info);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("attrs", temp_attrs = this.getAttrs())) {
                if (w.visitIterated(temp_attrs)) {
                    int i_temp_attrs = 0;
                    for (WEAttribute elt_temp_attrs : temp_attrs) {
                        if (w.visitIteratedElement(i_temp_attrs, elt_temp_attrs)) {
                            if (elt_temp_attrs == null) {
                                w.visitNull();
                            } else {
                                elt_temp_attrs.walk(w);
                            }
                        }
                        ++i_temp_attrs;
                    }
                    w.endIterated(temp_attrs, i_temp_attrs);
                }
                w.endNodeField("attrs", temp_attrs);
            }
            if (w.visitNodeField("name", temp_name = this.getName())) {
                w.visitString(temp_name);
                w.endNodeField("name", temp_name);
            }
            if (w.visitNodeField("parent", temp_parent = this.getParent())) {
                if (temp_parent.isNone()) {
                    w.visitEmptyOption(temp_parent);
                } else if (w.visitNonEmptyOption(temp_parent)) {
                    WId elt_temp_parent = (WId)temp_parent.unwrap();
                    if (elt_temp_parent == null) {
                        w.visitNull();
                    } else {
                        elt_temp_parent.walk(w);
                    }
                    w.endNonEmptyOption(temp_parent);
                }
                w.endNodeField("parent", temp_parent);
            }
            if (w.visitNodeField("members", temp_members = this.getMembers())) {
                if (w.visitIterated(temp_members)) {
                    int i_temp_members = 0;
                    for (WDictionaryMember elt_temp_members : temp_members) {
                        if (w.visitIteratedElement(i_temp_members, elt_temp_members)) {
                            if (elt_temp_members == null) {
                                w.visitNull();
                            } else {
                                elt_temp_members.walk(w);
                            }
                        }
                        ++i_temp_members;
                    }
                    w.endIterated(temp_members, i_temp_members);
                }
                w.endNodeField("members", temp_members);
            }
            w.endNode(this, "WDictionary", 5);
        }
    }
}

