/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.OptionVisitor;
import java.util.LinkedList;
import java.util.List;
import kr.ac.kaist.jsaf.nodes.ASTNode;
import kr.ac.kaist.jsaf.nodes.AbstractNode;
import kr.ac.kaist.jsaf.nodes.Node;
import kr.ac.kaist.jsaf.nodes.NodeAbstractVisitor;
import kr.ac.kaist.jsaf.nodes_util.NodeUtil;

public class ErrorMsgMaker
extends NodeAbstractVisitor<String> {
    public static final ErrorMsgMaker ONLY = new ErrorMsgMaker();

    public static String errorMsg(Object ... messages) {
        StringBuilder fullMessage = new StringBuilder();
        for (Object message : messages) {
            if (message instanceof AbstractNode) {
                fullMessage.append(ErrorMsgMaker.makeErrorMsg((AbstractNode)message));
                continue;
            }
            fullMessage.append(message.toString());
        }
        return fullMessage.toString();
    }

    public static String makeErrorMsg(AbstractNode node) {
        return node.accept(ONLY);
    }

    private ErrorMsgMaker() {
    }

    public final List<String> mapSelf(List<? extends AbstractNode> that) {
        LinkedList<String> result = new LinkedList<String>();
        for (AbstractNode abstractNode : that) {
            result.add(abstractNode.accept(this));
        }
        return result;
    }

    private final String acceptIfPresent(Option<? extends Node> possibleNode) {
        return (String)possibleNode.apply((OptionVisitor)new OptionVisitor<Node, String>(){

            public String forSome(Node n) {
                return n.accept(ErrorMsgMaker.this);
            }

            public String forNone() {
                return "";
            }
        });
    }

    @Override
    public String forAbstractNode(AbstractNode node) {
        return node.getClass().getSimpleName() + " at " + NodeUtil.getSpan((ASTNode)node).begin.at();
    }
}

