/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import edu.rice.cs.plt.tuple.Null;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Wrapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.ac.kaist.jsaf.nodes.ASTSpanInfo;
import kr.ac.kaist.jsaf.nodes.AbstractNode;
import kr.ac.kaist.jsaf.nodes.Comment;
import kr.ac.kaist.jsaf.nodes.IRAbstractNode;
import kr.ac.kaist.jsaf.nodes.IRExpr;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRInfoNode;
import kr.ac.kaist.jsaf.nodes.IRNumber;
import kr.ac.kaist.jsaf.nodes.IROp;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.Id;
import kr.ac.kaist.jsaf.nodes.Literal;
import kr.ac.kaist.jsaf.nodes.Modifier;
import kr.ac.kaist.jsaf.nodes.Op;
import kr.ac.kaist.jsaf.nodes.PrivateMod;
import kr.ac.kaist.jsaf.nodes.PublicMod;
import kr.ac.kaist.jsaf.nodes.ScopeBody;
import kr.ac.kaist.jsaf.nodes.StaticMod;
import kr.ac.kaist.jsaf.nodes.VarRef;
import kr.ac.kaist.jsaf.nodes_util.NodeReflection;
import kr.ac.kaist.jsaf.nodes_util.NodeUtil;
import kr.ac.kaist.jsaf.nodes_util.Span;
import kr.ac.kaist.jsaf.nodes_util.Unprinter;
import kr.ac.kaist.jsaf.useful.Pair;

public class Printer
extends NodeReflection {
    boolean firstFieldOnNewLine;
    boolean oneLineVarRef;
    boolean skipEmpty = true;
    int shortListThreshold = 4;
    int oneLinerNesting;
    public static final String tilde = "~";
    public static final String nl = System.getProperty("line.separator");
    Span lastSpan = null;
    static final String indentString = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ";

    public Printer() {
        this(true, true, true);
    }

    public Printer(boolean firstFieldOnNewLine, boolean oneLineVarRef, boolean skipEmpty) {
        this.firstFieldOnNewLine = firstFieldOnNewLine;
        this.oneLineVarRef = oneLineVarRef;
        this.skipEmpty = skipEmpty;
    }

    void indent(int i, Appendable w) throws IOException {
        w.append("\n");
        w.append(indentString.substring(0, i));
    }

    public void dumpSpan(Span span, Appendable w) throws IOException {
        boolean do_file;
        if (span == null) {
            return;
        }
        if (this.lastSpan == null) {
            span.appendTo(w, true, true);
            this.lastSpan = span;
            return;
        }
        boolean bl = do_file = !this.lastSpan.end.getFileName().equals(span.begin.getFileName()) || !this.lastSpan.begin.getFileName().equals(span.begin.getFileName());
        if (do_file || this.lastSpan.begin.column() != span.begin.column() || this.lastSpan.end.column() != span.end.column() || this.lastSpan.begin.getLine() != span.begin.getLine() || this.lastSpan.end.getLine() != span.end.getLine()) {
            span.appendTo(w, do_file, true);
        }
        this.lastSpan = span;
    }

    private boolean allAtoms(List l) {
        for (int i = 0; i < l.size(); ++i) {
            Object o = l.get(i);
            if (o instanceof String || o instanceof Number || o instanceof Boolean) continue;
            return false;
        }
        return true;
    }

    public void dump(Object o, Appendable w) throws IOException {
        this.dump(o, w, 0);
    }

    public void dump(Object o, Appendable w, int indent2) throws IOException {
        if (o == null) {
            w.append("_");
        } else if (o instanceof String) {
            String s = (String)o;
            w.append('\"');
            w.append(Unprinter.enQuote(s));
            w.append('\"');
        } else if (o instanceof Pair) {
            Pair p = (Pair)o;
            Object a = p.getA();
            Object b = p.getB();
            if (this.firstFieldOnNewLine) {
                w.append("(Pair");
                this.indent(indent2 + 1, w);
                this.dump(a, w, indent2 + 1);
            } else {
                w.append("(Pair ");
                this.dump(a, w, indent2 + 1);
            }
            this.indent(indent2 + 1, w);
            this.dump(b, w, indent2 + 1);
            w.append(")");
        } else if (o instanceof Double) {
            w.append(Double.toString((Double)o));
        } else if (o instanceof Number) {
            w.append(o.toString());
        } else if (o instanceof Boolean) {
            w.append(o.toString());
        } else if (o instanceof List) {
            List l = (List)o;
            w.append("[");
            if (l.size() < this.shortListThreshold && this.allAtoms(l)) {
                for (int k = 0; k < l.size(); ++k) {
                    if (k > 0) {
                        w.append(" ");
                    }
                    this.dump(l.get(k), w, indent2 + 1);
                }
            } else {
                for (int k = 0; k < l.size(); ++k) {
                    if (k > 0 || this.firstFieldOnNewLine) {
                        if (this.oneLineVarRef && this.oneLinerNesting > 0) {
                            if (k > 0) {
                                w.append(" ");
                            }
                        } else {
                            this.indent(indent2 + 1, w);
                        }
                    }
                    this.dump(l.get(k), w, indent2 + 1);
                }
            }
            w.append("]");
        } else if (o instanceof Wrapper) {
            w.append("(");
            w.append("Some");
            Field[] fields = this.getCachedPrintableFields(Wrapper.class);
            this.dumpFields(w, indent2, o, true, fields, false);
            w.append(")");
        } else if (o instanceof Null) {
            w.append("(");
            w.append("Some");
            w.append(")");
        } else if (o instanceof Modifier) {
            if (o instanceof PublicMod) {
                w.append("(PublicMod)");
            } else if (o instanceof PrivateMod) {
                w.append("(PrivateMod)");
            } else if (o instanceof StaticMod) {
                w.append("(StaticMod)");
            }
        } else if (o instanceof AbstractNode) {
            AbstractNode x = (AbstractNode)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = o instanceof Literal || o instanceof VarRef ? 1 : 0;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = this.oneLineVarRef && (this.oneLinerNesting > 0 || o instanceof Id || o instanceof Wrapper);
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpSpan(NodeUtil.getSpan(x), w);
            this.dumpFields(w, indent2, x, oneLiner, fields, true);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof ASTSpanInfo) {
            ASTSpanInfo x = (ASTSpanInfo)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            Option<Comment> comment = x.getComment();
            if (comment.isNone()) {
                w.append("()");
            } else {
                w.append("(");
                this.dump(((Comment)comment.unwrap()).getComment(), w);
                w.append(")");
            }
            w.append(")");
        } else if (o instanceof IRAbstractNode) {
            IRAbstractNode x = (IRAbstractNode)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = o instanceof IRId ? 1 : 0;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = this.oneLineVarRef && (this.oneLinerNesting > 0 || o instanceof IRId || o instanceof Wrapper);
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpSpan(NodeUtil.getSpan(x), w);
            this.dumpFields(w, indent2, x, oneLiner, fields, true);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof IRExpr) {
            IRExpr x = (IRExpr)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = o instanceof IRId ? 1 : 0;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = this.oneLineVarRef && (this.oneLinerNesting > 0 || o instanceof IRId || o instanceof Wrapper);
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpFields(w, indent2, x, oneLiner, fields, true);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof IROp) {
            IROp x = (IROp)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = o instanceof IRId ? 1 : 0;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = this.oneLineVarRef && (this.oneLinerNesting > 0 || o instanceof IRId || o instanceof Wrapper);
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpFields(w, indent2, x, oneLiner, fields, true);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof IRId) {
            IRId x = (IRId)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = 1;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = true;
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpFields(w, indent2, x, oneLiner, fields, true);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof IRNumber) {
            IRNumber x = (IRNumber)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = 1;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = true;
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpFields(w, indent2, x, oneLiner, fields, true);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof IRSpanInfo) {
            IRSpanInfo x = (IRSpanInfo)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = o instanceof VarRef || o instanceof Op ? 1 : 0;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = this.oneLineVarRef && (this.oneLinerNesting > 0 || o instanceof Op || o instanceof Id);
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpSpan(x.getSpan(), w);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof ScopeBody) {
            ScopeBody x = (ScopeBody)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = o instanceof VarRef || o instanceof Op ? 1 : 0;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = this.oneLineVarRef && (this.oneLinerNesting > 0 || o instanceof Op || o instanceof Id);
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpFields(w, indent2, x, oneLiner, fields, true);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof IRInfoNode) {
            IRInfoNode x = (IRInfoNode)o;
            Class<?> cl = x.getClass();
            String clname = cl.getSimpleName();
            int oneLinerNestingInc = o instanceof VarRef || o instanceof Op ? 1 : 0;
            this.oneLinerNesting += oneLinerNestingInc;
            boolean oneLiner = this.oneLineVarRef && (this.oneLinerNesting > 0 || o instanceof Op || o instanceof Id);
            Field[] fields = this.getCachedPrintableFields(cl, clname);
            w.append("(");
            w.append(clname);
            this.dumpFields(w, indent2, x, oneLiner, fields, true);
            w.append(")");
            this.oneLinerNesting -= oneLinerNestingInc;
        } else if (o instanceof Map) {
            w.append("(Map ");
            Set set2 = ((Map)o).entrySet();
            for (Map.Entry entry : set2) {
                w.append("!");
                w.append(entry.getKey().toString());
                w.append("=");
                this.dump(entry.getValue(), w, indent2);
            }
            w.append(")");
        } else {
            w.append("?" + o.getClass().getName());
        }
    }

    private void dumpFields(Appendable w, int indent2, Object x, boolean oneLiner, Field[] fields, boolean skipThisEmpty) throws IOException {
        for (int j = 0; j < fields.length; ++j) {
            Field f = fields[j];
            try {
                Object p = f.get(x);
                if (this.skipEmpty && skipThisEmpty && (p instanceof List && ((List)p).size() == 0 || p instanceof Null || p instanceof Boolean && !((Boolean)p).booleanValue()) || x instanceof Span) continue;
                if (oneLiner) {
                    w.append(" ");
                } else {
                    this.indent(indent2 + 1, w);
                }
                w.append(f.getName());
                w.append("=");
                this.dump(p, w, indent2 + 1);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Constructor defaultConstructorFor(Class cl) throws NoSuchMethodException {
        return null;
    }
}

