/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class WireTappedPrintStream
extends PrintStream {
    PrintStream tappee;
    ByteArrayOutputStream s;
    boolean postponePassthrough;
    int postponeStart;
    public static final int DEFAULT_BYTE_LIMIT = 65536;

    public static WireTappedPrintStream make(PrintStream tappee) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            return new WireTappedPrintStream(bos, tappee, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new WireTappedPrintStream(bos, tappee, false);
        }
    }

    public static WireTappedPrintStream make(PrintStream tappee, boolean postponePassthrough) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            return new WireTappedPrintStream(bos, tappee, postponePassthrough, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new WireTappedPrintStream(bos, tappee, postponePassthrough);
        }
    }

    private WireTappedPrintStream(ByteArrayOutputStream s, PrintStream tappee, boolean postponePassthrough, String encoding) throws UnsupportedEncodingException {
        super((OutputStream)s, true, encoding);
        this.s = s;
        this.tappee = tappee;
        this.postponePassthrough = postponePassthrough;
    }

    private WireTappedPrintStream(ByteArrayOutputStream s, PrintStream tappee, boolean postponePassthrough) {
        super(s, true);
        this.s = s;
        this.tappee = tappee;
        this.postponePassthrough = postponePassthrough;
    }

    public String getString() throws UnsupportedEncodingException {
        this.flush();
        return this.s.toString("UTF-8");
    }

    @Override
    public void close() {
        super.close();
        this.tappee.close();
    }

    public void flush(boolean releasePostponed) throws IOException {
        super.flush();
        if (releasePostponed && this.postponePassthrough) {
            byte[] released = this.s.toByteArray();
            this.tappee.write(released, this.postponeStart, released.length - this.postponeStart);
            this.postponeStart = released.length;
        }
        this.tappee.flush();
    }

    @Override
    public void flush() {
        super.flush();
        this.tappee.flush();
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        super.write(arg0, arg1, arg2);
        if (!this.postponePassthrough) {
            this.tappee.write(arg0, arg1, arg2);
        }
    }

    @Override
    public void write(int arg0) {
        super.write(arg0);
        if (!this.postponePassthrough) {
            this.tappee.write(arg0);
        }
    }

    @Override
    public void write(byte[] arg0) throws IOException {
        super.write(arg0);
        if (!this.postponePassthrough) {
            this.tappee.write(arg0);
        }
    }
}

