/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
///<reference path='../ts-declarations/node.d.ts' />
///<reference path='../ts-declarations/jalangi.d.ts' />
/*
 * Copyright 2013 Samsung Information Systems America, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function computeTree(sizeAndStale, site, time) {
    //Filter out relevant objects
    var objs = sizeAndStale[site].filter(function (info) {
        return info.creationTime < time && info.unreachableTime > time;
    });
    //Bin according to last use site
    var lastUse = {};
    objs.forEach(function (elem) {
        var key = elem.lastUseSite === "null" ? "(never used)" : elem.lastUseSite;
        var arr = lastUse[key];
        if (arr === undefined) {
            arr = [];
            lastUse[key] = arr;
        }
        arr.push(elem);
    });
    var res = {};
    // Sub-bin according to unreach site
    Object.keys(lastUse).forEach(function (site) {
        var os = lastUse[site];
        var unreachBin = {};
        os.forEach(function (info) {
            var arr = unreachBin[info.unreachableSite];
            if (arr === undefined) {
                arr = [];
                unreachBin[info.unreachableSite] = arr;
            }
            arr.push(info);
        });
        res[site] = computeStats(unreachBin);
    });
    return res;
}
exports.computeTree = computeTree;
function computeStats(obs) {
    var res = {};
    Object.keys(obs).forEach(function (un, a, b) {
        res[un] = { max: max(obs[un]).staleness, min: min(obs[un]).staleness, avg: avg(obs[un]), count: obs[un].length };
    });
    return res;
}
function max(arr) {
    var res = arr[0];
    arr.forEach(function (i) {
        if (i.staleness > res.staleness)
            res = i;
    });
    return res;
}
function min(arr) {
    var res = arr[0];
    arr.forEach(function (i) {
        if (i.staleness < res.staleness)
            res = i;
    });
    return res;
}
function avg(arr) {
    var res = 0;
    arr.forEach(function (i) {
        res += i.staleness;
    });
    return res / arr.length;
}
//# sourceMappingURL=lastUseTree.js.map