/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.io.DirectOutputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ChecksumOutputStream
extends DirectOutputStream {
    private final Checksum _checksum;

    public ChecksumOutputStream(Checksum checksum) {
        this._checksum = checksum;
    }

    public long getValue() {
        return this._checksum.getValue();
    }

    public void close() {
    }

    public void flush() {
    }

    public void write(byte[] bbuf) {
        this._checksum.update(bbuf, 0, bbuf.length);
    }

    public void write(byte[] bbuf, int offset, int len) {
        this._checksum.update(bbuf, offset, len);
    }

    public void write(int b) {
        this._checksum.update(b);
    }

    public static ChecksumOutputStream makeCRC32() {
        return new ChecksumOutputStream(new CRC32());
    }

    public static ChecksumOutputStream makeAdler32() {
        return new ChecksumOutputStream(new Adler32());
    }
}

